
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * Departure (origin) Airport Code.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DepartureCode">
 *   &lt;xs:complexType>
 *     &lt;xs:simpleContent>
 *       &lt;xs:extension base="xs:string">
 *         &lt;xs:attributeGroup ref="RadiusAttrGroup"/>
 *       &lt;/xs:extension>
 *     &lt;/xs:simpleContent>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class DepartureCode implements Serializable
{
    private String string;
    private RadiusAttrGroup radiusAttrGroup;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
     * 
     * @return value
     */
    public RadiusAttrGroup getRadiusAttrGroup() {
        return radiusAttrGroup;
    }

    /** 
     * Set the 'RadiusAttrGroup' attributeGroup value. Search Radius for specified Airport or City code.
     * 
     * @param radiusAttrGroup
     */
    public void setRadiusAttrGroup(RadiusAttrGroup radiusAttrGroup) {
        this.radiusAttrGroup = radiusAttrGroup;
    }
}
