
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * A data type for DESCRIPTION Metadata.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DescriptionMetadataType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="MetadataObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="Application" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="Topic" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="Hint" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="Copyright" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="Sequence" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DescriptionMetadataType extends MetadataObjectBaseType implements
    Serializable
{
    private String application;
    private String topic;
    private String hint;
    private String copyright;
    private String sequence;

    /** 
     * Get the 'Application' element value. Description Application.  Examples: Marketing, TermsAndConditions
     * 
     * @return value
     */
    public String getApplication() {
        return application;
    }

    /** 
     * Set the 'Application' element value. Description Application.  Examples: Marketing, TermsAndConditions
     * 
     * @param application
     */
    public void setApplication(String application) {
        this.application = application;
    }

    /** 
     * Get the 'Topic' element value. Description topic. Example: Relax in the Lounge
     * 
     * @return value
     */
    public String getTopic() {
        return topic;
    }

    /** 
     * Set the 'Topic' element value. Description topic. Example: Relax in the Lounge
     * 
     * @param topic
     */
    public void setTopic(String topic) {
        this.topic = topic;
    }

    /** 
     * Get the 'Hint' element value. Hint. Example: Relax in the Lounge
     * 
     * @return value
     */
    public String getHint() {
        return hint;
    }

    /** 
     * Set the 'Hint' element value. Hint. Example: Relax in the Lounge
     * 
     * @param hint
     */
    public void setHint(String hint) {
        this.hint = hint;
    }

    /** 
     * Get the 'Copyright' element value. Description copyright.  Example: (c) ABC CO
     * 
     * @return value
     */
    public String getCopyright() {
        return copyright;
    }

    /** 
     * Set the 'Copyright' element value. Description copyright.  Example: (c) ABC CO
     * 
     * @param copyright
     */
    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    /** 
     * Get the 'Sequence' element value. Description Sequence (order) Number. Example: 1
     * 
     * @return value
     */
    public String getSequence() {
        return sequence;
    }

    /** 
     * Set the 'Sequence' element value. Description Sequence (order) Number. Example: 1
     * 
     * @param sequence
     */
    public void setSequence(String sequence) {
        this.sequence = sequence;
    }
}
