
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * DETAIL FARE BASIS, including code, price class name and application.NDC Capability Model: FARE - FARE BASIS CODE

 ============
 Feature(s)
 ============
 • Fare Basis Application (usage context) maybe specified (e.g. Requested, Ticketed, Other).

 ============
 Metadata
 ============
 • FareMetadata
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareBasisCodeType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Code"/>
 *     &lt;xs:element type="xs:string" name="Application" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class FareBasisCodeType implements Serializable
{
    private String code;
    private String application;
    private String refs;

    /** 
     * Get the 'Code' element value. Fare basis code. Example: Y26
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'Code' element value. Fare basis code. Example: Y26
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'Application' element value. Fare basis application.
    Examples: Requested, Ticketed, Other
     * 
     * @return value
     */
    public String getApplication() {
        return application;
    }

    /** 
     * Set the 'Application' element value. Fare basis application.
    Examples: Requested, Ticketed, Other
     * 
     * @param application
     */
    public void setApplication(String application) {
        this.application = application;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
