
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * FARE COMPONENT definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareComponentType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Parameters" minOccurs="0">
 *       &lt;!-- Reference to inner class Parameters -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="FarePriceDetailType" name="Price" minOccurs="0"/>
 *     &lt;xs:element name="FareBasis" minOccurs="0">
 *       &lt;!-- Reference to inner class FareBasis -->
 *     &lt;/xs:element>
 *     &lt;xs:element ref="TicketDesig" minOccurs="0"/>
 *     &lt;xs:element ref="FareRules" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PriceClassRef" minOccurs="0"/>
 *     &lt;xs:element name="SegmentRefs" minOccurs="0">
 *       &lt;!-- Reference to inner class SegmentRefs -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FareComponentType implements Serializable
{
    private Parameters parameters;
    private FarePriceDetailType price;
    private FareBasis fareBasis;
    private TicketDesignatorType ticketDesig;
    private FareRulesType fareRules;
    private String priceClassRef;
    private SegmentRefs segmentRefs;

    /** 
     * Get the 'Parameters' element value.
     * 
     * @return value
     */
    public Parameters getParameters() {
        return parameters;
    }

    /** 
     * Set the 'Parameters' element value.
     * 
     * @param parameters
     */
    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    /** 
     * Get the 'Price' element value. Fare Component Pricing information.
     * 
     * @return value
     */
    public FarePriceDetailType getPrice() {
        return price;
    }

    /** 
     * Set the 'Price' element value. Fare Component Pricing information.
     * 
     * @param price
     */
    public void setPrice(FarePriceDetailType price) {
        this.price = price;
    }

    /** 
     * Get the 'FareBasis' element value.
     * 
     * @return value
     */
    public FareBasis getFareBasis() {
        return fareBasis;
    }

    /** 
     * Set the 'FareBasis' element value.
     * 
     * @param fareBasis
     */
    public void setFareBasis(FareBasis fareBasis) {
        this.fareBasis = fareBasis;
    }

    /** 
     * Get the 'TicketDesig' element value.
     * 
     * @return value
     */
    public TicketDesignatorType getTicketDesig() {
        return ticketDesig;
    }

    /** 
     * Set the 'TicketDesig' element value.
     * 
     * @param ticketDesig
     */
    public void setTicketDesig(TicketDesignatorType ticketDesig) {
        this.ticketDesig = ticketDesig;
    }

    /** 
     * Get the 'FareRules' element value.
     * 
     * @return value
     */
    public FareRulesType getFareRules() {
        return fareRules;
    }

    /** 
     * Set the 'FareRules' element value.
     * 
     * @param fareRules
     */
    public void setFareRules(FareRulesType fareRules) {
        this.fareRules = fareRules;
    }

    /** 
     * Get the 'PriceClassRef' element value.
     * 
     * @return value
     */
    public String getPriceClassRef() {
        return priceClassRef;
    }

    /** 
     * Set the 'PriceClassRef' element value.
     * 
     * @param priceClassRef
     */
    public void setPriceClassRef(String priceClassRef) {
        this.priceClassRef = priceClassRef;
    }

    /** 
     * Get the 'SegmentRefs' element value.
     * 
     * @return value
     */
    public SegmentRefs getSegmentRefs() {
        return segmentRefs;
    }

    /** 
     * Set the 'SegmentRefs' element value.
     * 
     * @param segmentRefs
     */
    public void setSegmentRefs(SegmentRefs segmentRefs) {
        this.segmentRefs = segmentRefs;
    }
    /** 
     * Fare Component-related parameters.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Parameters" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Quantity"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Parameters implements Serializable
    {
        private String quantity;

        /** 
         * Get the 'Quantity' attribute value. The total number of fare components within the fare component calculation. Example: 2
         * 
         * @return value
         */
        public String getQuantity() {
            return quantity;
        }

        /** 
         * Set the 'Quantity' attribute value. The total number of fare components within the fare component calculation. Example: 2
         * 
         * @param quantity
         */
        public void setQuantity(String quantity) {
            this.quantity = quantity;
        }
    }
    /** 
     * Fare Basis information, including Fare Basis Code, Fare Rule Remarks and Fare Basis City Pair.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareBasis" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="FareBasisCode" minOccurs="0"/>
     *       &lt;xs:element ref="FareRulesRemarks" minOccurs="0"/>
     *       &lt;xs:element ref="FareBasisCityPair" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="RBD" minOccurs="0"/>
     *       &lt;xs:element name="CabinType">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element type="xs:string" name="CabinTypeCode"/>
     *             &lt;xs:element type="xs:string" name="CabinTypeName"/>
     *           &lt;/xs:sequence>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FareBasis implements Serializable
    {
        private FareBasisCodeType fareBasisCode;
        private FareRulesRemarks fareRulesRemarks;
        private FareBasisCityPair fareBasisCityPair;
        private String RBD;
        private String cabinTypeCabinTypeCode;
        private String cabinTypeCabinTypeName;

        /** 
         * Get the 'FareBasisCode' element value.
         * 
         * @return value
         */
        public FareBasisCodeType getFareBasisCode() {
            return fareBasisCode;
        }

        /** 
         * Set the 'FareBasisCode' element value.
         * 
         * @param fareBasisCode
         */
        public void setFareBasisCode(FareBasisCodeType fareBasisCode) {
            this.fareBasisCode = fareBasisCode;
        }

        /** 
         * Get the 'FareRulesRemarks' element value.
         * 
         * @return value
         */
        public FareRulesRemarks getFareRulesRemarks() {
            return fareRulesRemarks;
        }

        /** 
         * Set the 'FareRulesRemarks' element value.
         * 
         * @param fareRulesRemarks
         */
        public void setFareRulesRemarks(FareRulesRemarks fareRulesRemarks) {
            this.fareRulesRemarks = fareRulesRemarks;
        }

        /** 
         * Get the 'FareBasisCityPair' element value.
         * 
         * @return value
         */
        public FareBasisCityPair getFareBasisCityPair() {
            return fareBasisCityPair;
        }

        /** 
         * Set the 'FareBasisCityPair' element value.
         * 
         * @param fareBasisCityPair
         */
        public void setFareBasisCityPair(FareBasisCityPair fareBasisCityPair) {
            this.fareBasisCityPair = fareBasisCityPair;
        }

        /** 
         * Get the 'RBD' element value. Reservation Booking Designator or Booking Class e.g. T
         * 
         * @return value
         */
        public String getRBD() {
            return RBD;
        }

        /** 
         * Set the 'RBD' element value. Reservation Booking Designator or Booking Class e.g. T
         * 
         * @param RBD
         */
        public void setRBD(String RBD) {
            this.RBD = RBD;
        }

        /** 
         * Get the 'CabinTypeCode' element value.
         * 
         * @return value
         */
        public String getCabinTypeCabinTypeCode() {
            return cabinTypeCabinTypeCode;
        }

        /** 
         * Set the 'CabinTypeCode' element value.
         * 
         * @param cabinTypeCabinTypeCode
         */
        public void setCabinTypeCabinTypeCode(String cabinTypeCabinTypeCode) {
            this.cabinTypeCabinTypeCode = cabinTypeCabinTypeCode;
        }

        /** 
         * Get the 'CabinTypeName' element value.
         * 
         * @return value
         */
        public String getCabinTypeCabinTypeName() {
            return cabinTypeCabinTypeName;
        }

        /** 
         * Set the 'CabinTypeName' element value.
         * 
         * @param cabinTypeCabinTypeName
         */
        public void setCabinTypeCabinTypeName(String cabinTypeCabinTypeName) {
            this.cabinTypeCabinTypeName = cabinTypeCabinTypeName;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SegmentRefs" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:string" use="optional" name="ON_Point"/>
     *         &lt;xs:attribute type="xs:string" use="optional" name="OFF_Point"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SegmentRefs implements Serializable
    {
        private String string;
        private String ONPoint;
        private String OFFPoint;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'ON_Point' attribute value. Flight Slice ON Point.  Example: ORD

        Encoding Scheme: IATA/ A4A (three character) Airport or City Code
         * 
         * @return value
         */
        public String getONPoint() {
            return ONPoint;
        }

        /** 
         * Set the 'ON_Point' attribute value. Flight Slice ON Point.  Example: ORD

        Encoding Scheme: IATA/ A4A (three character) Airport or City Code
         * 
         * @param ONPoint
         */
        public void setONPoint(String ONPoint) {
            this.ONPoint = ONPoint;
        }

        /** 
         * Get the 'OFF_Point' attribute value. Flight Slice OFF Point.  Example: NYC

        Encoding Scheme: IATA/ A4A (three character) Airport or City Code
         * 
         * @return value
         */
        public String getOFFPoint() {
            return OFFPoint;
        }

        /** 
         * Set the 'OFF_Point' attribute value. Flight Slice OFF Point.  Example: NYC

        Encoding Scheme: IATA/ A4A (three character) Airport or City Code
         * 
         * @param OFFPoint
         */
        public void setOFFPoint(String OFFPoint) {
            this.OFFPoint = OFFPoint;
        }
    }
}
