
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * A data type for Fare Global Indicator contextual list.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareIndicatorListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="AL"/>
 *     &lt;xs:enumeration value="AP"/>
 *     &lt;xs:enumeration value="AT"/>
 *     &lt;xs:enumeration value="CA"/>
 *     &lt;xs:enumeration value="CT"/>
 *     &lt;xs:enumeration value="EH"/>
 *     &lt;xs:enumeration value="FE"/>
 *     &lt;xs:enumeration value="IN"/>
 *     &lt;xs:enumeration value="NA"/>
 *     &lt;xs:enumeration value="PA"/>
 *     &lt;xs:enumeration value="PN"/>
 *     &lt;xs:enumeration value="PO"/>
 *     &lt;xs:enumeration value="RU"/>
 *     &lt;xs:enumeration value="RW"/>
 *     &lt;xs:enumeration value="SA"/>
 *     &lt;xs:enumeration value="SP"/>
 *     &lt;xs:enumeration value="TB"/>
 *     &lt;xs:enumeration value="TS"/>
 *     &lt;xs:enumeration value="US"/>
 *     &lt;xs:enumeration value="WH"/>
 *     &lt;xs:enumeration value="ZZ"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum FareIndicatorListType implements Serializable {
    /** 
     * FareByRule, All fares included (EH/TS)
    
     */
    AL("AL"), /** 
               * Via Atlantic Pacific
               */
    AP("AP"), /** 
               * Via Atlantic
               */
    AT("AT"), /** 
               * Within Canada.
               */
    CA("CA"), /** 
               * Circle trip.
               */
    CT("CT"), /** 
               * Within Eastern Hemisphere
                        
               */
    EH("EH"), /** 
               * Far East
               */
    FE("FE"), /** 
               * FareByRule - For int'l incl.
                            AT/PA/WH/CT/RW
               */
    IN("IN"), /** 
               * FareByRule for North America incl
                            US/CA/TB/PV
               */
    NA("NA"), /** 
               * Via Pacific
               */
    PA("PA"), /** 
               * Via Pacific and via North America
                        
               */
    PN("PN"), /** 
               * Via Polar Route.
               */
    PO("PO"), /** 
               * Russia - Area 3 
               */
    RU("RU"), /** 
               * Round The World.
               */
    RW("RW"), /** 
               * South Atlantic only
               */
    SA("SA"), /** 
               * Via South Polar Route
               */
    SP("SP"), /** 
               * Trans-border
               */
    TB("TB"), /** 
               * Via Siberia.
               */
    TS("TS"), /** 
               * Within the United States.
                        
               */
    US("US"), /** 
               * Within Western Hemisphere
                        
               */
    WH("WH"), /** 
               * Any Global
               */
    ZZ("ZZ"), OTHER("Other");
    private final String value;

    private FareIndicatorListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static FareIndicatorListType convert(String value) {
        for (FareIndicatorListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
