
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import org.joda.time.LocalDate;

/** 
 * FARE PRICE DETAIL definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FarePriceDetailType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="FarePriceBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="TaxDetailType" name="Taxes" minOccurs="0"/>
 *         &lt;xs:element ref="TaxExemption" minOccurs="0"/>
 *         &lt;xs:element type="xs:date" name="RequestedDate" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="Alignment" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FarePriceDetailType extends FarePriceBaseType implements
    Serializable
{
    private TaxDetailType taxes;
    private TaxExemptionType taxExemption;
    private LocalDate requestedDate;
    private String alignment;

    /** 
     * Get the 'Taxes' element value. Ticket Tax/fee/charge details to indicate taxes that apply to country of commencement of travel and routing.
     * 
     * @return value
     */
    public TaxDetailType getTaxes() {
        return taxes;
    }

    /** 
     * Set the 'Taxes' element value. Ticket Tax/fee/charge details to indicate taxes that apply to country of commencement of travel and routing.
     * 
     * @param taxes
     */
    public void setTaxes(TaxDetailType taxes) {
        this.taxes = taxes;
    }

    /** 
     * Get the 'TaxExemption' element value.
     * 
     * @return value
     */
    public TaxExemptionType getTaxExemption() {
        return taxExemption;
    }

    /** 
     * Set the 'TaxExemption' element value.
     * 
     * @param taxExemption
     */
    public void setTaxExemption(TaxExemptionType taxExemption) {
        this.taxExemption = taxExemption;
    }

    /** 
     * Get the 'RequestedDate' element value. Actual travel date requested by Traveler. Example: 2017-01-13

    Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
     * 
     * @return value
     */
    public LocalDate getRequestedDate() {
        return requestedDate;
    }

    /** 
     * Set the 'RequestedDate' element value. Actual travel date requested by Traveler. Example: 2017-01-13

    Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
     * 
     * @param requestedDate
     */
    public void setRequestedDate(LocalDate requestedDate) {
        this.requestedDate = requestedDate;
    }

    /** 
     * Get the 'Alignment' element value. Alignment with the actual travel date requested by the Traveler. Example: ADA (AFTER DATE BASED ON ARRIVAL)

    Encoding Scheme: IATA PADIS code list CSD-Calendar Shopping Date
     * 
     * @return value
     */
    public String getAlignment() {
        return alignment;
    }

    /** 
     * Set the 'Alignment' element value. Alignment with the actual travel date requested by the Traveler. Example: ADA (AFTER DATE BASED ON ARRIVAL)

    Encoding Scheme: IATA PADIS code list CSD-Calendar Shopping Date
     * 
     * @param alignment
     */
    public void setAlignment(String alignment) {
        this.alignment = alignment;
    }
}
