
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for Flight Preferences.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightPreferencesType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Aircraft" minOccurs="0">
 *       &lt;!-- Reference to inner class Aircraft -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Characteristic" minOccurs="0">
 *       &lt;!-- Reference to inner class Characteristic -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="WaitListing" minOccurs="0">
 *       &lt;!-- Reference to inner class WaitListing -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class FlightPreferencesType implements Serializable
{
    private Aircraft aircraft;
    private Characteristic characteristic;
    private WaitListing waitListing;
    private String refs;

    /** 
     * Get the 'Aircraft' element value.
     * 
     * @return value
     */
    public Aircraft getAircraft() {
        return aircraft;
    }

    /** 
     * Set the 'Aircraft' element value.
     * 
     * @param aircraft
     */
    public void setAircraft(Aircraft aircraft) {
        this.aircraft = aircraft;
    }

    /** 
     * Get the 'Characteristic' element value.
     * 
     * @return value
     */
    public Characteristic getCharacteristic() {
        return characteristic;
    }

    /** 
     * Set the 'Characteristic' element value.
     * 
     * @param characteristic
     */
    public void setCharacteristic(Characteristic characteristic) {
        this.characteristic = characteristic;
    }

    /** 
     * Get the 'WaitListing' element value.
     * 
     * @return value
     */
    public WaitListing getWaitListing() {
        return waitListing;
    }

    /** 
     * Set the 'WaitListing' element value.
     * 
     * @param waitListing
     */
    public void setWaitListing(WaitListing waitListing) {
        this.waitListing = waitListing;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Aircraft Features, including Equipment, Cabin Type, Class of Service, Seats, Rows and Tail Number. The IATA aircraft type; use SSIM Appendix A.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Aircraft" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="AircraftCodeQueryType" name="Equipment" minOccurs="0"/>
     *       &lt;xs:choice>
     *         &lt;xs:element name="Cabins" minOccurs="0">
     *           &lt;!-- Reference to inner class Cabins -->
     *         &lt;/xs:element>
     *         &lt;xs:element name="Classes" minOccurs="0">
     *           &lt;!-- Reference to inner class Classes -->
     *         &lt;/xs:element>
     *       &lt;/xs:choice>
     *       &lt;xs:element name="Seats" minOccurs="0">
     *         &lt;!-- Reference to inner class Seats -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Rows" minOccurs="0">
     *         &lt;!-- Reference to inner class Rows -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="AircraftFeaturesQueryType" name="Features" minOccurs="0"/>
     *       &lt;xs:element type="AircraftTailNmbrQueryType" name="TailNumbers" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Aircraft implements Serializable
    {
        private AircraftCodeQueryType equipment;
        private int choiceSelect = -1;
        private static final int CABINS_CHOICE = 0;
        private static final int CLASSES_CHOICE = 1;
        private Cabins cabins;
        private Classes classes;
        private Seats seats;
        private Rows rows;
        private AircraftFeaturesQueryType features;
        private AircraftTailNmbrQueryType tailNumbers;
        private String refs;

        /** 
         * Get the 'Equipment' element value. Aircraft Equipment.
         * 
         * @return value
         */
        public AircraftCodeQueryType getEquipment() {
            return equipment;
        }

        /** 
         * Set the 'Equipment' element value. Aircraft Equipment.
         * 
         * @param equipment
         */
        public void setEquipment(AircraftCodeQueryType equipment) {
            this.equipment = equipment;
        }

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if Cabins is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifCabins() {
            return choiceSelect == CABINS_CHOICE;
        }

        /** 
         * Get the 'Cabins' element value.
         * 
         * @return value
         */
        public Cabins getCabins() {
            return cabins;
        }

        /** 
         * Set the 'Cabins' element value.
         * 
         * @param cabins
         */
        public void setCabins(Cabins cabins) {
            setChoiceSelect(CABINS_CHOICE);
            this.cabins = cabins;
        }

        /** 
         * Check if Classes is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifClasses() {
            return choiceSelect == CLASSES_CHOICE;
        }

        /** 
         * Get the 'Classes' element value.
         * 
         * @return value
         */
        public Classes getClasses() {
            return classes;
        }

        /** 
         * Set the 'Classes' element value.
         * 
         * @param classes
         */
        public void setClasses(Classes classes) {
            setChoiceSelect(CLASSES_CHOICE);
            this.classes = classes;
        }

        /** 
         * Get the 'Seats' element value.
         * 
         * @return value
         */
        public Seats getSeats() {
            return seats;
        }

        /** 
         * Set the 'Seats' element value.
         * 
         * @param seats
         */
        public void setSeats(Seats seats) {
            this.seats = seats;
        }

        /** 
         * Get the 'Rows' element value.
         * 
         * @return value
         */
        public Rows getRows() {
            return rows;
        }

        /** 
         * Set the 'Rows' element value.
         * 
         * @param rows
         */
        public void setRows(Rows rows) {
            this.rows = rows;
        }

        /** 
         * Get the 'Features' element value. Aircraft Features.
         * 
         * @return value
         */
        public AircraftFeaturesQueryType getFeatures() {
            return features;
        }

        /** 
         * Set the 'Features' element value. Aircraft Features.
         * 
         * @param features
         */
        public void setFeatures(AircraftFeaturesQueryType features) {
            this.features = features;
        }

        /** 
         * Get the 'TailNumbers' element value. Aircraft Tail Number(s).
         * 
         * @return value
         */
        public AircraftTailNmbrQueryType getTailNumbers() {
            return tailNumbers;
        }

        /** 
         * Set the 'TailNumbers' element value. Aircraft Tail Number(s).
         * 
         * @param tailNumbers
         */
        public void setTailNumbers(AircraftTailNmbrQueryType tailNumbers) {
            this.tailNumbers = tailNumbers;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
        /** 
         * Cabin Class.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Cabins" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Cabin" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Cabin -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class Cabins implements Serializable
        {
            private List<Cabin> cabinList = new ArrayList<Cabin>();
            private String refs;

            /** 
             * Get the list of 'Cabin' element items.
             * 
             * @return list
             */
            public List<Cabin> getCabinList() {
                return cabinList;
            }

            /** 
             * Set the list of 'Cabin' element items.
             * 
             * @param list
             */
            public void setCabinList(List<Cabin> list) {
                cabinList = list;
            }

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getRefs() {
                return refs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param refs
             */
            public void setRefs(String refs) {
                this.refs = refs;
            }
            /** 
             * Cabin type. Examples: First Class, Business Class

            Encoding Scheme: PADIS codeset element 9873 - Cabin Class of Service
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Cabin" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attributeGroup ref="PreferenceAttrGroup"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Cabin implements Serializable
            {
                private String string;
                private PreferenceAttrGroup preferenceAttrGroup;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'PreferenceAttrGroup' attributeGroup value.
                 * 
                 * @return value
                 */
                public PreferenceAttrGroup getPreferenceAttrGroup() {
                    return preferenceAttrGroup;
                }

                /** 
                 * Set the 'PreferenceAttrGroup' attributeGroup value.
                 * 
                 * @param preferenceAttrGroup
                 */
                public void setPreferenceAttrGroup(
                        PreferenceAttrGroup preferenceAttrGroup) {
                    this.preferenceAttrGroup = preferenceAttrGroup;
                }
            }
        }
        /** 
         * Desired Class(es) of Service.
        Example: Y
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Classes" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Class" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class _Class -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class Classes implements Serializable
        {
            private List<_Class> classList = new ArrayList<_Class>();
            private String refs;

            /** 
             * Get the list of 'Class' element items.
             * 
             * @return list
             */
            public List<_Class> getClassList() {
                return classList;
            }

            /** 
             * Set the list of 'Class' element items.
             * 
             * @param list
             */
            public void setClassList(List<_Class> list) {
                classList = list;
            }

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getRefs() {
                return refs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param refs
             */
            public void setRefs(String refs) {
                this.refs = refs;
            }
            /** 
             * Class of Service. Example: Y
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Class" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attributeGroup ref="PreferenceAttrGroup"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class _Class implements Serializable
            {
                private String string;
                private PreferenceAttrGroup preferenceAttrGroup;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'PreferenceAttrGroup' attributeGroup value.
                 * 
                 * @return value
                 */
                public PreferenceAttrGroup getPreferenceAttrGroup() {
                    return preferenceAttrGroup;
                }

                /** 
                 * Set the 'PreferenceAttrGroup' attributeGroup value.
                 * 
                 * @param preferenceAttrGroup
                 */
                public void setPreferenceAttrGroup(
                        PreferenceAttrGroup preferenceAttrGroup) {
                    this.preferenceAttrGroup = preferenceAttrGroup;
                }
            }
        }
        /** 
         * Seat(s).
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Seats" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Characteristic" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Characteristic -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Position" minOccurs="0">
         *         &lt;!-- Reference to inner class Position -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class Seats implements Serializable
        {
            private List<Characteristic> characteristicList = new ArrayList<Characteristic>();
            private Position position;
            private String refs;

            /** 
             * Get the list of 'Characteristic' element items.
             * 
             * @return list
             */
            public List<Characteristic> getCharacteristicList() {
                return characteristicList;
            }

            /** 
             * Set the list of 'Characteristic' element items.
             * 
             * @param list
             */
            public void setCharacteristicList(List<Characteristic> list) {
                characteristicList = list;
            }

            /** 
             * Get the 'Position' element value.
             * 
             * @return value
             */
            public Position getPosition() {
                return position;
            }

            /** 
             * Set the 'Position' element value.
             * 
             * @param position
             */
            public void setPosition(Position position) {
                this.position = position;
            }

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getRefs() {
                return refs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param refs
             */
            public void setRefs(String refs) {
                this.refs = refs;
            }
            /** 
             * Seat characteristic value.  Example: L (LEG SPACE SEAT).  Refer to PADIS code list 9825.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Characteristic" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attributeGroup ref="PreferenceAttrGroup"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Characteristic implements Serializable
            {
                private String string;
                private PreferenceAttrGroup preferenceAttrGroup;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'PreferenceAttrGroup' attributeGroup value.
                 * 
                 * @return value
                 */
                public PreferenceAttrGroup getPreferenceAttrGroup() {
                    return preferenceAttrGroup;
                }

                /** 
                 * Set the 'PreferenceAttrGroup' attributeGroup value.
                 * 
                 * @param preferenceAttrGroup
                 */
                public void setPreferenceAttrGroup(
                        PreferenceAttrGroup preferenceAttrGroup) {
                    this.preferenceAttrGroup = preferenceAttrGroup;
                }
            }
            /** 
             * Refers to position on the aircraft; seat option codes.  Examples: E (EXIT ROW), M (Middle Seat), A (Aisle seat), L (Left side of aircraft), Q (Bulk Head).  Refer to PADIS code list 9825.

             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Position" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:complexContent>
             *       &lt;xs:extension base="CodesetType">
             *         &lt;xs:sequence>
             *           &lt;xs:element type="xs:string" name="SeatRowNmber" minOccurs="0"/>
             *         &lt;/xs:sequence>
             *       &lt;/xs:extension>
             *     &lt;/xs:complexContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Position extends CodesetType implements
                Serializable
            {
                private String seatRowNmber;

                /** 
                 * Get the 'SeatRowNmber' element value. Seat Row Number.  Example: 3
                 * 
                 * @return value
                 */
                public String getSeatRowNmber() {
                    return seatRowNmber;
                }

                /** 
                 * Set the 'SeatRowNmber' element value. Seat Row Number.  Example: 3
                 * 
                 * @param seatRowNmber
                 */
                public void setSeatRowNmber(String seatRowNmber) {
                    this.seatRowNmber = seatRowNmber;
                }
            }
        }
        /** 
         * Cabin Row Number(s) and Row Feature(s) to specify in preferences.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Rows" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Feature" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Feature -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Number" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class _Number -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Rows implements Serializable
        {
            private List<Feature> featureList = new ArrayList<Feature>();
            private List<_Number> numberList = new ArrayList<_Number>();

            /** 
             * Get the list of 'Feature' element items.
             * 
             * @return list
             */
            public List<Feature> getFeatureList() {
                return featureList;
            }

            /** 
             * Set the list of 'Feature' element items.
             * 
             * @param list
             */
            public void setFeatureList(List<Feature> list) {
                featureList = list;
            }

            /** 
             * Get the list of 'Number' element items.
             * 
             * @return list
             */
            public List<_Number> getNumberList() {
                return numberList;
            }

            /** 
             * Set the list of 'Number' element items.
             * 
             * @param list
             */
            public void setNumberList(List<_Number> list) {
                numberList = list;
            }
            /** 
             * Row feature value.  Example: E (EXIT ROW)

            Encoding Scheme: IATA PADIS Code List for data element 9864
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Feature" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attributeGroup ref="PreferenceAttrGroup"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Feature implements Serializable
            {
                private String string;
                private PreferenceAttrGroup preferenceAttrGroup;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'PreferenceAttrGroup' attributeGroup value.
                 * 
                 * @return value
                 */
                public PreferenceAttrGroup getPreferenceAttrGroup() {
                    return preferenceAttrGroup;
                }

                /** 
                 * Set the 'PreferenceAttrGroup' attributeGroup value.
                 * 
                 * @param preferenceAttrGroup
                 */
                public void setPreferenceAttrGroup(
                        PreferenceAttrGroup preferenceAttrGroup) {
                    this.preferenceAttrGroup = preferenceAttrGroup;
                }
            }
            /** 
             * Preferred row number.  Example: 10
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Number" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attributeGroup ref="PreferenceAttrGroup"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class _Number implements Serializable
            {
                private String string;
                private PreferenceAttrGroup preferenceAttrGroup;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'PreferenceAttrGroup' attributeGroup value.
                 * 
                 * @return value
                 */
                public PreferenceAttrGroup getPreferenceAttrGroup() {
                    return preferenceAttrGroup;
                }

                /** 
                 * Set the 'PreferenceAttrGroup' attributeGroup value.
                 * 
                 * @param preferenceAttrGroup
                 */
                public void setPreferenceAttrGroup(
                        PreferenceAttrGroup preferenceAttrGroup) {
                    this.preferenceAttrGroup = preferenceAttrGroup;
                }
            }
        }
    }
    /** 
     * Flight Characteristics, e.g. non-stop, red eye, etc.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Characteristic" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="NonStopPreferences" minOccurs="0">
     *         &lt;!-- Reference to inner class NonStopPreferences -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="DirectPreferences" minOccurs="0">
     *         &lt;!-- Reference to inner class DirectPreferences -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="OvernightStopPreferences" minOccurs="0">
     *         &lt;!-- Reference to inner class OvernightStopPreferences -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="AirportChangePreferences" minOccurs="0">
     *         &lt;!-- Reference to inner class AirportChangePreferences -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="RedEyePreferences" minOccurs="0">
     *         &lt;!-- Reference to inner class RedEyePreferences -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Characteristic implements Serializable
    {
        private NonStopPreferences nonStopPreferences;
        private DirectPreferences directPreferences;
        private OvernightStopPreferences overnightStopPreferences;
        private AirportChangePreferences airportChangePreferences;
        private RedEyePreferences redEyePreferences;
        private String refs;

        /** 
         * Get the 'NonStopPreferences' element value.
         * 
         * @return value
         */
        public NonStopPreferences getNonStopPreferences() {
            return nonStopPreferences;
        }

        /** 
         * Set the 'NonStopPreferences' element value.
         * 
         * @param nonStopPreferences
         */
        public void setNonStopPreferences(NonStopPreferences nonStopPreferences) {
            this.nonStopPreferences = nonStopPreferences;
        }

        /** 
         * Get the 'DirectPreferences' element value.
         * 
         * @return value
         */
        public DirectPreferences getDirectPreferences() {
            return directPreferences;
        }

        /** 
         * Set the 'DirectPreferences' element value.
         * 
         * @param directPreferences
         */
        public void setDirectPreferences(DirectPreferences directPreferences) {
            this.directPreferences = directPreferences;
        }

        /** 
         * Get the 'OvernightStopPreferences' element value.
         * 
         * @return value
         */
        public OvernightStopPreferences getOvernightStopPreferences() {
            return overnightStopPreferences;
        }

        /** 
         * Set the 'OvernightStopPreferences' element value.
         * 
         * @param overnightStopPreferences
         */
        public void setOvernightStopPreferences(
                OvernightStopPreferences overnightStopPreferences) {
            this.overnightStopPreferences = overnightStopPreferences;
        }

        /** 
         * Get the 'AirportChangePreferences' element value.
         * 
         * @return value
         */
        public AirportChangePreferences getAirportChangePreferences() {
            return airportChangePreferences;
        }

        /** 
         * Set the 'AirportChangePreferences' element value.
         * 
         * @param airportChangePreferences
         */
        public void setAirportChangePreferences(
                AirportChangePreferences airportChangePreferences) {
            this.airportChangePreferences = airportChangePreferences;
        }

        /** 
         * Get the 'RedEyePreferences' element value.
         * 
         * @return value
         */
        public RedEyePreferences getRedEyePreferences() {
            return redEyePreferences;
        }

        /** 
         * Set the 'RedEyePreferences' element value.
         * 
         * @param redEyePreferences
         */
        public void setRedEyePreferences(RedEyePreferences redEyePreferences) {
            this.redEyePreferences = redEyePreferences;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
        /** 
         * Non-Stop Flight preference level. Examples: Preferred, Exclude
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NonStopPreferences" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" use="optional" name="PreferencesContext"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class NonStopPreferences implements Serializable
        {
            private String string;
            private String preferencesContext;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'PreferencesContext' attribute value. Preference Level Context.  Example: MyContext
             * 
             * @return value
             */
            public String getPreferencesContext() {
                return preferencesContext;
            }

            /** 
             * Set the 'PreferencesContext' attribute value. Preference Level Context.  Example: MyContext
             * 
             * @param preferencesContext
             */
            public void setPreferencesContext(String preferencesContext) {
                this.preferencesContext = preferencesContext;
            }
        }
        /** 
         * Shopping preference for unticketed stop flight preference 
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DirectPreferences" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" use="optional" name="PreferencesContext"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class DirectPreferences implements Serializable
        {
            private String string;
            private String preferencesContext;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'PreferencesContext' attribute value. Preference Level Context.  Example: MyContext
             * 
             * @return value
             */
            public String getPreferencesContext() {
                return preferencesContext;
            }

            /** 
             * Set the 'PreferencesContext' attribute value. Preference Level Context.  Example: MyContext
             * 
             * @param preferencesContext
             */
            public void setPreferencesContext(String preferencesContext) {
                this.preferencesContext = preferencesContext;
            }
        }
        /** 
         * Flights with overnight lodging preference. 
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OvernightStopPreferences" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" use="optional" name="PreferencesContext"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OvernightStopPreferences implements Serializable
        {
            private String string;
            private String preferencesContext;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'PreferencesContext' attribute value. Preference Level Context.  Example: MyContext
             * 
             * @return value
             */
            public String getPreferencesContext() {
                return preferencesContext;
            }

            /** 
             * Set the 'PreferencesContext' attribute value. Preference Level Context.  Example: MyContext
             * 
             * @param preferencesContext
             */
            public void setPreferencesContext(String preferencesContext) {
                this.preferencesContext = preferencesContext;
            }
        }
        /** 
         * Flights with change of airport preference.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirportChangePreferences" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" use="optional" name="PreferencesContext"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AirportChangePreferences implements Serializable
        {
            private String string;
            private String preferencesContext;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'PreferencesContext' attribute value. Preference Level Context.  Example: MyContext
             * 
             * @return value
             */
            public String getPreferencesContext() {
                return preferencesContext;
            }

            /** 
             * Set the 'PreferencesContext' attribute value. Preference Level Context.  Example: MyContext
             * 
             * @param preferencesContext
             */
            public void setPreferencesContext(String preferencesContext) {
                this.preferencesContext = preferencesContext;
            }
        }
        /** 
         * Red eye flight preference.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RedEyePreferences" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" use="optional" name="PreferencesContext"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class RedEyePreferences implements Serializable
        {
            private String string;
            private String preferencesContext;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'PreferencesContext' attribute value. Preference Level Context.  Example: MyContext
             * 
             * @return value
             */
            public String getPreferencesContext() {
                return preferencesContext;
            }

            /** 
             * Set the 'PreferencesContext' attribute value. Preference Level Context.  Example: MyContext
             * 
             * @param preferencesContext
             */
            public void setPreferencesContext(String preferencesContext) {
                this.preferencesContext = preferencesContext;
            }
        }
    }
    /** 
     * Wait Listing.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="WaitListing" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="WaitListPreferences" minOccurs="0">
     *         &lt;!-- Reference to inner class WaitListPreferences -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class WaitListing implements Serializable
    {
        private WaitListPreferences waitListPreferences;
        private String refs;

        /** 
         * Get the 'WaitListPreferences' element value.
         * 
         * @return value
         */
        public WaitListPreferences getWaitListPreferences() {
            return waitListPreferences;
        }

        /** 
         * Set the 'WaitListPreferences' element value.
         * 
         * @param waitListPreferences
         */
        public void setWaitListPreferences(
                WaitListPreferences waitListPreferences) {
            this.waitListPreferences = waitListPreferences;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
        /** 
         * Wait-Listing Shopping preference level.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="WaitListPreferences" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" use="optional" name="PreferencesContext"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class WaitListPreferences implements Serializable
        {
            private String string;
            private String preferencesContext;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'PreferencesContext' attribute value. Preference Level Context.  Example: MyContext
             * 
             * @return value
             */
            public String getPreferencesContext() {
                return preferencesContext;
            }

            /** 
             * Set the 'PreferencesContext' attribute value. Preference Level Context.  Example: MyContext
             * 
             * @param preferencesContext
             */
            public void setPreferencesContext(String preferencesContext) {
                this.preferencesContext = preferencesContext;
            }
        }
    }
}
