
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Flight Price definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GenericPriceType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="CurrencyAmountOptType" name="BaseAmount" minOccurs="0"/>
 *     &lt;xs:element name="Equivalent" minOccurs="0"/>
 *     &lt;xs:element name="Surcharges" minOccurs="0">
 *       &lt;!-- Reference to inner class Surcharges -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="TaxDetailType" name="Taxes" minOccurs="0"/>
 *     &lt;xs:element ref="TaxExemption" minOccurs="0"/>
 *     &lt;xs:element type="FeeSurchargeType" name="Fees" minOccurs="0"/>
 *     &lt;xs:element name="Total" minOccurs="0">
 *       &lt;!-- Reference to inner class Total -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class GenericPriceType implements Serializable
{
    private CurrencyAmountOptType baseAmount;
    private boolean equivalent;
    private Surcharges surcharges;
    private TaxDetailType taxes;
    private TaxExemptionType taxExemption;
    private FeeSurchargeType fees;
    private Total total;

    /** 
     * Get the 'BaseAmount' element value. Total Base Fare Amount.  Example: 200000

    Note: This includes  surcharges (if applicable).
     * 
     * @return value
     */
    public CurrencyAmountOptType getBaseAmount() {
        return baseAmount;
    }

    /** 
     * Set the 'BaseAmount' element value. Total Base Fare Amount.  Example: 200000

    Note: This includes  surcharges (if applicable).
     * 
     * @param baseAmount
     */
    public void setBaseAmount(CurrencyAmountOptType baseAmount) {
        this.baseAmount = baseAmount;
    }

    /** 
     * Check if the 'Equivalent' element is present.
     * 
     * @return <code>true</code> if present, <code>false</code> if not
     */
    public boolean ifEquivalentPresent() {
        return equivalent;
    }

    /** 
     * Set flag for 'Equivalent' element present.
     * 
     * @param equivalent
     */
    public void flagEquivalentPresent(boolean equivalent) {
        this.equivalent = equivalent;
    }

    /** 
     * Get the 'Surcharges' element value.
     * 
     * @return value
     */
    public Surcharges getSurcharges() {
        return surcharges;
    }

    /** 
     * Set the 'Surcharges' element value.
     * 
     * @param surcharges
     */
    public void setSurcharges(Surcharges surcharges) {
        this.surcharges = surcharges;
    }

    /** 
     * Get the 'Taxes' element value. Ticket Tax/fee/charge details to indicate taxes that apply to country of commencement of travel and routing.
     * 
     * @return value
     */
    public TaxDetailType getTaxes() {
        return taxes;
    }

    /** 
     * Set the 'Taxes' element value. Ticket Tax/fee/charge details to indicate taxes that apply to country of commencement of travel and routing.
     * 
     * @param taxes
     */
    public void setTaxes(TaxDetailType taxes) {
        this.taxes = taxes;
    }

    /** 
     * Get the 'TaxExemption' element value.
     * 
     * @return value
     */
    public TaxExemptionType getTaxExemption() {
        return taxExemption;
    }

    /** 
     * Set the 'TaxExemption' element value.
     * 
     * @param taxExemption
     */
    public void setTaxExemption(TaxExemptionType taxExemption) {
        this.taxExemption = taxExemption;
    }

    /** 
     * Get the 'Fees' element value. Individual fee/ surcharge information would appear on the accountable document.
     * 
     * @return value
     */
    public FeeSurchargeType getFees() {
        return fees;
    }

    /** 
     * Set the 'Fees' element value. Individual fee/ surcharge information would appear on the accountable document.
     * 
     * @param fees
     */
    public void setFees(FeeSurchargeType fees) {
        this.fees = fees;
    }

    /** 
     * Get the 'Total' element value.
     * 
     * @return value
     */
    public Total getTotal() {
        return total;
    }

    /** 
     * Set the 'Total' element value.
     * 
     * @param total
     */
    public void setTotal(Total total) {
        this.total = total;
    }
    /** 
     * Applicable Surcharge(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Surcharges" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="FeeSurchargeType" name="Surcharge" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Surcharges implements Serializable
    {
        private List<FeeSurchargeType> surchargeList = new ArrayList<FeeSurchargeType>();

        /** 
         * Get the list of 'Surcharge' element items. Surcharge detail.
         * 
         * @return list
         */
        public List<FeeSurchargeType> getSurchargeList() {
            return surchargeList;
        }

        /** 
         * Set the list of 'Surcharge' element items. Surcharge detail.
         * 
         * @param list
         */
        public void setSurchargeList(List<FeeSurchargeType> list) {
            surchargeList = list;
        }
    }
    /** 
     * Total price
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Total" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element ref="SimpleCurrencyPrice"/>
     *       &lt;xs:element type="CombinationPriceSimpleType" name="CombinationPricing"/>
     *       &lt;xs:element ref="AwardPricing"/>
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Total implements Serializable
    {
        private int totalSelect = -1;
        private static final int SIMPLE_CURRENCY_PRICE_CHOICE = 0;
        private static final int COMBINATION_PRICING_CHOICE = 1;
        private static final int AWARD_PRICING_CHOICE = 2;
        private SimpleCurrencyPrice simpleCurrencyPrice;
        private CombinationPriceSimpleType combinationPricing;
        private AwardPriceUnitType awardPricing;

        private void setTotalSelect(int choice) {
            if (totalSelect == -1) {
                totalSelect = choice;
            } else if (totalSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearTotalSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearTotalSelect() {
            totalSelect = -1;
        }

        /** 
         * Check if SimpleCurrencyPrice is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifSimpleCurrencyPrice() {
            return totalSelect == SIMPLE_CURRENCY_PRICE_CHOICE;
        }

        /** 
         * Get the 'SimpleCurrencyPrice' element value.
         * 
         * @return value
         */
        public SimpleCurrencyPrice getSimpleCurrencyPrice() {
            return simpleCurrencyPrice;
        }

        /** 
         * Set the 'SimpleCurrencyPrice' element value.
         * 
         * @param simpleCurrencyPrice
         */
        public void setSimpleCurrencyPrice(
                SimpleCurrencyPrice simpleCurrencyPrice) {
            setTotalSelect(SIMPLE_CURRENCY_PRICE_CHOICE);
            this.simpleCurrencyPrice = simpleCurrencyPrice;
        }

        /** 
         * Check if CombinationPricing is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifCombinationPricing() {
            return totalSelect == COMBINATION_PRICING_CHOICE;
        }

        /** 
         * Get the 'CombinationPricing' element value. PARTIAL CURRENCY and AWARD Pricing Combination information.
         * 
         * @return value
         */
        public CombinationPriceSimpleType getCombinationPricing() {
            return combinationPricing;
        }

        /** 
         * Set the 'CombinationPricing' element value. PARTIAL CURRENCY and AWARD Pricing Combination information.
         * 
         * @param combinationPricing
         */
        public void setCombinationPricing(
                CombinationPriceSimpleType combinationPricing) {
            setTotalSelect(COMBINATION_PRICING_CHOICE);
            this.combinationPricing = combinationPricing;
        }

        /** 
         * Check if AwardPricing is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAwardPricing() {
            return totalSelect == AWARD_PRICING_CHOICE;
        }

        /** 
         * Get the 'AwardPricing' element value.
         * 
         * @return value
         */
        public AwardPriceUnitType getAwardPricing() {
            return awardPricing;
        }

        /** 
         * Set the 'AwardPricing' element value.
         * 
         * @param awardPricing
         */
        public void setAwardPricing(AwardPriceUnitType awardPricing) {
            setTotalSelect(AWARD_PRICING_CHOICE);
            this.awardPricing = awardPricing;
        }
    }
}
