
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for Shopping Request Business Object: GROUP FARE Preferences.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GroupFarePreferencesType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="GroupFare" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class GroupFare -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class GroupFarePreferencesType implements Serializable
{
    private List<GroupFare> groupFareList = new ArrayList<GroupFare>();
    private String refs;

    /** 
     * Get the list of 'GroupFare' element items.
     * 
     * @return list
     */
    public List<GroupFare> getGroupFareList() {
        return groupFareList;
    }

    /** 
     * Set the list of 'GroupFare' element items.
     * 
     * @param list
     */
    public void setGroupFareList(List<GroupFare> list) {
        groupFareList = list;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Group Fare Preference detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GroupFare" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="FareBasis" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class FareBasis -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="PTC"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class GroupFare implements Serializable
    {
        private List<FareBasis> fareBasiList = new ArrayList<FareBasis>();
        private String PTC;

        /** 
         * Get the list of 'FareBasis' element items.
         * 
         * @return list
         */
        public List<FareBasis> getFareBasiList() {
            return fareBasiList;
        }

        /** 
         * Set the list of 'FareBasis' element items.
         * 
         * @param list
         */
        public void setFareBasiList(List<FareBasis> list) {
            fareBasiList = list;
        }

        /** 
         * Get the 'PTC' element value. Passenger Type Code. Example: ADT

        Encoding Scheme: IATA (three character) Passenger Type Code (PTC)
         * 
         * @return value
         */
        public String getPTC() {
            return PTC;
        }

        /** 
         * Set the 'PTC' element value. Passenger Type Code. Example: ADT

        Encoding Scheme: IATA (three character) Passenger Type Code (PTC)
         * 
         * @param PTC
         */
        public void setPTC(String PTC) {
            this.PTC = PTC;
        }
        /** 
         * Fare basis detail for fare selection at flight and O/D levels.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareBasis" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="FareBasisCodeType">
         *         &lt;xs:sequence>
         *           &lt;xs:element ref="SegmentReferences"/>
         *         &lt;/xs:sequence>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FareBasis extends FareBasisCodeType implements
            Serializable
        {
            private SegmentReferences segmentReferences;

            /** 
             * Get the 'SegmentReferences' element value.
             * 
             * @return value
             */
            public SegmentReferences getSegmentReferences() {
                return segmentReferences;
            }

            /** 
             * Set the 'SegmentReferences' element value.
             * 
             * @param segmentReferences
             */
            public void setSegmentReferences(SegmentReferences segmentReferences) {
                this.segmentReferences = segmentReferences;
            }
        }
    }
}
