
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.math.BigInteger;
import org.joda.time.DateTime;

/** 
 * COUPON definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HistoryCouponInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:integer" name="CouponNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Status" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PrevStatus" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="SettlementAuthCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="TransactionTimeStamp" minOccurs="0"/>
 *     &lt;xs:element type="CouponSoldAirlineType" name="SoldAirlineInfo" minOccurs="0"/>
 *     &lt;xs:element ref="CurrentAirlineInfo" minOccurs="0"/>
 *     &lt;xs:element ref="CheckedInAirlineInfo" minOccurs="0"/>
 *     &lt;xs:element ref="Party"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class HistoryCouponInfoType implements Serializable
{
    private BigInteger couponNumber;
    private String status;
    private String prevStatus;
    private String settlementAuthCode;
    private DateTime transactionTimeStamp;
    private CouponSoldAirlineType soldAirlineInfo;
    private CurrentAirlineInfo currentAirlineInfo;
    private CheckedInAirlineInfo checkedInAirlineInfo;
    private MsgPartiesType party;

    /** 
     * Get the 'CouponNumber' element value. Applicable coupon number. Example: 1234
     * 
     * @return value
     */
    public BigInteger getCouponNumber() {
        return couponNumber;
    }

    /** 
     * Set the 'CouponNumber' element value. Applicable coupon number. Example: 1234
     * 
     * @param couponNumber
     */
    public void setCouponNumber(BigInteger couponNumber) {
        this.couponNumber = couponNumber;
    }

    /** 
     * Get the 'Status' element value. Current status of the flight/value coupon. Example: E (Exchanged/reissued)

    Encoding Scheme: IATA Padis Codeset - List for data element 4405 (Status, coded)
     * 
     * @return value
     */
    public String getStatus() {
        return status;
    }

    /** 
     * Set the 'Status' element value. Current status of the flight/value coupon. Example: E (Exchanged/reissued)

    Encoding Scheme: IATA Padis Codeset - List for data element 4405 (Status, coded)
     * 
     * @param status
     */
    public void setStatus(String status) {
        this.status = status;
    }

    /** 
     * Get the 'PrevStatus' element value. Previous status of the flight/value coupon. Example: E (Exchanged/reissued)

    Encoding Scheme: IATA Padis Codeset - List for data element 4405 (Status, coded)
     * 
     * @return value
     */
    public String getPrevStatus() {
        return prevStatus;
    }

    /** 
     * Set the 'PrevStatus' element value. Previous status of the flight/value coupon. Example: E (Exchanged/reissued)

    Encoding Scheme: IATA Padis Codeset - List for data element 4405 (Status, coded)
     * 
     * @param prevStatus
     */
    public void setPrevStatus(String prevStatus) {
        this.prevStatus = prevStatus;
    }

    /** 
     * Get the 'SettlementAuthCode' element value. Settlement Authorization Code. Example: AUTH123

    Note: This is a reference number generated by the validating carrier authorising settlement of a coupon.
     * 
     * @return value
     */
    public String getSettlementAuthCode() {
        return settlementAuthCode;
    }

    /** 
     * Set the 'SettlementAuthCode' element value. Settlement Authorization Code. Example: AUTH123

    Note: This is a reference number generated by the validating carrier authorising settlement of a coupon.
     * 
     * @param settlementAuthCode
     */
    public void setSettlementAuthCode(String settlementAuthCode) {
        this.settlementAuthCode = settlementAuthCode;
    }

    /** 
     * Get the 'TransactionTimeStamp' element value. The timestamp of the transaction)
     * 
     * @return value
     */
    public DateTime getTransactionTimeStamp() {
        return transactionTimeStamp;
    }

    /** 
     * Set the 'TransactionTimeStamp' element value. The timestamp of the transaction)
     * 
     * @param transactionTimeStamp
     */
    public void setTransactionTimeStamp(DateTime transactionTimeStamp) {
        this.transactionTimeStamp = transactionTimeStamp;
    }

    /** 
     * Get the 'SoldAirlineInfo' element value. Date and time, flight number, stopover indicator, and status code.
     * 
     * @return value
     */
    public CouponSoldAirlineType getSoldAirlineInfo() {
        return soldAirlineInfo;
    }

    /** 
     * Set the 'SoldAirlineInfo' element value. Date and time, flight number, stopover indicator, and status code.
     * 
     * @param soldAirlineInfo
     */
    public void setSoldAirlineInfo(CouponSoldAirlineType soldAirlineInfo) {
        this.soldAirlineInfo = soldAirlineInfo;
    }

    /** 
     * Get the 'CurrentAirlineInfo' element value.
     * 
     * @return value
     */
    public CurrentAirlineInfo getCurrentAirlineInfo() {
        return currentAirlineInfo;
    }

    /** 
     * Set the 'CurrentAirlineInfo' element value.
     * 
     * @param currentAirlineInfo
     */
    public void setCurrentAirlineInfo(CurrentAirlineInfo currentAirlineInfo) {
        this.currentAirlineInfo = currentAirlineInfo;
    }

    /** 
     * Get the 'CheckedInAirlineInfo' element value.
     * 
     * @return value
     */
    public CheckedInAirlineInfo getCheckedInAirlineInfo() {
        return checkedInAirlineInfo;
    }

    /** 
     * Set the 'CheckedInAirlineInfo' element value.
     * 
     * @param checkedInAirlineInfo
     */
    public void setCheckedInAirlineInfo(
            CheckedInAirlineInfo checkedInAirlineInfo) {
        this.checkedInAirlineInfo = checkedInAirlineInfo;
    }

    /** 
     * Get the 'Party' element value.
     * 
     * @return value
     */
    public MsgPartiesType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value.
     * 
     * @param party
     */
    public void setParty(MsgPartiesType party) {
        this.party = party;
    }
}
