
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * Instant purchase type.
 Examples:
 CC (Ticketless purchase immediately charged to credit card)
 NO (Not an instant purchase)
 TT (Simultaneous with time of ticketing)

 Encoding scheme: IATA PADIS Codeset IPT - Instant Purchase Type
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" type="xs:string" name="InstantPurchase"/>
 * </pre>
 */
public class InstantPurchase implements Serializable
{
    private String instantPurchase;

    /** 
     * Get the 'InstantPurchase' element value.
     * 
     * @return value
     */
    public String getInstantPurchase() {
        return instantPurchase;
    }

    /** 
     * Set the 'InstantPurchase' element value.
     * 
     * @param instantPurchase
     */
    public void setInstantPurchase(String instantPurchase) {
        this.instantPurchase = instantPurchase;
    }
}
