
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Inventory Discrepency Alert definition.

 Note: This processing condition occurs when there is a discrepency between offered inventory and available inventory. It may include references to Alternate Offers.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InvDiscrepencyAlertType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Code" minOccurs="0"/>
 *     &lt;xs:element type="MultiAssociationType" name="Associations" minOccurs="0"/>
 *     &lt;xs:element name="AlternateOffers" minOccurs="0">
 *       &lt;!-- Reference to inner class AlternateOffers -->
 *     &lt;/xs:element>
 *     &lt;xs:element ref="Remarks" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="NoInventoryInd"/>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class InvDiscrepencyAlertType implements Serializable
{
    private String code;
    private MultiAssociationType associations;
    private AlternateOffers alternateOffers;
    private Remarks remarks;
    private Boolean noInventoryInd;
    private String refs;

    /** 
     * Get the 'Code' element value. Inventory Availability Status Code.  
    IATA Padis Codeset - List for data element 9321.  Used in conjunction with Association(s) (Passenger, Group, Order Item, Offer Item and Optional Service) AnternateOffers (Alternate Offer(s) and Remarks (Payment remarks(s)).
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'Code' element value. Inventory Availability Status Code.  
    IATA Padis Codeset - List for data element 9321.  Used in conjunction with Association(s) (Passenger, Group, Order Item, Offer Item and Optional Service) AnternateOffers (Alternate Offer(s) and Remarks (Payment remarks(s)).
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'Associations' element value. Inventory Discrepency Alert Association(s), including Order, Order Item, Passenger, Group, Offer Item and Service.
     * 
     * @return value
     */
    public MultiAssociationType getAssociations() {
        return associations;
    }

    /** 
     * Set the 'Associations' element value. Inventory Discrepency Alert Association(s), including Order, Order Item, Passenger, Group, Offer Item and Service.
     * 
     * @param associations
     */
    public void setAssociations(MultiAssociationType associations) {
        this.associations = associations;
    }

    /** 
     * Get the 'AlternateOffers' element value.
     * 
     * @return value
     */
    public AlternateOffers getAlternateOffers() {
        return alternateOffers;
    }

    /** 
     * Set the 'AlternateOffers' element value.
     * 
     * @param alternateOffers
     */
    public void setAlternateOffers(AlternateOffers alternateOffers) {
        this.alternateOffers = alternateOffers;
    }

    /** 
     * Get the 'Remarks' element value.
     * 
     * @return value
     */
    public Remarks getRemarks() {
        return remarks;
    }

    /** 
     * Set the 'Remarks' element value.
     * 
     * @param remarks
     */
    public void setRemarks(Remarks remarks) {
        this.remarks = remarks;
    }

    /** 
     * Get the 'NoInventoryInd' attribute value. When true, the inventory for the Offer Item is not available to order.
     * 
     * @return value
     */
    public Boolean getNoInventoryInd() {
        return noInventoryInd;
    }

    /** 
     * Set the 'NoInventoryInd' attribute value. When true, the inventory for the Offer Item is not available to order.
     * 
     * @param noInventoryInd
     */
    public void setNoInventoryInd(Boolean noInventoryInd) {
        this.noInventoryInd = noInventoryInd;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Alternate Offer(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AlternateOffers" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="TotalOfferQuantity" minOccurs="0"/>
     *       &lt;xs:element type="AirlineID_Type" name="Owner"/>
     *       &lt;xs:element name="AlternateOffer" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class AlternateOffer -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AlternateOffers implements Serializable
    {
        private String totalOfferQuantity;
        private AirlineIDType owner;
        private List<AlternateOffer> alternateOfferList = new ArrayList<AlternateOffer>();

        /** 
         * Get the 'TotalOfferQuantity' element value. The total number of Alternate Offers provided by this Airline. Example: 12
         * 
         * @return value
         */
        public String getTotalOfferQuantity() {
            return totalOfferQuantity;
        }

        /** 
         * Set the 'TotalOfferQuantity' element value. The total number of Alternate Offers provided by this Airline. Example: 12
         * 
         * @param totalOfferQuantity
         */
        public void setTotalOfferQuantity(String totalOfferQuantity) {
            this.totalOfferQuantity = totalOfferQuantity;
        }

        /** 
         * Get the 'Owner' element value. Airline designator of the owner/ assigner of the Offer ID, typically used for offer ordering purposes.  Example: UA, BA

        Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Code
         * 
         * @return value
         */
        public AirlineIDType getOwner() {
            return owner;
        }

        /** 
         * Set the 'Owner' element value. Airline designator of the owner/ assigner of the Offer ID, typically used for offer ordering purposes.  Example: UA, BA

        Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Code
         * 
         * @param owner
         */
        public void setOwner(AirlineIDType owner) {
            this.owner = owner;
        }

        /** 
         * Get the list of 'AlternateOffer' element items.
         * 
         * @return list
         */
        public List<AlternateOffer> getAlternateOfferList() {
            return alternateOfferList;
        }

        /** 
         * Set the list of 'AlternateOffer' element items.
         * 
         * @param list
         */
        public void setAlternateOfferList(List<AlternateOffer> list) {
            alternateOfferList = list;
        }
        /** 
         * Airline Alternate Offer Detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AlternateOffer" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="OfferType">
         *         &lt;xs:sequence>
         *           &lt;xs:element ref="AltBaggageOffer"/>
         *           &lt;xs:element ref="AltOtherOffer"/>
         *           &lt;xs:element ref="AltPricedFlightOffer"/>
         *           &lt;xs:element ref="AltSeatOffer"/>
         *         &lt;/xs:sequence>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AlternateOffer extends OfferType implements
            Serializable
        {
            private AltBaggageOfferType altBaggageOffer;
            private AltOtherOfferType altOtherOffer;
            private AltPricedFlightOfferType altPricedFlightOffer;
            private AltSeatOfferType altSeatOffer;

            /** 
             * Get the 'AltBaggageOffer' element value.
             * 
             * @return value
             */
            public AltBaggageOfferType getAltBaggageOffer() {
                return altBaggageOffer;
            }

            /** 
             * Set the 'AltBaggageOffer' element value.
             * 
             * @param altBaggageOffer
             */
            public void setAltBaggageOffer(AltBaggageOfferType altBaggageOffer) {
                this.altBaggageOffer = altBaggageOffer;
            }

            /** 
             * Get the 'AltOtherOffer' element value.
             * 
             * @return value
             */
            public AltOtherOfferType getAltOtherOffer() {
                return altOtherOffer;
            }

            /** 
             * Set the 'AltOtherOffer' element value.
             * 
             * @param altOtherOffer
             */
            public void setAltOtherOffer(AltOtherOfferType altOtherOffer) {
                this.altOtherOffer = altOtherOffer;
            }

            /** 
             * Get the 'AltPricedFlightOffer' element value.
             * 
             * @return value
             */
            public AltPricedFlightOfferType getAltPricedFlightOffer() {
                return altPricedFlightOffer;
            }

            /** 
             * Set the 'AltPricedFlightOffer' element value.
             * 
             * @param altPricedFlightOffer
             */
            public void setAltPricedFlightOffer(
                    AltPricedFlightOfferType altPricedFlightOffer) {
                this.altPricedFlightOffer = altPricedFlightOffer;
            }

            /** 
             * Get the 'AltSeatOffer' element value.
             * 
             * @return value
             */
            public AltSeatOfferType getAltSeatOffer() {
                return altSeatOffer;
            }

            /** 
             * Set the 'AltSeatOffer' element value.
             * 
             * @param altSeatOffer
             */
            public void setAltSeatOffer(AltSeatOfferType altSeatOffer) {
                this.altSeatOffer = altSeatOffer;
            }
        }
    }
}
