
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * A data type for an order or offer related ID.

 Example: ORDER-c98c-4759-a20b-01
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItemID_Type">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attributeGroup ref="ObjectKeyMetaAttrGroup"/>
 *       &lt;xs:attribute type="xs:string" use="required" name="Owner"/>
 *       &lt;xs:attribute type="xs:string" name="WebAddressID"/>
 *       &lt;xs:attribute name="OwnerType">
 *         &lt;xs:simpleType>
 *           &lt;!-- Reference to inner class OwnerType -->
 *         &lt;/xs:simpleType>
 *       &lt;/xs:attribute>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ItemIDType implements Serializable
{
    private String string;
    private ObjectKeyMetaAttrGroup objectKeyMetaAttrGroup;
    private String owner;
    private String webAddressID;
    private OwnerType ownerType;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'ObjectKeyMetaAttrGroup' attributeGroup value.
     * 
     * @return value
     */
    public ObjectKeyMetaAttrGroup getObjectKeyMetaAttrGroup() {
        return objectKeyMetaAttrGroup;
    }

    /** 
     * Set the 'ObjectKeyMetaAttrGroup' attributeGroup value.
     * 
     * @param objectKeyMetaAttrGroup
     */
    public void setObjectKeyMetaAttrGroup(
            ObjectKeyMetaAttrGroup objectKeyMetaAttrGroup) {
        this.objectKeyMetaAttrGroup = objectKeyMetaAttrGroup;
    }

    /** 
     * Get the 'Owner' attribute value. Airline designator or CRS code of the owner/ assigner of the Offer ID, typically used for offer ordering purposes.  Example: UA, BA

    Encoding Scheme: IATA/ A4A (two or three character) Airline or CRS Designator Code
     * 
     * @return value
     */
    public String getOwner() {
        return owner;
    }

    /** 
     * Set the 'Owner' attribute value. Airline designator or CRS code of the owner/ assigner of the Offer ID, typically used for offer ordering purposes.  Example: UA, BA

    Encoding Scheme: IATA/ A4A (two or three character) Airline or CRS Designator Code
     * 
     * @param owner
     */
    public void setOwner(String owner) {
        this.owner = owner;
    }

    /** 
     * Get the 'WebAddressID' attribute value. Deep linking into another site to complete the transaction.  
     * 
     * @return value
     */
    public String getWebAddressID() {
        return webAddressID;
    }

    /** 
     * Set the 'WebAddressID' attribute value. Deep linking into another site to complete the transaction.  
     * 
     * @param webAddressID
     */
    public void setWebAddressID(String webAddressID) {
        this.webAddressID = webAddressID;
    }

    /** 
     * Get the 'OwnerType' attribute value. The POA OrderID should only go to the ORA, not back to the seller.
    1. ORA
    2. POA
     * 
     * @return value
     */
    public OwnerType getOwnerType() {
        return ownerType;
    }

    /** 
     * Set the 'OwnerType' attribute value. The POA OrderID should only go to the ORA, not back to the seller.
    1. ORA
    2. POA
     * 
     * @param ownerType
     */
    public void setOwnerType(OwnerType ownerType) {
        this.ownerType = ownerType;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="ORA"/>
     *     &lt;xs:enumeration value="POA"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum OwnerType implements Serializable {
        ORA, POA
    }
}
