
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * ITINERARY - Existing (known) Flight Information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItineraryType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="FlightType" name="Flight" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class ItineraryType implements Serializable
{
    private List<FlightType> flightList = new ArrayList<FlightType>();
    private String refs;

    /** 
     * Get the list of 'Flight' element items.
     * 
     * @return list
     */
    public List<FlightType> getFlightList() {
        return flightList;
    }

    /** 
     * Set the list of 'Flight' element items.
     * 
     * @param list
     */
    public void setFlightList(List<FlightType> list) {
        flightList = list;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
