
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type definition for URI with Formatting.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LinkFormattedType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="CoreBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Link" maxOccurs="unbounded">
 *           &lt;!-- Reference to inner class Link -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class LinkFormattedType extends CoreBaseType implements Serializable
{
    private List<Link> linkList = new ArrayList<Link>();

    /** 
     * Get the list of 'Link' element items.
     * 
     * @return list
     */
    public List<Link> getLinkList() {
        return linkList;
    }

    /** 
     * Set the list of 'Link' element items.
     * 
     * @param list
     */
    public void setLinkList(List<Link> list) {
        linkList = list;
    }
    /** 
     * Link detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Link" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="CoreBaseType">
     *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
     *         &lt;xs:attribute type="xs:string" use="optional" name="Text"/>
     *         &lt;xs:attribute type="xs:string" use="required" name="Value"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Link extends CoreBaseType implements Serializable
    {
        private String context;
        private String text;
        private String value;

        /** 
         * Get the 'Context' attribute value. Link Context.
         * 
         * @return value
         */
        public String getContext() {
            return context;
        }

        /** 
         * Set the 'Context' attribute value. Link Context.
         * 
         * @param context
         */
        public void setContext(String context) {
            this.context = context;
        }

        /** 
         * Get the 'Text' attribute value. Link Text. Example: Visit Program Benefits
         * 
         * @return value
         */
        public String getText() {
            return text;
        }

        /** 
         * Set the 'Text' attribute value. Link Text. Example: Visit Program Benefits
         * 
         * @param text
         */
        public void setText(String text) {
            this.text = text;
        }

        /** 
         * Get the 'Value' attribute value. Link Value. Example: www.thislink.com
         * 
         * @return value
         */
        public String getValue() {
            return value;
        }

        /** 
         * Set the 'Value' attribute value. Link Value. Example: www.thislink.com
         * 
         * @param value
         */
        public void setValue(String value) {
            this.value = value;
        }
    }
}
