
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * OPTIONAL SERVICE BUNDLE Data List definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ListOfServiceBundleType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="ServiceBundle" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class ServiceBundle -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ListOfServiceBundleType implements Serializable
{
    private List<ServiceBundle> serviceBundleList = new ArrayList<ServiceBundle>();

    /** 
     * Get the list of 'ServiceBundle' element items.
     * 
     * @return list
     */
    public List<ServiceBundle> getServiceBundleList() {
        return serviceBundleList;
    }

    /** 
     * Set the list of 'ServiceBundle' element items.
     * 
     * @param list
     */
    public void setServiceBundleList(List<ServiceBundle> list) {
        serviceBundleList = list;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceBundle" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="ItemCount"/>
     *       &lt;xs:element name="Associations">
     *         &lt;xs:complexType>
     *           &lt;xs:choice>
     *             &lt;xs:element ref="ServiceReference" maxOccurs="unbounded"/>
     *             &lt;xs:element ref="ServiceID" maxOccurs="unbounded"/>
     *           &lt;/xs:choice>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="Selection" minOccurs="0">
     *         &lt;!-- Reference to inner class Selection -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="BundleID" minOccurs="0">
     *         &lt;!-- Reference to inner class BundleID -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ServicePriceType" name="Price" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element type="xs:string" name="BundleName" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="DataListObjAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ServiceBundle implements Serializable
    {
        private String itemCount;
        private int associationsSelect = -1;
        private static final int ASSOCIATIONS_SERVICE_REFERENCE_LIST_CHOICE = 0;
        private static final int ASSOCIATIONS_SERVICE_ID_LIST_CHOICE = 1;
        private List<ServiceReference> associationsServiceReferenceList = new ArrayList<ServiceReference>();
        private List<ServiceIDType> associationsServiceIDList = new ArrayList<ServiceIDType>();
        private Selection selection;
        private BundleID bundleID;
        private List<ServicePriceType> priceList = new ArrayList<ServicePriceType>();
        private String bundleName;
        private DataListObjAttrGroup dataListObjAttrGroup;

        /** 
         * Get the 'ItemCount' element value. Individual service items in bundle count. Example: 4
         * 
         * @return value
         */
        public String getItemCount() {
            return itemCount;
        }

        /** 
         * Set the 'ItemCount' element value. Individual service items in bundle count. Example: 4
         * 
         * @param itemCount
         */
        public void setItemCount(String itemCount) {
            this.itemCount = itemCount;
        }

        private void setAssociationsSelect(int choice) {
            if (associationsSelect == -1) {
                associationsSelect = choice;
            } else if (associationsSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearAssociationsSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearAssociationsSelect() {
            associationsSelect = -1;
        }

        /** 
         * Check if AssociationsServiceReferenceList is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAssociationsServiceReferenceList() {
            return associationsSelect == ASSOCIATIONS_SERVICE_REFERENCE_LIST_CHOICE;
        }

        /** 
         * Get the list of 'ServiceReference' element items.
         * 
         * @return list
         */
        public List<ServiceReference> getAssociationsServiceReferenceList() {
            return associationsServiceReferenceList;
        }

        /** 
         * Set the list of 'ServiceReference' element items.
         * 
         * @param list
         */
        public void setAssociationsServiceReferenceList(
                List<ServiceReference> list) {
            setAssociationsSelect(ASSOCIATIONS_SERVICE_REFERENCE_LIST_CHOICE);
            associationsServiceReferenceList = list;
        }

        /** 
         * Check if AssociationsServiceIDList is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAssociationsServiceIDList() {
            return associationsSelect == ASSOCIATIONS_SERVICE_ID_LIST_CHOICE;
        }

        /** 
         * Get the list of 'ServiceID' element items.
         * 
         * @return list
         */
        public List<ServiceIDType> getAssociationsServiceIDList() {
            return associationsServiceIDList;
        }

        /** 
         * Set the list of 'ServiceID' element items.
         * 
         * @param list
         */
        public void setAssociationsServiceIDList(List<ServiceIDType> list) {
            setAssociationsSelect(ASSOCIATIONS_SERVICE_ID_LIST_CHOICE);
            associationsServiceIDList = list;
        }

        /** 
         * Get the 'Selection' element value.
         * 
         * @return value
         */
        public Selection getSelection() {
            return selection;
        }

        /** 
         * Set the 'Selection' element value.
         * 
         * @param selection
         */
        public void setSelection(Selection selection) {
            this.selection = selection;
        }

        /** 
         * Get the 'BundleID' element value.
         * 
         * @return value
         */
        public BundleID getBundleID() {
            return bundleID;
        }

        /** 
         * Set the 'BundleID' element value.
         * 
         * @param bundleID
         */
        public void setBundleID(BundleID bundleID) {
            this.bundleID = bundleID;
        }

        /** 
         * Get the list of 'Price' element items. Price for Bundled service
         * 
         * @return list
         */
        public List<ServicePriceType> getPriceList() {
            return priceList;
        }

        /** 
         * Set the list of 'Price' element items. Price for Bundled service
         * 
         * @param list
         */
        public void setPriceList(List<ServicePriceType> list) {
            priceList = list;
        }

        /** 
         * Get the 'BundleName' element value. Name of Bundle
         * 
         * @return value
         */
        public String getBundleName() {
            return bundleName;
        }

        /** 
         * Set the 'BundleName' element value. Name of Bundle
         * 
         * @param bundleName
         */
        public void setBundleName(String bundleName) {
            this.bundleName = bundleName;
        }

        /** 
         * Get the 'DataListObjAttrGroup' attributeGroup value.
         * 
         * @return value
         */
        public DataListObjAttrGroup getDataListObjAttrGroup() {
            return dataListObjAttrGroup;
        }

        /** 
         * Set the 'DataListObjAttrGroup' attributeGroup value.
         * 
         * @param dataListObjAttrGroup
         */
        public void setDataListObjAttrGroup(
                DataListObjAttrGroup dataListObjAttrGroup) {
            this.dataListObjAttrGroup = dataListObjAttrGroup;
        }
        /** 
         * Minimum and Maximum Bundle Item Selection rules.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Selection" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:choice maxOccurs="2">
         *       &lt;!-- Reference to inner class SelectionInner -->
         *     &lt;/xs:choice>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Selection implements Serializable
        {
            private List<SelectionInner> selectionList = new ArrayList<SelectionInner>();

            /** 
             * Get the list of 'Selection' element items.
             * 
             * @return list
             */
            public List<SelectionInner> getSelectionList() {
                return selectionList;
            }

            /** 
             * Set the list of 'Selection' element items.
             * 
             * @param list
             */
            public void setSelectionList(List<SelectionInner> list) {
                selectionList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:choice xmlns:xs="http://www.w3.org/2001/XMLSchema" maxOccurs="2">
             *   &lt;xs:element type="xs:string" name="MinimumQuantity"/>
             *   &lt;xs:element type="xs:string" name="MaximumQuantity"/>
             * &lt;/xs:choice>
             * </pre>
             */
            public static class SelectionInner implements Serializable
            {
                private int selectionListSelect = -1;
                private static final int MINIMUM_QUANTITY_CHOICE = 0;
                private static final int MAXIMUM_QUANTITY_CHOICE = 1;
                private String minimumQuantity;
                private String maximumQuantity;

                private void setSelectionListSelect(int choice) {
                    if (selectionListSelect == -1) {
                        selectionListSelect = choice;
                    } else if (selectionListSelect != choice) {
                        throw new IllegalStateException(
                                "Need to call clearSelectionListSelect() before changing existing choice");
                    }
                }

                /** 
                 * Clear the choice selection.
                 */
                public void clearSelectionListSelect() {
                    selectionListSelect = -1;
                }

                /** 
                 * Check if MinimumQuantity is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifMinimumQuantity() {
                    return selectionListSelect == MINIMUM_QUANTITY_CHOICE;
                }

                /** 
                 * Get the 'MinimumQuantity' element value. MINIMUM quantity of bundle items that must be selected.  Example: 2
                 * 
                 * @return value
                 */
                public String getMinimumQuantity() {
                    return minimumQuantity;
                }

                /** 
                 * Set the 'MinimumQuantity' element value. MINIMUM quantity of bundle items that must be selected.  Example: 2
                 * 
                 * @param minimumQuantity
                 */
                public void setMinimumQuantity(String minimumQuantity) {
                    setSelectionListSelect(MINIMUM_QUANTITY_CHOICE);
                    this.minimumQuantity = minimumQuantity;
                }

                /** 
                 * Check if MaximumQuantity is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifMaximumQuantity() {
                    return selectionListSelect == MAXIMUM_QUANTITY_CHOICE;
                }

                /** 
                 * Get the 'MaximumQuantity' element value. MAXIMUM quantity of bundle items that may be selected.  Example: 4
                 * 
                 * @return value
                 */
                public String getMaximumQuantity() {
                    return maximumQuantity;
                }

                /** 
                 * Set the 'MaximumQuantity' element value. MAXIMUM quantity of bundle items that may be selected.  Example: 4
                 * 
                 * @param maximumQuantity
                 */
                public void setMaximumQuantity(String maximumQuantity) {
                    setSelectionListSelect(MAXIMUM_QUANTITY_CHOICE);
                    this.maximumQuantity = maximumQuantity;
                }
            }
        }
        /** 
         * Unique Bundle ID. Example: BNDL-001
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BundleID" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attributeGroup ref="ObjectKeyAttrGroup"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class BundleID implements Serializable
        {
            private String string;
            private ObjectKeyAttrGroup objectKeyAttrGroup;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'ObjectKeyAttrGroup' attributeGroup value.
             * 
             * @return value
             */
            public ObjectKeyAttrGroup getObjectKeyAttrGroup() {
                return objectKeyAttrGroup;
            }

            /** 
             * Set the 'ObjectKeyAttrGroup' attributeGroup value.
             * 
             * @param objectKeyAttrGroup
             */
            public void setObjectKeyAttrGroup(
                    ObjectKeyAttrGroup objectKeyAttrGroup) {
                this.objectKeyAttrGroup = objectKeyAttrGroup;
            }
        }
    }
}
