
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * A data type for Marketing Message Association Base List.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarketMsgAssocSimpleType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Media"/>
 *     &lt;xs:enumeration value="OfferItem"/>
 *     &lt;xs:enumeration value="Order"/>
 *     &lt;xs:enumeration value="OrderItem"/>
 *     &lt;xs:enumeration value="Payment"/>
 *     &lt;xs:enumeration value="Service"/>
 *     &lt;xs:enumeration value="ServiceBundle"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum MarketMsgAssocSimpleType implements Serializable {
    MEDIA("Media"), OFFER_ITEM("OfferItem"), ORDER("Order"), ORDER_ITEM(
            "OrderItem"), PAYMENT("Payment"), SERVICE("Service"), SERVICE_BUNDLE(
            "ServiceBundle");
    private final String value;

    private MarketMsgAssocSimpleType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static MarketMsgAssocSimpleType convert(String value) {
        for (MarketMsgAssocSimpleType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
