
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * MEDIA Metadata definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MediaMetadataType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="MetadataObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="Application" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="Caption" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="Hint" minOccurs="0"/>
 *         &lt;xs:element name="Dimensions" minOccurs="0">
 *           &lt;!-- Reference to inner class Dimensions -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="MediaSource" minOccurs="0">
 *           &lt;!-- Reference to inner class MediaSource -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class MediaMetadataType extends MetadataObjectBaseType implements
    Serializable
{
    private String application;
    private String caption;
    private String hint;
    private Dimensions dimensions;
    private MediaSource mediaSource;

    /** 
     * Get the 'Application' element value. Media application. Example: Marketing
     * 
     * @return value
     */
    public String getApplication() {
        return application;
    }

    /** 
     * Set the 'Application' element value. Media application. Example: Marketing
     * 
     * @param application
     */
    public void setApplication(String application) {
        this.application = application;
    }

    /** 
     * Get the 'Caption' element value. Media object caption.  Examples: (image) PREMIUM SEAT, (video) See the New Terminal
    (file) Download Terminal Map, (link) Baggage Information
     * 
     * @return value
     */
    public String getCaption() {
        return caption;
    }

    /** 
     * Set the 'Caption' element value. Media object caption.  Examples: (image) PREMIUM SEAT, (video) See the New Terminal
    (file) Download Terminal Map, (link) Baggage Information
     * 
     * @param caption
     */
    public void setCaption(String caption) {
        this.caption = caption;
    }

    /** 
     * Get the 'Hint' element value. Media object tip.  Example: Envoy Class Seat

    Note: This is typically used in a client GUI, e.g. a mouseover tip.
     * 
     * @return value
     */
    public String getHint() {
        return hint;
    }

    /** 
     * Set the 'Hint' element value. Media object tip.  Example: Envoy Class Seat

    Note: This is typically used in a client GUI, e.g. a mouseover tip.
     * 
     * @param hint
     */
    public void setHint(String hint) {
        this.hint = hint;
    }

    /** 
     * Get the 'Dimensions' element value.
     * 
     * @return value
     */
    public Dimensions getDimensions() {
        return dimensions;
    }

    /** 
     * Set the 'Dimensions' element value.
     * 
     * @param dimensions
     */
    public void setDimensions(Dimensions dimensions) {
        this.dimensions = dimensions;
    }

    /** 
     * Get the 'MediaSource' element value.
     * 
     * @return value
     */
    public MediaSource getMediaSource() {
        return mediaSource;
    }

    /** 
     * Set the 'MediaSource' element value.
     * 
     * @param mediaSource
     */
    public void setMediaSource(MediaSource mediaSource) {
        this.mediaSource = mediaSource;
    }
    /** 
     * Media Dimensions metadata.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Dimensions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="UOM" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Height" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Width" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Format" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Dimensions implements Serializable
    {
        private String UOM;
        private String height;
        private String width;
        private String format;

        /** 
         * Get the 'UOM' element value. Dimension Unit of Measure.  Example: Pixels
         * 
         * @return value
         */
        public String getUOM() {
            return UOM;
        }

        /** 
         * Set the 'UOM' element value. Dimension Unit of Measure.  Example: Pixels
         * 
         * @param UOM
         */
        public void setUOM(String UOM) {
            this.UOM = UOM;
        }

        /** 
         * Get the 'Height' element value. Height in specified units.  Example: 120
         * 
         * @return value
         */
        public String getHeight() {
            return height;
        }

        /** 
         * Set the 'Height' element value. Height in specified units.  Example: 120
         * 
         * @param height
         */
        public void setHeight(String height) {
            this.height = height;
        }

        /** 
         * Get the 'Width' element value. Width in specified units.  Example: 120
         * 
         * @return value
         */
        public String getWidth() {
            return width;
        }

        /** 
         * Set the 'Width' element value. Width in specified units.  Example: 120
         * 
         * @param width
         */
        public void setWidth(String width) {
            this.width = width;
        }

        /** 
         * Get the 'Format' element value. "The “Format” is the “CREATIVE UNIT NAME”, Example: (Billboard, Filmstrip, Portrait, Pushdown, Medium Rectangle, Rectangle, Half Page ,…) IATA codeset MDF. Please refer to http://www.iab.com/wp-content/uploads/2015/11/IAB_Display_Mobile_Creative_Guidelines_HTML5_2015.pdf"
         * 
         * @return value
         */
        public String getFormat() {
            return format;
        }

        /** 
         * Set the 'Format' element value. "The “Format” is the “CREATIVE UNIT NAME”, Example: (Billboard, Filmstrip, Portrait, Pushdown, Medium Rectangle, Rectangle, Half Page ,…) IATA codeset MDF. Please refer to http://www.iab.com/wp-content/uploads/2015/11/IAB_Display_Mobile_Creative_Guidelines_HTML5_2015.pdf"
         * 
         * @param format
         */
        public void setFormat(String format) {
            this.format = format;
        }
    }
    /** 
     * Media Source metadata.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MediaSource" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Code" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Version" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="FileName" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Symbology" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Copyright" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class MediaSource implements Serializable
    {
        private String code;
        private String version;
        private String fileName;
        private String symbology;
        private String copyright;

        /** 
         * Get the 'Code' element value. Media Code. Example: IMG123
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'Code' element value. Media Code. Example: IMG123
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }

        /** 
         * Get the 'Version' element value. Media version. Example: 14
         * 
         * @return value
         */
        public String getVersion() {
            return version;
        }

        /** 
         * Set the 'Version' element value. Media version. Example: 14
         * 
         * @param version
         */
        public void setVersion(String version) {
            this.version = version;
        }

        /** 
         * Get the 'FileName' element value. The media object file name.  Example: ThisPlane.swf
         * 
         * @return value
         */
        public String getFileName() {
            return fileName;
        }

        /** 
         * Set the 'FileName' element value. The media object file name.  Example: ThisPlane.swf
         * 
         * @param fileName
         */
        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        /** 
         * Get the 'Symbology' element value. Image barcode symbology applied. Example: PDF417
         * 
         * @return value
         */
        public String getSymbology() {
            return symbology;
        }

        /** 
         * Set the 'Symbology' element value. Image barcode symbology applied. Example: PDF417
         * 
         * @param symbology
         */
        public void setSymbology(String symbology) {
            this.symbology = symbology;
        }

        /** 
         * Get the 'Copyright' element value. Media object copyright.  Example: © COPYRIGHT IATA 2014
         * 
         * @return value
         */
        public String getCopyright() {
            return copyright;
        }

        /** 
         * Set the 'Copyright' element value. Media object copyright.  Example: © COPYRIGHT IATA 2014
         * 
         * @param copyright
         */
        public void setCopyright(String copyright) {
            this.copyright = copyright;
        }
    }
}
