
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Offer-related Metadata, including Disclosure, General, Instructions, Penalty, Status and Terms.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Offer">
 *   &lt;xs:complexType>
 *     &lt;xs:choice maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class OfferInner -->
 *     &lt;/xs:choice>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class Offer implements Serializable
{
    private List<OfferInner> offerList = new ArrayList<OfferInner>();

    /** 
     * Get the list of 'Offer' element items.
     * 
     * @return list
     */
    public List<OfferInner> getOfferList() {
        return offerList;
    }

    /** 
     * Set the list of 'Offer' element items.
     * 
     * @param list
     */
    public void setOfferList(List<OfferInner> list) {
        offerList = list;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:xs="http://www.w3.org/2001/XMLSchema" maxOccurs="unbounded">
     *   &lt;xs:element ref="DisclosureMetadatas"/>
     *   &lt;xs:element ref="OfferMetadatas"/>
     *   &lt;xs:element ref="OfferInstructionMetadatas"/>
     *   &lt;xs:element ref="OfferPenaltyMetadatas"/>
     *   &lt;xs:element ref="OfferTermsMetadatas"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class OfferInner implements Serializable
    {
        private int offerListSelect = -1;
        private static final int DISCLOSURE_METADATAS_CHOICE = 0;
        private static final int OFFER_METADATAS_CHOICE = 1;
        private static final int OFFER_INSTRUCTION_METADATAS_CHOICE = 2;
        private static final int OFFER_PENALTY_METADATAS_CHOICE = 3;
        private static final int OFFER_TERMS_METADATAS_CHOICE = 4;
        private DisclosureMetadatas disclosureMetadatas;
        private OfferMetadatas offerMetadatas;
        private OfferInstructionMetadatas offerInstructionMetadatas;
        private OfferPenaltyMetadatas offerPenaltyMetadatas;
        private OfferTermsMetadatas offerTermsMetadatas;

        private void setOfferListSelect(int choice) {
            if (offerListSelect == -1) {
                offerListSelect = choice;
            } else if (offerListSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearOfferListSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearOfferListSelect() {
            offerListSelect = -1;
        }

        /** 
         * Check if DisclosureMetadatas is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifDisclosureMetadatas() {
            return offerListSelect == DISCLOSURE_METADATAS_CHOICE;
        }

        /** 
         * Get the 'DisclosureMetadatas' element value.
         * 
         * @return value
         */
        public DisclosureMetadatas getDisclosureMetadatas() {
            return disclosureMetadatas;
        }

        /** 
         * Set the 'DisclosureMetadatas' element value.
         * 
         * @param disclosureMetadatas
         */
        public void setDisclosureMetadatas(
                DisclosureMetadatas disclosureMetadatas) {
            setOfferListSelect(DISCLOSURE_METADATAS_CHOICE);
            this.disclosureMetadatas = disclosureMetadatas;
        }

        /** 
         * Check if OfferMetadatas is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifOfferMetadatas() {
            return offerListSelect == OFFER_METADATAS_CHOICE;
        }

        /** 
         * Get the 'OfferMetadatas' element value.
         * 
         * @return value
         */
        public OfferMetadatas getOfferMetadatas() {
            return offerMetadatas;
        }

        /** 
         * Set the 'OfferMetadatas' element value.
         * 
         * @param offerMetadatas
         */
        public void setOfferMetadatas(OfferMetadatas offerMetadatas) {
            setOfferListSelect(OFFER_METADATAS_CHOICE);
            this.offerMetadatas = offerMetadatas;
        }

        /** 
         * Check if OfferInstructionMetadatas is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifOfferInstructionMetadatas() {
            return offerListSelect == OFFER_INSTRUCTION_METADATAS_CHOICE;
        }

        /** 
         * Get the 'OfferInstructionMetadatas' element value.
         * 
         * @return value
         */
        public OfferInstructionMetadatas getOfferInstructionMetadatas() {
            return offerInstructionMetadatas;
        }

        /** 
         * Set the 'OfferInstructionMetadatas' element value.
         * 
         * @param offerInstructionMetadatas
         */
        public void setOfferInstructionMetadatas(
                OfferInstructionMetadatas offerInstructionMetadatas) {
            setOfferListSelect(OFFER_INSTRUCTION_METADATAS_CHOICE);
            this.offerInstructionMetadatas = offerInstructionMetadatas;
        }

        /** 
         * Check if OfferPenaltyMetadatas is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifOfferPenaltyMetadatas() {
            return offerListSelect == OFFER_PENALTY_METADATAS_CHOICE;
        }

        /** 
         * Get the 'OfferPenaltyMetadatas' element value.
         * 
         * @return value
         */
        public OfferPenaltyMetadatas getOfferPenaltyMetadatas() {
            return offerPenaltyMetadatas;
        }

        /** 
         * Set the 'OfferPenaltyMetadatas' element value.
         * 
         * @param offerPenaltyMetadatas
         */
        public void setOfferPenaltyMetadatas(
                OfferPenaltyMetadatas offerPenaltyMetadatas) {
            setOfferListSelect(OFFER_PENALTY_METADATAS_CHOICE);
            this.offerPenaltyMetadatas = offerPenaltyMetadatas;
        }

        /** 
         * Check if OfferTermsMetadatas is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifOfferTermsMetadatas() {
            return offerListSelect == OFFER_TERMS_METADATAS_CHOICE;
        }

        /** 
         * Get the 'OfferTermsMetadatas' element value.
         * 
         * @return value
         */
        public OfferTermsMetadatas getOfferTermsMetadatas() {
            return offerTermsMetadatas;
        }

        /** 
         * Set the 'OfferTermsMetadatas' element value.
         * 
         * @param offerTermsMetadatas
         */
        public void setOfferTermsMetadatas(
                OfferTermsMetadatas offerTermsMetadatas) {
            setOfferListSelect(OFFER_TERMS_METADATAS_CHOICE);
            this.offerTermsMetadatas = offerTermsMetadatas;
        }
    }
}
