
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * OFFER INCENTIVE information definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferIncentiveType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Incentive" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Incentive -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OfferIncentiveType implements Serializable
{
    private List<Incentive> incentiveList = new ArrayList<Incentive>();

    /** 
     * Get the list of 'Incentive' element items.
     * 
     * @return list
     */
    public List<Incentive> getIncentiveList() {
        return incentiveList;
    }

    /** 
     * Set the list of 'Incentive' element items.
     * 
     * @param list
     */
    public void setIncentiveList(List<Incentive> list) {
        incentiveList = list;
    }
    /** 
     * Offer Incentive detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Incentive" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="OfferCodeID"/>
     *       &lt;xs:element type="CoreDateGrpType" name="ExpirationDate"/>
     *       &lt;xs:element type="xs:string" name="OfferSubCode" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="AvailableUnits" minOccurs="0"/>
     *       &lt;xs:element name="DiscountLevel" minOccurs="0">
     *         &lt;!-- Reference to inner class DiscountLevel -->
     *       &lt;/xs:element>
     *       &lt;xs:element ref="AugmentationPoint" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Incentive implements Serializable
    {
        private String offerCodeID;
        private CoreDateGrpType expirationDate;
        private String offerSubCode;
        private String availableUnits;
        private DiscountLevel discountLevel;
        private AugPointInfoType augmentationPoint;
        private String refs;

        /** 
         * Get the 'OfferCodeID' element value. Rules engine offer ID.
        Example: 0AR123
         * 
         * @return value
         */
        public String getOfferCodeID() {
            return offerCodeID;
        }

        /** 
         * Set the 'OfferCodeID' element value. Rules engine offer ID.
        Example: 0AR123
         * 
         * @param offerCodeID
         */
        public void setOfferCodeID(String offerCodeID) {
            this.offerCodeID = offerCodeID;
        }

        /** 
         * Get the 'ExpirationDate' element value. Offer expiration date.
        Example: 2017-01-13
         * 
         * @return value
         */
        public CoreDateGrpType getExpirationDate() {
            return expirationDate;
        }

        /** 
         * Set the 'ExpirationDate' element value. Offer expiration date.
        Example: 2017-01-13
         * 
         * @param expirationDate
         */
        public void setExpirationDate(CoreDateGrpType expirationDate) {
            this.expirationDate = expirationDate;
        }

        /** 
         * Get the 'OfferSubCode' element value. Offer subcode generated on creation by SQL.
         * 
         * @return value
         */
        public String getOfferSubCode() {
            return offerSubCode;
        }

        /** 
         * Set the 'OfferSubCode' element value. Offer subcode generated on creation by SQL.
         * 
         * @param offerSubCode
         */
        public void setOfferSubCode(String offerSubCode) {
            this.offerSubCode = offerSubCode;
        }

        /** 
         * Get the 'AvailableUnits' element value. Quantity of available units.  Example: 4
         * 
         * @return value
         */
        public String getAvailableUnits() {
            return availableUnits;
        }

        /** 
         * Set the 'AvailableUnits' element value. Quantity of available units.  Example: 4
         * 
         * @param availableUnits
         */
        public void setAvailableUnits(String availableUnits) {
            this.availableUnits = availableUnits;
        }

        /** 
         * Get the 'DiscountLevel' element value.
         * 
         * @return value
         */
        public DiscountLevel getDiscountLevel() {
            return discountLevel;
        }

        /** 
         * Set the 'DiscountLevel' element value.
         * 
         * @param discountLevel
         */
        public void setDiscountLevel(DiscountLevel discountLevel) {
            this.discountLevel = discountLevel;
        }

        /** 
         * Get the 'AugmentationPoint' element value.
         * 
         * @return value
         */
        public AugPointInfoType getAugmentationPoint() {
            return augmentationPoint;
        }

        /** 
         * Set the 'AugmentationPoint' element value.
         * 
         * @param augmentationPoint
         */
        public void setAugmentationPoint(AugPointInfoType augmentationPoint) {
            this.augmentationPoint = augmentationPoint;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
        /** 
         * Distinguishes between choice of discount amount or discount percentage.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DiscountLevel" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element ref="DiscountAmount"/>
         *       &lt;xs:element ref="DiscountPercent"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class DiscountLevel implements Serializable
        {
            private DiscountAmount discountAmount;
            private DiscountPercent discountPercent;

            /** 
             * Get the 'DiscountAmount' element value.
             * 
             * @return value
             */
            public DiscountAmount getDiscountAmount() {
                return discountAmount;
            }

            /** 
             * Set the 'DiscountAmount' element value.
             * 
             * @param discountAmount
             */
            public void setDiscountAmount(DiscountAmount discountAmount) {
                this.discountAmount = discountAmount;
            }

            /** 
             * Get the 'DiscountPercent' element value.
             * 
             * @return value
             */
            public DiscountPercent getDiscountPercent() {
                return discountPercent;
            }

            /** 
             * Set the 'DiscountPercent' element value.
             * 
             * @param discountPercent
             */
            public void setDiscountPercent(DiscountPercent discountPercent) {
                this.discountPercent = discountPercent;
            }
        }
    }
}
