
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * OFFER TIME LIMIT SET (collection) definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferTimeLimitSetType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="OfferExpiration" minOccurs="0">
 *       &lt;!-- Reference to inner class OfferExpiration -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="CoreDateGrpType" name="Payment" minOccurs="0"/>
 *     &lt;xs:element name="OtherLimits" minOccurs="0">
 *       &lt;!-- Reference to inner class OtherLimits -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class OfferTimeLimitSetType implements Serializable
{
    private OfferExpiration offerExpiration;
    private CoreDateGrpType payment;
    private OtherLimits otherLimits;
    private String refs;

    /** 
     * Get the 'OfferExpiration' element value.
     * 
     * @return value
     */
    public OfferExpiration getOfferExpiration() {
        return offerExpiration;
    }

    /** 
     * Set the 'OfferExpiration' element value.
     * 
     * @param offerExpiration
     */
    public void setOfferExpiration(OfferExpiration offerExpiration) {
        this.offerExpiration = offerExpiration;
    }

    /** 
     * Get the 'Payment' element value. Payment Time Limit value.
    Examples: 2017-05-30T09:00:00,  2015-01-13T13:59:38Z

    Notes:
    1. This is the deadline by which a commitment to pay must be made for the confirmed items in an offer as agreed witht he airline. The passenger meets this requirement by making complete payment for the order. 
    
    2. Payment Time Limit and Ticket Time Limit may be the same in most cases; however, Payment Time Limit expands to include ticketless transactions and other accountable documents.

    3. This time limit is at the OFFER-LEVEL and will apply to all (child) Offer Items.
     * 
     * @return value
     */
    public CoreDateGrpType getPayment() {
        return payment;
    }

    /** 
     * Set the 'Payment' element value. Payment Time Limit value.
    Examples: 2017-05-30T09:00:00,  2015-01-13T13:59:38Z

    Notes:
    1. This is the deadline by which a commitment to pay must be made for the confirmed items in an offer as agreed witht he airline. The passenger meets this requirement by making complete payment for the order. 
    
    2. Payment Time Limit and Ticket Time Limit may be the same in most cases; however, Payment Time Limit expands to include ticketless transactions and other accountable documents.

    3. This time limit is at the OFFER-LEVEL and will apply to all (child) Offer Items.
     * 
     * @param payment
     */
    public void setPayment(CoreDateGrpType payment) {
        this.payment = payment;
    }

    /** 
     * Get the 'OtherLimits' element value.
     * 
     * @return value
     */
    public OtherLimits getOtherLimits() {
        return otherLimits;
    }

    /** 
     * Set the 'OtherLimits' element value.
     * 
     * @param otherLimits
     */
    public void setOtherLimits(OtherLimits otherLimits) {
        this.otherLimits = otherLimits;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Offer Expiration Time Limit value.
    Examples: 2017-05-30T09:00:00,  2015-01-13T13:59:38Z

    Notes:
    1. This is the time within which offers must be converted into completed Orders.

    2. On expiry, a new shopping transaction is required.

    3. This time limit is at the OFFER-LEVEL and will apply to all (child) Offer Items.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferExpiration" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="CoreDateGrpType">
     *         &lt;xs:attributeGroup ref="ObjectKeyMetaAttrGroup"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OfferExpiration extends CoreDateGrpType implements
        Serializable
    {
        private ObjectKeyMetaAttrGroup objectKeyMetaAttrGroup;

        /** 
         * Get the 'ObjectKeyMetaAttrGroup' attributeGroup value. Offer Time Limit object instance id and metadata instance(s) association.
         * 
         * @return value
         */
        public ObjectKeyMetaAttrGroup getObjectKeyMetaAttrGroup() {
            return objectKeyMetaAttrGroup;
        }

        /** 
         * Set the 'ObjectKeyMetaAttrGroup' attributeGroup value. Offer Time Limit object instance id and metadata instance(s) association.
         * 
         * @param objectKeyMetaAttrGroup
         */
        public void setObjectKeyMetaAttrGroup(
                ObjectKeyMetaAttrGroup objectKeyMetaAttrGroup) {
            this.objectKeyMetaAttrGroup = objectKeyMetaAttrGroup;
        }
    }
    /** 
     * Other Offer Time Limit(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherLimits" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="OtherLimit" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class OtherLimit -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OtherLimits implements Serializable
    {
        private List<OtherLimit> otherLimitList = new ArrayList<OtherLimit>();

        /** 
         * Get the list of 'OtherLimit' element items.
         * 
         * @return list
         */
        public List<OtherLimit> getOtherLimitList() {
            return otherLimitList;
        }

        /** 
         * Set the list of 'OtherLimit' element items.
         * 
         * @param list
         */
        public void setOtherLimitList(List<OtherLimit> list) {
            otherLimitList = list;
        }
        /** 
         * Other Offer Time Limit detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherLimit" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element ref="PriceGuaranteeTimeLimit"/>
         *       &lt;xs:element ref="TicketByTimeLimit"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attributeGroup ref="ObjectKeyMetaAttrGroup"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OtherLimit implements Serializable
        {
            private PriceGuarTimeLimitType priceGuaranteeTimeLimit;
            private TicketByTimeLimitType ticketByTimeLimit;
            private ObjectKeyMetaAttrGroup objectKeyMetaAttrGroup;

            /** 
             * Get the 'PriceGuaranteeTimeLimit' element value.
             * 
             * @return value
             */
            public PriceGuarTimeLimitType getPriceGuaranteeTimeLimit() {
                return priceGuaranteeTimeLimit;
            }

            /** 
             * Set the 'PriceGuaranteeTimeLimit' element value.
             * 
             * @param priceGuaranteeTimeLimit
             */
            public void setPriceGuaranteeTimeLimit(
                    PriceGuarTimeLimitType priceGuaranteeTimeLimit) {
                this.priceGuaranteeTimeLimit = priceGuaranteeTimeLimit;
            }

            /** 
             * Get the 'TicketByTimeLimit' element value.
             * 
             * @return value
             */
            public TicketByTimeLimitType getTicketByTimeLimit() {
                return ticketByTimeLimit;
            }

            /** 
             * Set the 'TicketByTimeLimit' element value.
             * 
             * @param ticketByTimeLimit
             */
            public void setTicketByTimeLimit(
                    TicketByTimeLimitType ticketByTimeLimit) {
                this.ticketByTimeLimit = ticketByTimeLimit;
            }

            /** 
             * Get the 'ObjectKeyMetaAttrGroup' attributeGroup value. Offer Time Limit object instance id and metadata instance(s) association.
             * 
             * @return value
             */
            public ObjectKeyMetaAttrGroup getObjectKeyMetaAttrGroup() {
                return objectKeyMetaAttrGroup;
            }

            /** 
             * Set the 'ObjectKeyMetaAttrGroup' attributeGroup value. Offer Time Limit object instance id and metadata instance(s) association.
             * 
             * @param objectKeyMetaAttrGroup
             */
            public void setObjectKeyMetaAttrGroup(
                    ObjectKeyMetaAttrGroup objectKeyMetaAttrGroup) {
                this.objectKeyMetaAttrGroup = objectKeyMetaAttrGroup;
            }
        }
    }
}
