
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * A data type for an Order ID.

 The airline-assigned unique Order ID. Example: ORDER-c98c-4759-a20b
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderID_Type">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attributeGroup ref="ObjectPolicyMetaAttrGroup"/>
 *       &lt;xs:attribute type="xs:string" use="required" name="Owner"/>
 *       &lt;xs:attribute type="xs:string" name="WebAddressID"/>
 *       &lt;xs:attribute name="OwnerType">
 *         &lt;xs:simpleType>
 *           &lt;!-- Reference to inner class OwnerType -->
 *         &lt;/xs:simpleType>
 *       &lt;/xs:attribute>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OrderIDType implements Serializable
{
    private String string;
    private ObjectPolicyMetaAttrGroup objectPolicyMetaAttrGroup;
    private String owner;
    private String webAddressID;
    private OwnerType ownerType;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'ObjectPolicyMetaAttrGroup' attributeGroup value. Policy, object and metadata association.

    Note: Equivalent Keys are specified in Metadata.
     * 
     * @return value
     */
    public ObjectPolicyMetaAttrGroup getObjectPolicyMetaAttrGroup() {
        return objectPolicyMetaAttrGroup;
    }

    /** 
     * Set the 'ObjectPolicyMetaAttrGroup' attributeGroup value. Policy, object and metadata association.

    Note: Equivalent Keys are specified in Metadata.
     * 
     * @param objectPolicyMetaAttrGroup
     */
    public void setObjectPolicyMetaAttrGroup(
            ObjectPolicyMetaAttrGroup objectPolicyMetaAttrGroup) {
        this.objectPolicyMetaAttrGroup = objectPolicyMetaAttrGroup;
    }

    /** 
     * Get the 'Owner' attribute value. Airline Designator of airline that owns/ assigned this ID. Example: BA

    Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Codes
     * 
     * @return value
     */
    public String getOwner() {
        return owner;
    }

    /** 
     * Set the 'Owner' attribute value. Airline Designator of airline that owns/ assigned this ID. Example: BA

    Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Codes
     * 
     * @param owner
     */
    public void setOwner(String owner) {
        this.owner = owner;
    }

    /** 
     * Get the 'WebAddressID' attribute value. Deep linking into another site to complete the transaction.
     * 
     * @return value
     */
    public String getWebAddressID() {
        return webAddressID;
    }

    /** 
     * Set the 'WebAddressID' attribute value. Deep linking into another site to complete the transaction.
     * 
     * @param webAddressID
     */
    public void setWebAddressID(String webAddressID) {
        this.webAddressID = webAddressID;
    }

    /** 
     * Get the 'OwnerType' attribute value. The POA OrderID should only go to the ORA, not back to the seller.
    1. ORA
    2. POA
     * 
     * @return value
     */
    public OwnerType getOwnerType() {
        return ownerType;
    }

    /** 
     * Set the 'OwnerType' attribute value. The POA OrderID should only go to the ORA, not back to the seller.
    1. ORA
    2. POA
     * 
     * @param ownerType
     */
    public void setOwnerType(OwnerType ownerType) {
        this.ownerType = ownerType;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="ORA"/>
     *     &lt;xs:enumeration value="POA"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum OwnerType implements Serializable {
        ORA, POA
    }
}
