
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * Associated Passenger(s) definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerInfoAssocType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="xs:boolean" name="AllPassengerInd"/>
 *     &lt;xs:element ref="PassengerReferences"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PassengerInfoAssocType implements Serializable
{
    private int choiceSelect = -1;
    private static final int ALL_PASSENGER_IND_CHOICE = 0;
    private static final int PASSENGER_REFERENCES_CHOICE = 1;
    private boolean allPassengerInd;
    private PassengerReferences passengerReferences;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if AllPassengerInd is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAllPassengerInd() {
        return choiceSelect == ALL_PASSENGER_IND_CHOICE;
    }

    /** 
     * Get the 'AllPassengerInd' element value. When true, this Offer applies to all specified Passengers.
     * 
     * @return value
     */
    public boolean isAllPassengerInd() {
        return allPassengerInd;
    }

    /** 
     * Set the 'AllPassengerInd' element value. When true, this Offer applies to all specified Passengers.
     * 
     * @param allPassengerInd
     */
    public void setAllPassengerInd(boolean allPassengerInd) {
        setChoiceSelect(ALL_PASSENGER_IND_CHOICE);
        this.allPassengerInd = allPassengerInd;
    }

    /** 
     * Check if PassengerReferences is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPassengerReferences() {
        return choiceSelect == PASSENGER_REFERENCES_CHOICE;
    }

    /** 
     * Get the 'PassengerReferences' element value. Association to multiple Passenger instance(s). Example: Passenger1 Passenger2

    Note: May be Passenger (by PTC) instance(s).
     * 
     * @return value
     */
    public PassengerReferences getPassengerReferences() {
        return passengerReferences;
    }

    /** 
     * Set the 'PassengerReferences' element value. Association to multiple Passenger instance(s). Example: Passenger1 Passenger2

    Note: May be Passenger (by PTC) instance(s).
     * 
     * @param passengerReferences
     */
    public void setPassengerReferences(PassengerReferences passengerReferences) {
        setChoiceSelect(PASSENGER_REFERENCES_CHOICE);
        this.passengerReferences = passengerReferences;
    }
}
