
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for Shopping Request Qualifiers.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="QualifiersType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Qualifier" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Qualifier -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class QualifiersType implements Serializable
{
    private List<Qualifier> qualifierList = new ArrayList<Qualifier>();

    /** 
     * Get the list of 'Qualifier' element items.
     * 
     * @return list
     */
    public List<Qualifier> getQualifierList() {
        return qualifierList;
    }

    /** 
     * Set the list of 'Qualifier' element items.
     * 
     * @param list
     */
    public void setQualifierList(List<Qualifier> list) {
        qualifierList = list;
    }
    /** 
     * Qualifier choices.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Qualifier" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="SeatQualifier" minOccurs="0"/>
     *       &lt;xs:element ref="ServiceQualifier" minOccurs="0"/>
     *       &lt;xs:element ref="Associations" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Qualifier implements Serializable
    {
        private SeatQualifier seatQualifier;
        private ServiceQualifierPriceType serviceQualifier;
        private Associations associations;
        private String refs;

        /** 
         * Get the 'SeatQualifier' element value.
         * 
         * @return value
         */
        public SeatQualifier getSeatQualifier() {
            return seatQualifier;
        }

        /** 
         * Set the 'SeatQualifier' element value.
         * 
         * @param seatQualifier
         */
        public void setSeatQualifier(SeatQualifier seatQualifier) {
            this.seatQualifier = seatQualifier;
        }

        /** 
         * Get the 'ServiceQualifier' element value.
         * 
         * @return value
         */
        public ServiceQualifierPriceType getServiceQualifier() {
            return serviceQualifier;
        }

        /** 
         * Set the 'ServiceQualifier' element value.
         * 
         * @param serviceQualifier
         */
        public void setServiceQualifier(
                ServiceQualifierPriceType serviceQualifier) {
            this.serviceQualifier = serviceQualifier;
        }

        /** 
         * Get the 'Associations' element value.
         * 
         * @return value
         */
        public Associations getAssociations() {
            return associations;
        }

        /** 
         * Set the 'Associations' element value.
         * 
         * @param associations
         */
        public void setAssociations(Associations associations) {
            this.associations = associations;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
}
