
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import org.joda.time.DateTime;

/** 
 * Additional, supplementary information about the document or service.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RemarkTypeAIDM">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Remark" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="DisplayInd"/>
 *   &lt;xs:attribute type="xs:dateTime" use="optional" name="Timestamp"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RemarkTypeAIDM implements Serializable
{
    private String remark;
    private Boolean displayInd;
    private DateTime timestamp;

    /** 
     * Get the 'Remark' element value. Additional, supplementary information about the document or service.
     * 
     * @return value
     */
    public String getRemark() {
        return remark;
    }

    /** 
     * Set the 'Remark' element value. Additional, supplementary information about the document or service.
     * 
     * @param remark
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /** 
     * Get the 'DisplayInd' attribute value. When TRUE, this remark should be displayed.  Notes: 1. This capability may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only.  The technical implementation of this capability is not dictated by this specificat
     * 
     * @return value
     */
    public Boolean getDisplayInd() {
        return displayInd;
    }

    /** 
     * Set the 'DisplayInd' attribute value. When TRUE, this remark should be displayed.  Notes: 1. This capability may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only.  The technical implementation of this capability is not dictated by this specificat
     * 
     * @param displayInd
     */
    public void setDisplayInd(Boolean displayInd) {
        this.displayInd = displayInd;
    }

    /** 
     * Get the 'Timestamp' attribute value. Remark creation timestamp.
     * 
     * @return value
     */
    public DateTime getTimestamp() {
        return timestamp;
    }

    /** 
     * Set the 'Timestamp' attribute value. Remark creation timestamp.
     * 
     * @param timestamp
     */
    public void setTimestamp(DateTime timestamp) {
        this.timestamp = timestamp;
    }
}
