
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.LocalDate;

/** 
 * SECURE PAYMENT AIRLINE RESERVATION definition.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SecurePaymentPaxInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Carriers" minOccurs="0">
 *       &lt;!-- Reference to inner class Carriers -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="DateTimes" minOccurs="0">
 *       &lt;!-- Reference to inner class DateTimes -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="ClassesOfService" minOccurs="0">
 *       &lt;!-- Reference to inner class ClassesOfService -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="StopLocations" minOccurs="0">
 *       &lt;!-- Reference to inner class StopLocations -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="FareBasisCodes" minOccurs="0">
 *       &lt;!-- Reference to inner class FareBasisCodes -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="FlightNumbers" minOccurs="0">
 *       &lt;!-- Reference to inner class FlightNumbers -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="PassengerName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ResidenceCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PassengerTktNbr" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AgencyInfo" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class SecurePaymentPaxInfoType implements Serializable
{
    private Carriers carriers;
    private DateTimes dateTimes;
    private ClassesOfService classesOfService;
    private StopLocations stopLocations;
    private FareBasisCodes fareBasisCodes;
    private FlightNumbers flightNumbers;
    private String passengerName;
    private String residenceCode;
    private String passengerTktNbr;
    private String agencyInfo;
    private String refs;

    /** 
     * Get the 'Carriers' element value.
     * 
     * @return value
     */
    public Carriers getCarriers() {
        return carriers;
    }

    /** 
     * Set the 'Carriers' element value.
     * 
     * @param carriers
     */
    public void setCarriers(Carriers carriers) {
        this.carriers = carriers;
    }

    /** 
     * Get the 'DateTimes' element value.
     * 
     * @return value
     */
    public DateTimes getDateTimes() {
        return dateTimes;
    }

    /** 
     * Set the 'DateTimes' element value.
     * 
     * @param dateTimes
     */
    public void setDateTimes(DateTimes dateTimes) {
        this.dateTimes = dateTimes;
    }

    /** 
     * Get the 'ClassesOfService' element value.
     * 
     * @return value
     */
    public ClassesOfService getClassesOfService() {
        return classesOfService;
    }

    /** 
     * Set the 'ClassesOfService' element value.
     * 
     * @param classesOfService
     */
    public void setClassesOfService(ClassesOfService classesOfService) {
        this.classesOfService = classesOfService;
    }

    /** 
     * Get the 'StopLocations' element value.
     * 
     * @return value
     */
    public StopLocations getStopLocations() {
        return stopLocations;
    }

    /** 
     * Set the 'StopLocations' element value.
     * 
     * @param stopLocations
     */
    public void setStopLocations(StopLocations stopLocations) {
        this.stopLocations = stopLocations;
    }

    /** 
     * Get the 'FareBasisCodes' element value.
     * 
     * @return value
     */
    public FareBasisCodes getFareBasisCodes() {
        return fareBasisCodes;
    }

    /** 
     * Set the 'FareBasisCodes' element value.
     * 
     * @param fareBasisCodes
     */
    public void setFareBasisCodes(FareBasisCodes fareBasisCodes) {
        this.fareBasisCodes = fareBasisCodes;
    }

    /** 
     * Get the 'FlightNumbers' element value.
     * 
     * @return value
     */
    public FlightNumbers getFlightNumbers() {
        return flightNumbers;
    }

    /** 
     * Set the 'FlightNumbers' element value.
     * 
     * @param flightNumbers
     */
    public void setFlightNumbers(FlightNumbers flightNumbers) {
        this.flightNumbers = flightNumbers;
    }

    /** 
     * Get the 'PassengerName' element value. Passenger Name. Example: John Smith

    Note: This is the primary contact on the reservation.
     * 
     * @return value
     */
    public String getPassengerName() {
        return passengerName;
    }

    /** 
     * Set the 'PassengerName' element value. Passenger Name. Example: John Smith

    Note: This is the primary contact on the reservation.
     * 
     * @param passengerName
     */
    public void setPassengerName(String passengerName) {
        this.passengerName = passengerName;
    }

    /** 
     * Get the 'ResidenceCode' element value. Passenger Residence country code. Examples: US, FR

    Encoding Scheme: ISO 3166-1 (two character) Country Code
     * 
     * @return value
     */
    public String getResidenceCode() {
        return residenceCode;
    }

    /** 
     * Set the 'ResidenceCode' element value. Passenger Residence country code. Examples: US, FR

    Encoding Scheme: ISO 3166-1 (two character) Country Code
     * 
     * @param residenceCode
     */
    public void setResidenceCode(String residenceCode) {
        this.residenceCode = residenceCode;
    }

    /** 
     * Get the 'PassengerTktNbr' element value. Document Number assigned to this transaction comprised of the following:
    • Airline Code -  3-digit Airline identification number (one character reserved for expansion)

    • Form Code - A maximum of 3 digits indicating the type of document, the source of issue and the number of coupons it comprises,

    • Serial No. - A maximum of 8 digits allocated on a sequential basis, provided that the total number of digits allocated to the Form Code and Serial Number shall not exceed ten.

     * 
     * @return value
     */
    public String getPassengerTktNbr() {
        return passengerTktNbr;
    }

    /** 
     * Set the 'PassengerTktNbr' element value. Document Number assigned to this transaction comprised of the following:
    • Airline Code -  3-digit Airline identification number (one character reserved for expansion)

    • Form Code - A maximum of 3 digits indicating the type of document, the source of issue and the number of coupons it comprises,

    • Serial No. - A maximum of 8 digits allocated on a sequential basis, provided that the total number of digits allocated to the Form Code and Serial Number shall not exceed ten.

     * 
     * @param passengerTktNbr
     */
    public void setPassengerTktNbr(String passengerTktNbr) {
        this.passengerTktNbr = passengerTktNbr;
    }

    /** 
     * Get the 'AgencyInfo' element value. Travel Agency Information.

    Note; This typically contains the seller travel agency ID and/ or Name.
     * 
     * @return value
     */
    public String getAgencyInfo() {
        return agencyInfo;
    }

    /** 
     * Set the 'AgencyInfo' element value. Travel Agency Information.

    Note; This typically contains the seller travel agency ID and/ or Name.
     * 
     * @param agencyInfo
     */
    public void setAgencyInfo(String agencyInfo) {
        this.agencyInfo = agencyInfo;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Airline Carrier(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Carriers" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Carrier" maxOccurs="4">
     *         &lt;!-- Reference to inner class Carrier -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Carriers implements Serializable
    {
        private List<Carrier> carrierList = new ArrayList<Carrier>();

        /** 
         * Get the list of 'Carrier' element items.
         * 
         * @return list
         */
        public List<Carrier> getCarrierList() {
            return carrierList;
        }

        /** 
         * Set the list of 'Carrier' element items.
         * 
         * @param list
         */
        public void setCarrierList(List<Carrier> list) {
            carrierList = list;
        }
        /** 
         * A two-character alpha-numeric code assigned by the IATA.  Refer to IATA Coding Directory and IATA Resolution 762 for Airlines and 763 for Airports. Application attribute is used to indicate whether the airline is a marketing or an operating carrier.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Carrier" maxOccurs="4">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="AirlineID_Type">
         *         &lt;xs:attribute type="xs:string" use="optional" name="Application"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Carrier extends AirlineIDType implements
            Serializable
        {
            private String application;

            /** 
             * Get the 'Application' attribute value. Airline Carrier Application. Examples: Operating, Marketing
             * 
             * @return value
             */
            public String getApplication() {
                return application;
            }

            /** 
             * Set the 'Application' attribute value. Airline Carrier Application. Examples: Operating, Marketing
             * 
             * @param application
             */
            public void setApplication(String application) {
                this.application = application;
            }
        }
    }
    /** 
     * Data and time information used to enrich secure payment details. Used in conjunction with application identification attribute, to indicate date/ time application (I.e. departure, arrival, etc.).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DateTimes" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="DateTime" maxOccurs="4">
     *         &lt;!-- Reference to inner class DateTime -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class DateTimes implements Serializable
    {
        private List<DateTime> dateTimeList = new ArrayList<DateTime>();

        /** 
         * Get the list of 'DateTime' element items.
         * 
         * @return list
         */
        public List<DateTime> getDateTimeList() {
            return dateTimeList;
        }

        /** 
         * Set the list of 'DateTime' element items.
         * 
         * @param list
         */
        public void setDateTimeList(List<DateTime> list) {
            dateTimeList = list;
        }
        /** 
         * Date, Time and Application.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DateTime" maxOccurs="4">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:date" use="optional" name="Date"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Time"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Application"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class DateTime implements Serializable
        {
            private LocalDate date;
            private String time;
            private String application;

            /** 
             * Get the 'Date' attribute value. Date. Example: 2017-01-13

            Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
             * 
             * @return value
             */
            public LocalDate getDate() {
                return date;
            }

            /** 
             * Set the 'Date' attribute value. Date. Example: 2017-01-13

            Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
             * 
             * @param date
             */
            public void setDate(LocalDate date) {
                this.date = date;
            }

            /** 
             * Get the 'Time' attribute value. Time. Example: 09:15

            Encoding Scheme: ISO 8601 Military/ 24 Hour Format (HH:MM)
             * 
             * @return value
             */
            public String getTime() {
                return time;
            }

            /** 
             * Set the 'Time' attribute value. Time. Example: 09:15

            Encoding Scheme: ISO 8601 Military/ 24 Hour Format (HH:MM)
             * 
             * @param time
             */
            public void setTime(String time) {
                this.time = time;
            }

            /** 
             * Get the 'Application' attribute value. Date Application. Example: Departure, Arrival, Connection
             * 
             * @return value
             */
            public String getApplication() {
                return application;
            }

            /** 
             * Set the 'Application' attribute value. Date Application. Example: Departure, Arrival, Connection
             * 
             * @param application
             */
            public void setApplication(String application) {
                this.application = application;
            }
        }
    }
    /** 
     * Class(es) of Service.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ClassesOfService" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ClassOfService" maxOccurs="4"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ClassesOfService implements Serializable
    {
        private List<FlightCOSCoreType> classOfServiceList = new ArrayList<FlightCOSCoreType>();

        /** 
         * Get the list of 'ClassOfService' element items.
         * 
         * @return list
         */
        public List<FlightCOSCoreType> getClassOfServiceList() {
            return classOfServiceList;
        }

        /** 
         * Set the list of 'ClassOfService' element items.
         * 
         * @param list
         */
        public void setClassOfServiceList(List<FlightCOSCoreType> list) {
            classOfServiceList = list;
        }
    }
    /** 
     * Stop Location(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StopLocations" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="StopLocation" maxOccurs="4">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element ref="AirportCode"/>
     *           &lt;/xs:sequence>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class StopLocations implements Serializable
    {
        private List<AirportCode> stopLocationList = new ArrayList<AirportCode>();

        /** 
         * Get the list of 'StopLocation' element items. Stop Location details including arrival date and time, departure date and time and change of gauge.

         * 
         * @return list
         */
        public List<AirportCode> getStopLocationList() {
            return stopLocationList;
        }

        /** 
         * Set the list of 'StopLocation' element items. Stop Location details including arrival date and time, departure date and time and change of gauge.

         * 
         * @param list
         */
        public void setStopLocationList(List<AirportCode> list) {
            stopLocationList = list;
        }
    }
    /** 
     * A code that gives information regarding the type of fare, class entitlement, minimum and maximum validity, reservations entitlement, seasonality, days of travel and advertising or sales restrictions.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareBasisCodes" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="FareBasisCode" maxOccurs="4"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FareBasisCodes implements Serializable
    {
        private List<FareBasisCodeType> fareBasisCodeList = new ArrayList<FareBasisCodeType>();

        /** 
         * Get the list of 'FareBasisCode' element items.
         * 
         * @return list
         */
        public List<FareBasisCodeType> getFareBasisCodeList() {
            return fareBasisCodeList;
        }

        /** 
         * Set the list of 'FareBasisCode' element items.
         * 
         * @param list
         */
        public void setFareBasisCodeList(List<FareBasisCodeType> list) {
            fareBasisCodeList = list;
        }
    }
    /** 
     * Flight Number(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightNumbers" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="FlightNumber" maxOccurs="4"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FlightNumbers implements Serializable
    {
        private List<FlightNumber> flightNumberList = new ArrayList<FlightNumber>();

        /** 
         * Get the list of 'FlightNumber' element items.
         * 
         * @return list
         */
        public List<FlightNumber> getFlightNumberList() {
            return flightNumberList;
        }

        /** 
         * Set the list of 'FlightNumber' element items.
         * 
         * @param list
         */
        public void setFlightNumberList(List<FlightNumber> list) {
            flightNumberList = list;
        }
    }
}
