
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * A data type for Optional Service Coupon.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceCouponType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="InstantPurchase" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FeeBasis" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CouponType" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ServiceCouponType implements Serializable
{
    private String instantPurchase;
    private String feeBasis;
    private String couponType;

    /** 
     * Get the 'InstantPurchase' element value. Instant purchase type.
    Examples:
    CC (Ticketless purchase immediately charged to credit card)
    NO (Not an instant purchase)
    TT (Simultaneous with time of ticketing)

    Encoding scheme: IATA PADIS Codeset IPT - Instant Purchase Type
     * 
     * @return value
     */
    public String getInstantPurchase() {
        return instantPurchase;
    }

    /** 
     * Set the 'InstantPurchase' element value. Instant purchase type.
    Examples:
    CC (Ticketless purchase immediately charged to credit card)
    NO (Not an instant purchase)
    TT (Simultaneous with time of ticketing)

    Encoding scheme: IATA PADIS Codeset IPT - Instant Purchase Type
     * 
     * @param instantPurchase
     */
    public void setInstantPurchase(String instantPurchase) {
        this.instantPurchase = instantPurchase;
    }

    /** 
     * Get the 'FeeBasis' element value. Service fee basis.
    Examples:
    DIS (Option directly applied to fare)
    FEE (Baggage only)
    FNA (Item is not available/ applicable)
    INC (Item is free of charge)
    NAP (Item not applicable/ available)
    SUR (Surcharge)

    Encoding Scheme: IATA Padis Codeset - List for data element SFB - Service Fee Basis
     * 
     * @return value
     */
    public String getFeeBasis() {
        return feeBasis;
    }

    /** 
     * Set the 'FeeBasis' element value. Service fee basis.
    Examples:
    DIS (Option directly applied to fare)
    FEE (Baggage only)
    FNA (Item is not available/ applicable)
    INC (Item is free of charge)
    NAP (Item not applicable/ available)
    SUR (Surcharge)

    Encoding Scheme: IATA Padis Codeset - List for data element SFB - Service Fee Basis
     * 
     * @param feeBasis
     */
    public void setFeeBasis(String feeBasis) {
        this.feeBasis = feeBasis;
    }

    /** 
     * Get the 'CouponType' element value. Contains instruction on what type of traffic document should be issued for an optional service.

    Examples:
    EMD Associated
    EMD Standalone
    No EMD
    Electronic Ticket
     * 
     * @return value
     */
    public String getCouponType() {
        return couponType;
    }

    /** 
     * Set the 'CouponType' element value. Contains instruction on what type of traffic document should be issued for an optional service.

    Examples:
    EMD Associated
    EMD Standalone
    No EMD
    Electronic Ticket
     * 
     * @param couponType
     */
    public void setCouponType(String couponType) {
        this.couponType = couponType;
    }
}
