
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * OPTIONAL SERVICE CORE definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceDefinitionType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Name"/>
 *     &lt;xs:choice minOccurs="0">
 *       &lt;!-- Reference to inner class Choice -->
 *     &lt;/xs:choice>
 *     &lt;xs:element type="ServiceEncodingType" name="Encoding" minOccurs="0"/>
 *     &lt;xs:element ref="TimeLimits" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" default="OC" name="FeeMethod" minOccurs="0"/>
 *     &lt;xs:element type="ServiceDescriptionType" name="Descriptions"/>
 *     &lt;xs:element name="Settlement" minOccurs="0">
 *       &lt;!-- Reference to inner class Settlement -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="BookingInstructions" minOccurs="0">
 *       &lt;!-- Reference to inner class BookingInstructions -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="ValidatingCarrier" minOccurs="0"/>
 *     &lt;xs:element name="Detail" minOccurs="0">
 *       &lt;!-- Reference to inner class Detail -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="ServiceDefinitionID"/>
 *   &lt;xs:attribute type="xs:string" name="Owner"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ServiceDefinitionType implements Serializable
{
    private String name;
    private Choice choice;
    private ServiceEncodingType encoding;
    private TimeLimits timeLimits;
    private String feeMethod;
    private ServiceDescriptionType descriptions;
    private Settlement settlement;
    private BookingInstructions bookingInstructions;
    private String validatingCarrier;
    private Detail detail;
    private String serviceDefinitionID;
    private String owner;

    /** 
     * Get the 'Name' element value. Service name. Example: Lounge Pass
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Service name. Example: Lounge Pass
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the choice value.
     * 
     * @return value
     */
    public Choice getChoice() {
        return choice;
    }

    /** 
     * Set the choice value.
     * 
     * @param choice
     */
    public void setChoice(Choice choice) {
        this.choice = choice;
    }

    /** 
     * Get the 'Encoding' element value. Service Codes and Reason for Issuance.
     * 
     * @return value
     */
    public ServiceEncodingType getEncoding() {
        return encoding;
    }

    /** 
     * Set the 'Encoding' element value. Service Codes and Reason for Issuance.
     * 
     * @param encoding
     */
    public void setEncoding(ServiceEncodingType encoding) {
        this.encoding = encoding;
    }

    /** 
     * Get the 'TimeLimits' element value.
     * 
     * @return value
     */
    public TimeLimits getTimeLimits() {
        return timeLimits;
    }

    /** 
     * Set the 'TimeLimits' element value.
     * 
     * @param timeLimits
     */
    public void setTimeLimits(TimeLimits timeLimits) {
        this.timeLimits = timeLimits;
    }

    /** 
     * Get the 'FeeMethod' element value. Two character generic code to identify ticket level charges, fees and taxes.
     * 
     * @return value
     */
    public String getFeeMethod() {
        return feeMethod;
    }

    /** 
     * Set the 'FeeMethod' element value. Two character generic code to identify ticket level charges, fees and taxes.
     * 
     * @param feeMethod
     */
    public void setFeeMethod(String feeMethod) {
        this.feeMethod = feeMethod;
    }

    /** 
     * Get the 'Descriptions' element value. SERVICE Description.

    Note: Supports plain text, multimedia and code and link references.
     * 
     * @return value
     */
    public ServiceDescriptionType getDescriptions() {
        return descriptions;
    }

    /** 
     * Set the 'Descriptions' element value. SERVICE Description.

    Note: Supports plain text, multimedia and code and link references.
     * 
     * @param descriptions
     */
    public void setDescriptions(ServiceDescriptionType descriptions) {
        this.descriptions = descriptions;
    }

    /** 
     * Get the 'Settlement' element value.
     * 
     * @return value
     */
    public Settlement getSettlement() {
        return settlement;
    }

    /** 
     * Set the 'Settlement' element value.
     * 
     * @param settlement
     */
    public void setSettlement(Settlement settlement) {
        this.settlement = settlement;
    }

    /** 
     * Get the 'BookingInstructions' element value.
     * 
     * @return value
     */
    public BookingInstructions getBookingInstructions() {
        return bookingInstructions;
    }

    /** 
     * Set the 'BookingInstructions' element value.
     * 
     * @param bookingInstructions
     */
    public void setBookingInstructions(BookingInstructions bookingInstructions) {
        this.bookingInstructions = bookingInstructions;
    }

    /** 
     * Get the 'ValidatingCarrier' element value. Validating Carrier Airline Designator.
    A two-character alpha-numeric code assigned according to the IATA Resolution 762 or a three-letter airline designator assigned by ICAO.  Refer to IATA Airline Coding Directory .  Example: BA
     * 
     * @return value
     */
    public String getValidatingCarrier() {
        return validatingCarrier;
    }

    /** 
     * Set the 'ValidatingCarrier' element value. Validating Carrier Airline Designator.
    A two-character alpha-numeric code assigned according to the IATA Resolution 762 or a three-letter airline designator assigned by ICAO.  Refer to IATA Airline Coding Directory .  Example: BA
     * 
     * @param validatingCarrier
     */
    public void setValidatingCarrier(String validatingCarrier) {
        this.validatingCarrier = validatingCarrier;
    }

    /** 
     * Get the 'Detail' element value.
     * 
     * @return value
     */
    public Detail getDetail() {
        return detail;
    }

    /** 
     * Set the 'Detail' element value.
     * 
     * @param detail
     */
    public void setDetail(Detail detail) {
        this.detail = detail;
    }

    /** 
     * Get the 'ServiceDefinitionID' attribute value. "A unique Service ID that has been returned in the Shopping results, and identifies an airline service item (ie a product or a service) that can be separately delivered and uniquely described by an airline.

    Example: SRVC-2B88-4C33-9787-9461114BC9BE"
     * 
     * @return value
     */
    public String getServiceDefinitionID() {
        return serviceDefinitionID;
    }

    /** 
     * Set the 'ServiceDefinitionID' attribute value. "A unique Service ID that has been returned in the Shopping results, and identifies an airline service item (ie a product or a service) that can be separately delivered and uniquely described by an airline.

    Example: SRVC-2B88-4C33-9787-9461114BC9BE"
     * 
     * @param serviceDefinitionID
     */
    public void setServiceDefinitionID(String serviceDefinitionID) {
        this.serviceDefinitionID = serviceDefinitionID;
    }

    /** 
     * Get the 'Owner' attribute value. Airline designator or CRS code of the owner/ assigner of the Offer ID, typically used for offer ordering purposes.  Example: UA, BA

    Encoding Scheme: IATA/ A4A (two or three character) Airline or CRS Designator Code
     * 
     * @return value
     */
    public String getOwner() {
        return owner;
    }

    /** 
     * Set the 'Owner' attribute value. Airline designator or CRS code of the owner/ assigner of the Offer ID, typically used for offer ordering purposes.  Example: UA, BA

    Encoding Scheme: IATA/ A4A (two or three character) Airline or CRS Designator Code
     * 
     * @param owner
     */
    public void setOwner(String owner) {
        this.owner = owner;
    }
    /** 
     * Choice to determine if the information of this ServiceDefinition needs to be extended with specific Bag or Seat characteristics, or whether the ServiceDefinition is used as a bundle of further ServiceDefinitions.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element type="xs:string" name="BaggageAllowanceRef"/>
     *   &lt;xs:element type="xs:string" name="SeatDefinitionRefs"/>
     *   &lt;xs:element name="ServiceBundle">
     *     &lt;xs:complexType>
     *       &lt;xs:sequence>
     *         &lt;xs:element name="ServiceDefinitionRef" maxOccurs="unbounded">
     *           &lt;!-- Reference to inner class ServiceDefinitionRef -->
     *         &lt;/xs:element>
     *       &lt;/xs:sequence>
     *       &lt;xs:attribute type="xs:int" name="MaximumQuantity"/>
     *     &lt;/xs:complexType>
     *   &lt;/xs:element>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int BAGGAGE_ALLOWANCE_REF_CHOICE = 0;
        private static final int SEAT_DEFINITION_REFS_CHOICE = 1;
        private static final int SERVICE_BUNDLE_CHOICE = 2;
        private String baggageAllowanceRef;
        private String seatDefinitionRefs;
        private List<ServiceDefinitionRef> serviceDefinitionRefList = new ArrayList<ServiceDefinitionRef>();
        private Integer serviceBundleMaximumQuantity;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if BaggageAllowanceRef is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifBaggageAllowanceRef() {
            return choiceSelect == BAGGAGE_ALLOWANCE_REF_CHOICE;
        }

        /** 
         * Get the 'BaggageAllowanceRef' element value.
         * 
         * @return value
         */
        public String getBaggageAllowanceRef() {
            return baggageAllowanceRef;
        }

        /** 
         * Set the 'BaggageAllowanceRef' element value.
         * 
         * @param baggageAllowanceRef
         */
        public void setBaggageAllowanceRef(String baggageAllowanceRef) {
            setChoiceSelect(BAGGAGE_ALLOWANCE_REF_CHOICE);
            this.baggageAllowanceRef = baggageAllowanceRef;
        }

        /** 
         * Check if SeatDefinitionRefs is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifSeatDefinitionRefs() {
            return choiceSelect == SEAT_DEFINITION_REFS_CHOICE;
        }

        /** 
         * Get the 'SeatDefinitionRefs' element value. Reference to Seats within SeatList to further define the characteristics of the seat product. In a shopping scenario, reference one instance of a seat, for further description. May be used in SeatAvailability messages to reference multiple seats to reflect availability of physical seats of this product type.
         * 
         * @return value
         */
        public String getSeatDefinitionRefs() {
            return seatDefinitionRefs;
        }

        /** 
         * Set the 'SeatDefinitionRefs' element value. Reference to Seats within SeatList to further define the characteristics of the seat product. In a shopping scenario, reference one instance of a seat, for further description. May be used in SeatAvailability messages to reference multiple seats to reflect availability of physical seats of this product type.
         * 
         * @param seatDefinitionRefs
         */
        public void setSeatDefinitionRefs(String seatDefinitionRefs) {
            setChoiceSelect(SEAT_DEFINITION_REFS_CHOICE);
            this.seatDefinitionRefs = seatDefinitionRefs;
        }

        /** 
         * Check if ServiceBundle is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifServiceBundle() {
            return choiceSelect == SERVICE_BUNDLE_CHOICE;
        }

        /** 
         * Get the list of 'ServiceDefinitionRef' element items.
         * 
         * @return list
         */
        public List<ServiceDefinitionRef> getServiceDefinitionRefList() {
            return serviceDefinitionRefList;
        }

        /** 
         * Set the list of 'ServiceDefinitionRef' element items.
         * 
         * @param list
         */
        public void setServiceDefinitionRefList(List<ServiceDefinitionRef> list) {
            setChoiceSelect(SERVICE_BUNDLE_CHOICE);
            serviceDefinitionRefList = list;
        }

        /** 
         * Get the 'MaximumQuantity' attribute value. Maximum quantity of bundle services that can be selected by each passenger referenced in the Offer
         * 
         * @return value
         */
        public Integer getServiceBundleMaximumQuantity() {
            return serviceBundleMaximumQuantity;
        }

        /** 
         * Set the 'MaximumQuantity' attribute value. Maximum quantity of bundle services that can be selected by each passenger referenced in the Offer
         * 
         * @param serviceBundleMaximumQuantity
         */
        public void setServiceBundleMaximumQuantity(
                Integer serviceBundleMaximumQuantity) {
            setChoiceSelect(SERVICE_BUNDLE_CHOICE);
            this.serviceBundleMaximumQuantity = serviceBundleMaximumQuantity;
        }
        /** 
         * Reference to further Service Definitions which form part of this Service Bundle
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceDefinitionRef" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:boolean" name="OptionalInd"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ServiceDefinitionRef implements Serializable
        {
            private String string;
            private Boolean optionalInd;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'OptionalInd' attribute value. Set to 'true' when this Service Definition is optional (i.e. can be selected or not by the passenger)
             * 
             * @return value
             */
            public Boolean getOptionalInd() {
                return optionalInd;
            }

            /** 
             * Set the 'OptionalInd' attribute value. Set to 'true' when this Service Definition is optional (i.e. can be selected or not by the passenger)
             * 
             * @param optionalInd
             */
            public void setOptionalInd(Boolean optionalInd) {
                this.optionalInd = optionalInd;
            }
        }
    }
    /** 
     * Interline Settlement information between airlines, including method of settlement, interline settlement value and currency.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Settlement" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Method"/>
     *       &lt;xs:element type="CurrencyAmountOptType" name="InterlineSettlementValue" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Settlement implements Serializable
    {
        private String method;
        private CurrencyAmountOptType interlineSettlementValue;

        /** 
         * Get the 'Method' element value. Service settlement method.
        Examples:
        AD (Internal Airline Document)
        DS (Direct Settlement)
        EA (EMD Associated or Internal Airline Document)
        ES (EMD Standalone )
        FI (Fare Integrated)
        MA (Flight Associated, Settled via MCO)
        MS (Standalone, Settled via MCO)

        Encoding Scheme: IATA PADIS Codeset SST (Service Settlement Type)
         * 
         * @return value
         */
        public String getMethod() {
            return method;
        }

        /** 
         * Set the 'Method' element value. Service settlement method.
        Examples:
        AD (Internal Airline Document)
        DS (Direct Settlement)
        EA (EMD Associated or Internal Airline Document)
        ES (EMD Standalone )
        FI (Fare Integrated)
        MA (Flight Associated, Settled via MCO)
        MS (Standalone, Settled via MCO)

        Encoding Scheme: IATA PADIS Codeset SST (Service Settlement Type)
         * 
         * @param method
         */
        public void setMethod(String method) {
            this.method = method;
        }

        /** 
         * Get the 'InterlineSettlementValue' element value. Settlement (Price) Value. Example: 300 (USD)

        Note: This represents a Settlement value that is only used between the POA and ORA.
         * 
         * @return value
         */
        public CurrencyAmountOptType getInterlineSettlementValue() {
            return interlineSettlementValue;
        }

        /** 
         * Set the 'InterlineSettlementValue' element value. Settlement (Price) Value. Example: 300 (USD)

        Note: This represents a Settlement value that is only used between the POA and ORA.
         * 
         * @param interlineSettlementValue
         */
        public void setInterlineSettlementValue(
                CurrencyAmountOptType interlineSettlementValue) {
            this.interlineSettlementValue = interlineSettlementValue;
        }
    }
    /** 
     * Optional service booking instructions to include SSR, OSI and Upgrade Method.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BookingInstructions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="SSRCode" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element type="xs:string" name="OSIText" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element type="xs:string" name="Method" minOccurs="0"/>
     *       &lt;xs:element name="UpgradeMethod" minOccurs="0">
     *         &lt;!-- Reference to inner class UpgradeMethod -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element type="xs:string" name="Equipment" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class BookingInstructions implements Serializable
    {
        private List<String> SSRCodeList = new ArrayList<String>();
        private List<String> OSITextList = new ArrayList<String>();
        private String method;
        private UpgradeMethod upgradeMethod;
        private List<String> textList = new ArrayList<String>();
        private String equipment;

        /** 
         * Get the list of 'SSRCode' element items. Passenger assistance SSR code value.
        Examples:
        EXST (EXTRA SEAT REQUIRED)
        INFT (INFANT ACCOMPANYING ADULT PASSENGER)
        PETC (PASSENGER TRAVELING WITH PET IN CABIN)
        UMNR (UNACCOMPANIED MINOR)

        For maximum interoperability, it is recommended that IATA (four character) Special Service Request (SSR) Code values be used. Select an enumerated value from the list of enter a four character SSR code string.

        =notes=
        1. Although optional in the schema, some SSR codes may require associated description elements.
         * 
         * @return list
         */
        public List<String> getSSRCodeList() {
            return SSRCodeList;
        }

        /** 
         * Set the list of 'SSRCode' element items. Passenger assistance SSR code value.
        Examples:
        EXST (EXTRA SEAT REQUIRED)
        INFT (INFANT ACCOMPANYING ADULT PASSENGER)
        PETC (PASSENGER TRAVELING WITH PET IN CABIN)
        UMNR (UNACCOMPANIED MINOR)

        For maximum interoperability, it is recommended that IATA (four character) Special Service Request (SSR) Code values be used. Select an enumerated value from the list of enter a four character SSR code string.

        =notes=
        1. Although optional in the schema, some SSR codes may require associated description elements.
         * 
         * @param list
         */
        public void setSSRCodeList(List<String> list) {
            SSRCodeList = list;
        }

        /** 
         * Get the list of 'OSIText' element items. Other service information (OSI) text.
        Example: PAX VIP MEMBER OF PARLIAMENT
         * 
         * @return list
         */
        public List<String> getOSITextList() {
            return OSITextList;
        }

        /** 
         * Set the list of 'OSIText' element items. Other service information (OSI) text.
        Example: PAX VIP MEMBER OF PARLIAMENT
         * 
         * @param list
         */
        public void setOSITextList(List<String> list) {
            OSITextList = list;
        }

        /** 
         * Get the 'Method' element value. PNR booking method.
        Example: AE (BY SSR - SPECIAL SERVICE REQUEST)

        For maximum interoperability, refer to IATA PADIS Code List for data element 9750. Select a code value or enter a value that is bilaterally agreed upon between trading partners.
         * 
         * @return value
         */
        public String getMethod() {
            return method;
        }

        /** 
         * Set the 'Method' element value. PNR booking method.
        Example: AE (BY SSR - SPECIAL SERVICE REQUEST)

        For maximum interoperability, refer to IATA PADIS Code List for data element 9750. Select a code value or enter a value that is bilaterally agreed upon between trading partners.
         * 
         * @param method
         */
        public void setMethod(String method) {
            this.method = method;
        }

        /** 
         * Get the 'UpgradeMethod' element value.
         * 
         * @return value
         */
        public UpgradeMethod getUpgradeMethod() {
            return upgradeMethod;
        }

        /** 
         * Set the 'UpgradeMethod' element value.
         * 
         * @param upgradeMethod
         */
        public void setUpgradeMethod(UpgradeMethod upgradeMethod) {
            this.upgradeMethod = upgradeMethod;
        }

        /** 
         * Get the list of 'Text' element items. Data center instructions.
         * 
         * @return list
         */
        public List<String> getTextList() {
            return textList;
        }

        /** 
         * Set the list of 'Text' element items. Data center instructions.
         * 
         * @param list
         */
        public void setTextList(List<String> list) {
            textList = list;
        }

        /** 
         * Get the 'Equipment' element value. Aircraft equipment information.
         * 
         * @return value
         */
        public String getEquipment() {
            return equipment;
        }

        /** 
         * Set the 'Equipment' element value. Aircraft equipment information.
         * 
         * @param equipment
         */
        public void setEquipment(String equipment) {
            this.equipment = equipment;
        }
        /** 
         * Upgrade method.
        Example: AE (BY SSR - SPECIAL SERVICE REQUEST)

        For maximum interoperability, refer to IATA PADIS Code List for data element 9750. Select a code value or enter a value that is bilaterally agreed upon between trading partners.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UpgradeMethod" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" use="optional" name="NewClass"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class UpgradeMethod implements Serializable
        {
            private String string;
            private String newClass;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'NewClass' attribute value. New class of service.
            Example: B
             * 
             * @return value
             */
            public String getNewClass() {
                return newClass;
            }

            /** 
             * Set the 'NewClass' attribute value. New class of service.
            Example: B
             * 
             * @param newClass
             */
            public void setNewClass(String newClass) {
                this.newClass = newClass;
            }
        }
    }
    /** 
     * Detailed Service information, including Service Bundle,  Service Combinations, Service Coupon, Service Fulfillment and Service Quantity Rules.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Detail" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ServiceCombinations" minOccurs="0"/>
     *       &lt;xs:element ref="ServiceCoupon" minOccurs="0"/>
     *       &lt;xs:element ref="ServiceFulfillment" minOccurs="0"/>
     *       &lt;xs:element ref="ServiceItemQuantityRules" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Detail implements Serializable
    {
        private ServiceCombinationType serviceCombinations;
        private ServiceCouponType serviceCoupon;
        private ServiceFulfillmentType serviceFulfillment;
        private ServiceItemQuantityType serviceItemQuantityRules;

        /** 
         * Get the 'ServiceCombinations' element value.
         * 
         * @return value
         */
        public ServiceCombinationType getServiceCombinations() {
            return serviceCombinations;
        }

        /** 
         * Set the 'ServiceCombinations' element value.
         * 
         * @param serviceCombinations
         */
        public void setServiceCombinations(
                ServiceCombinationType serviceCombinations) {
            this.serviceCombinations = serviceCombinations;
        }

        /** 
         * Get the 'ServiceCoupon' element value.
         * 
         * @return value
         */
        public ServiceCouponType getServiceCoupon() {
            return serviceCoupon;
        }

        /** 
         * Set the 'ServiceCoupon' element value.
         * 
         * @param serviceCoupon
         */
        public void setServiceCoupon(ServiceCouponType serviceCoupon) {
            this.serviceCoupon = serviceCoupon;
        }

        /** 
         * Get the 'ServiceFulfillment' element value.
         * 
         * @return value
         */
        public ServiceFulfillmentType getServiceFulfillment() {
            return serviceFulfillment;
        }

        /** 
         * Set the 'ServiceFulfillment' element value.
         * 
         * @param serviceFulfillment
         */
        public void setServiceFulfillment(
                ServiceFulfillmentType serviceFulfillment) {
            this.serviceFulfillment = serviceFulfillment;
        }

        /** 
         * Get the 'ServiceItemQuantityRules' element value.
         * 
         * @return value
         */
        public ServiceItemQuantityType getServiceItemQuantityRules() {
            return serviceItemQuantityRules;
        }

        /** 
         * Set the 'ServiceItemQuantityRules' element value.
         * 
         * @param serviceItemQuantityRules
         */
        public void setServiceItemQuantityRules(
                ServiceItemQuantityType serviceItemQuantityRules) {
            this.serviceItemQuantityRules = serviceItemQuantityRules;
        }
    }
}
