
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * OPTIONAL SERVICE FILTER definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceFilterType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="GroupCode"/>
 *     &lt;xs:element type="xs:string" name="SubGroupCode" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class ServiceFilterType implements Serializable
{
    private String groupCode;
    private List<String> subGroupCodeList = new ArrayList<String>();
    private String refs;

    /** 
     * Get the 'GroupCode' element value. Identifies additional services codes, and may refer to ATPCO additional services information or airline specific/ bilaterally agreed codes.
     * 
     * @return value
     */
    public String getGroupCode() {
        return groupCode;
    }

    /** 
     * Set the 'GroupCode' element value. Identifies additional services codes, and may refer to ATPCO additional services information or airline specific/ bilaterally agreed codes.
     * 
     * @param groupCode
     */
    public void setGroupCode(String groupCode) {
        this.groupCode = groupCode;
    }

    /** 
     * Get the list of 'SubGroupCode' element items. Service Sub-Group Code(s).

    Group BG: CT (Container), PP (Pre-Paid Excess Baggage)
    Group IE: IT (Internet Access), TV (Television)


     * 
     * @return list
     */
    public List<String> getSubGroupCodeList() {
        return subGroupCodeList;
    }

    /** 
     * Set the list of 'SubGroupCode' element items. Service Sub-Group Code(s).

    Group BG: CT (Container), PP (Pre-Paid Excess Baggage)
    Group IE: IT (Internet Access), TV (Television)


     * 
     * @param list
     */
    public void setSubGroupCodeList(List<String> list) {
        subGroupCodeList = list;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
