
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Other Service Associations.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceOtherAssocType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="OtherAssociation" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class OtherAssociation -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ServiceOtherAssocType implements Serializable
{
    private List<OtherAssociation> otherAssociationList = new ArrayList<OtherAssociation>();

    /** 
     * Get the list of 'OtherAssociation' element items.
     * 
     * @return list
     */
    public List<OtherAssociation> getOtherAssociationList() {
        return otherAssociationList;
    }

    /** 
     * Set the list of 'OtherAssociation' element items.
     * 
     * @param list
     */
    public void setOtherAssociationList(List<OtherAssociation> list) {
        otherAssociationList = list;
    }
    /** 
     * Other Association Detail.

    Note: Includes an association type choice (e.g. MediaGroup) and an instance association value (e.g. mediagrp1).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherAssociation" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Type">
     *         &lt;xs:complexType>
     *           &lt;xs:simpleContent>
     *             &lt;xs:extension base="xs:string">
     *               &lt;xs:attribute type="xs:anySimpleType" name="Code"/>
     *             &lt;/xs:extension>
     *           &lt;/xs:simpleContent>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="ReferenceValue"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OtherAssociation implements Serializable
    {
        private String typeString;
        private String typeCode;
        private String referenceValue;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getTypeString() {
            return typeString;
        }

        /** 
         * Set the extension value.
         * 
         * @param typeString
         */
        public void setTypeString(String typeString) {
            this.typeString = typeString;
        }

        /** 
         * Get the 'Code' attribute value. Value of the SSR code.
         * 
         * @return value
         */
        public String getTypeCode() {
            return typeCode;
        }

        /** 
         * Set the 'Code' attribute value. Value of the SSR code.
         * 
         * @param typeCode
         */
        public void setTypeCode(String typeCode) {
            this.typeCode = typeCode;
        }

        /** 
         * Get the 'ReferenceValue' element value. Associated object instance value. Example: mediagrp1
         * 
         * @return value
         */
        public String getReferenceValue() {
            return referenceValue;
        }

        /** 
         * Set the 'ReferenceValue' element value. Associated object instance value. Example: mediagrp1
         * 
         * @param referenceValue
         */
        public void setReferenceValue(String referenceValue) {
            this.referenceValue = referenceValue;
        }
    }
}
