
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * Shopping Metadata choices.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ShopMetadataGroup">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="Baggage" minOccurs="0"/>
 *       &lt;xs:element ref="Fare" minOccurs="0"/>
 *       &lt;xs:element ref="Flight" minOccurs="0"/>
 *       &lt;xs:element ref="Location" minOccurs="0"/>
 *       &lt;xs:element ref="Offer" minOccurs="0"/>
 *       &lt;xs:element ref="Pricing" minOccurs="0"/>
 *       &lt;xs:element ref="Qualifier" minOccurs="0"/>
 *       &lt;xs:element ref="Seat" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class ShopMetadataGroup implements Serializable
{
    private Baggage baggage;
    private FareType fare;
    private Flight flight;
    private Location location;
    private Offer offer;
    private Pricing pricing;
    private Qualifier qualifier;
    private Seat seat;

    /** 
     * Get the 'Baggage' element value.
     * 
     * @return value
     */
    public Baggage getBaggage() {
        return baggage;
    }

    /** 
     * Set the 'Baggage' element value.
     * 
     * @param baggage
     */
    public void setBaggage(Baggage baggage) {
        this.baggage = baggage;
    }

    /** 
     * Get the 'Fare' element value.
     * 
     * @return value
     */
    public FareType getFare() {
        return fare;
    }

    /** 
     * Set the 'Fare' element value.
     * 
     * @param fare
     */
    public void setFare(FareType fare) {
        this.fare = fare;
    }

    /** 
     * Get the 'Flight' element value.
     * 
     * @return value
     */
    public Flight getFlight() {
        return flight;
    }

    /** 
     * Set the 'Flight' element value.
     * 
     * @param flight
     */
    public void setFlight(Flight flight) {
        this.flight = flight;
    }

    /** 
     * Get the 'Location' element value. Location-related Metadata, including Directions.
     * 
     * @return value
     */
    public Location getLocation() {
        return location;
    }

    /** 
     * Set the 'Location' element value. Location-related Metadata, including Directions.
     * 
     * @param location
     */
    public void setLocation(Location location) {
        this.location = location;
    }

    /** 
     * Get the 'Offer' element value.
     * 
     * @return value
     */
    public Offer getOffer() {
        return offer;
    }

    /** 
     * Set the 'Offer' element value.
     * 
     * @param offer
     */
    public void setOffer(Offer offer) {
        this.offer = offer;
    }

    /** 
     * Get the 'Pricing' element value. Pricing-related Metadata, including Discount.
     * 
     * @return value
     */
    public Pricing getPricing() {
        return pricing;
    }

    /** 
     * Set the 'Pricing' element value. Pricing-related Metadata, including Discount.
     * 
     * @param pricing
     */
    public void setPricing(Pricing pricing) {
        this.pricing = pricing;
    }

    /** 
     * Get the 'Qualifier' element value.
     * 
     * @return value
     */
    public Qualifier getQualifier() {
        return qualifier;
    }

    /** 
     * Set the 'Qualifier' element value.
     * 
     * @param qualifier
     */
    public void setQualifier(Qualifier qualifier) {
        this.qualifier = qualifier;
    }

    /** 
     * Get the 'Seat' element value.
     * 
     * @return value
     */
    public Seat getSeat() {
        return seat;
    }

    /** 
     * Set the 'Seat' element value.
     * 
     * @param seat
     */
    public void setSeat(Seat seat) {
        this.seat = seat;
    }
}
