
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * SHOPPING RESPONSE object definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ShoppingResponseID_Type">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Owner" minOccurs="0"/>
 *     &lt;xs:element name="ResponseID">
 *       &lt;xs:complexType>
 *         &lt;xs:simpleContent>
 *           &lt;xs:extension base="xs:string">
 *             &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 *           &lt;/xs:extension>
 *         &lt;/xs:simpleContent>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class ShoppingResponseIDType implements Serializable
{
    private String owner;
    private String responseIDString;
    private String responseIDRefs;
    private String refs;

    /** 
     * Get the 'Owner' element value. Designator of Airline that owns/ assigned these IDs. Examples: BA

    Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Code
     * 
     * @return value
     */
    public String getOwner() {
        return owner;
    }

    /** 
     * Set the 'Owner' element value. Designator of Airline that owns/ assigned these IDs. Examples: BA

    Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Code
     * 
     * @param owner
     */
    public void setOwner(String owner) {
        this.owner = owner;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getResponseIDString() {
        return responseIDString;
    }

    /** 
     * Set the extension value.
     * 
     * @param responseIDString
     */
    public void setResponseIDString(String responseIDString) {
        this.responseIDString = responseIDString;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getResponseIDRefs() {
        return responseIDRefs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param responseIDRefs
     */
    public void setResponseIDRefs(String responseIDRefs) {
        this.responseIDRefs = responseIDRefs;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
