
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * A data type for Size Values list constraint. Examples: Centimeter, Inch
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SizeUnitSimpleType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Centimeter"/>
 *     &lt;xs:enumeration value="Inch"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum SizeUnitSimpleType implements Serializable {
    CENTIMETER("Centimeter"), INCH("Inch");
    private final String value;

    private SizeUnitSimpleType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static SizeUnitSimpleType convert(String value) {
        for (SizeUnitSimpleType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
