
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import org.joda.time.LocalDate;

/** 
 * A data type for Start and End Date Range with Minimum/ Maximum Stay Duration.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StayPeriodDateRangeType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:date" name="StartDate"/>
 *     &lt;xs:element type="xs:date" name="EndDate"/>
 *     &lt;xs:element type="xs:string" name="MinimumStay" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="MaximumStay" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class StayPeriodDateRangeType implements Serializable
{
    private LocalDate startDate;
    private LocalDate endDate;
    private String minimumStay;
    private String maximumStay;
    private String refs;

    /** 
     * Get the 'StartDate' element value. Starting Date of the stay period range. Example: 2016-01-13
     * 
     * @return value
     */
    public LocalDate getStartDate() {
        return startDate;
    }

    /** 
     * Set the 'StartDate' element value. Starting Date of the stay period range. Example: 2016-01-13
     * 
     * @param startDate
     */
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    /** 
     * Get the 'EndDate' element value. Ending Date of the stay period range. Example: 2016-03-13
     * 
     * @return value
     */
    public LocalDate getEndDate() {
        return endDate;
    }

    /** 
     * Set the 'EndDate' element value. Ending Date of the stay period range. Example: 2016-03-13
     * 
     * @param endDate
     */
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    /** 
     * Get the 'MinimumStay' element value. Minimum Stay Period within the specified date range.
    Examples: P5D (five days)
     * 
     * @return value
     */
    public String getMinimumStay() {
        return minimumStay;
    }

    /** 
     * Set the 'MinimumStay' element value. Minimum Stay Period within the specified date range.
    Examples: P5D (five days)
     * 
     * @param minimumStay
     */
    public void setMinimumStay(String minimumStay) {
        this.minimumStay = minimumStay;
    }

    /** 
     * Get the 'MaximumStay' element value. Maximum Stay Period within the specified date range.
    Example: P10D (ten days)
     * 
     * @return value
     */
    public String getMaximumStay() {
        return maximumStay;
    }

    /** 
     * Set the 'MaximumStay' element value. Maximum Stay Period within the specified date range.
    Example: P10D (ten days)
     * 
     * @param maximumStay
     */
    public void setMaximumStay(String maximumStay) {
        this.maximumStay = maximumStay;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
