
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.LocalDate;

/** 
 * FLIGHT STOP LOCATION definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StopLocationType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="StopLocation" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class StopLocation -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="ChangeOfGaugeInd"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class StopLocationType implements Serializable
{
    private List<StopLocation> stopLocationList = new ArrayList<StopLocation>();
    private Boolean changeOfGaugeInd;

    /** 
     * Get the list of 'StopLocation' element items.
     * 
     * @return list
     */
    public List<StopLocation> getStopLocationList() {
        return stopLocationList;
    }

    /** 
     * Set the list of 'StopLocation' element items.
     * 
     * @param list
     */
    public void setStopLocationList(List<StopLocation> list) {
        stopLocationList = list;
    }

    /** 
     * Get the 'ChangeOfGaugeInd' attribute value. When true, there has been a Change of Gauge.
     * 
     * @return value
     */
    public Boolean getChangeOfGaugeInd() {
        return changeOfGaugeInd;
    }

    /** 
     * Set the 'ChangeOfGaugeInd' attribute value. When true, there has been a Change of Gauge.
     * 
     * @param changeOfGaugeInd
     */
    public void setChangeOfGaugeInd(Boolean changeOfGaugeInd) {
        this.changeOfGaugeInd = changeOfGaugeInd;
    }
    /** 
     * Stop Location detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StopLocation" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="AirportCode"/>
     *       &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
     *       &lt;xs:element type="xs:date" name="ArrivalDate"/>
     *       &lt;xs:element type="xs:string" name="ArrivalTime"/>
     *       &lt;xs:element type="xs:date" name="DepartureDate"/>
     *       &lt;xs:element type="xs:string" name="DepartureTime"/>
     *       &lt;xs:element ref="Equipment" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="GroundTime" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class StopLocation implements Serializable
    {
        private AirportCode airportCode;
        private String name;
        private LocalDate arrivalDate;
        private String arrivalTime;
        private LocalDate departureDate;
        private String departureTime;
        private AircraftSummaryType equipment;
        private String groundTime;
        private String refs;

        /** 
         * Get the 'AirportCode' element value.
         * 
         * @return value
         */
        public AirportCode getAirportCode() {
            return airportCode;
        }

        /** 
         * Set the 'AirportCode' element value.
         * 
         * @param airportCode
         */
        public void setAirportCode(AirportCode airportCode) {
            this.airportCode = airportCode;
        }

        /** 
         * Get the 'Name' element value. Airport Name. Example: Tampa International
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'Name' element value. Airport Name. Example: Tampa International
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }

        /** 
         * Get the 'ArrivalDate' element value. Stop Arrival date. Example: 2017-01-14

        Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
         * 
         * @return value
         */
        public LocalDate getArrivalDate() {
            return arrivalDate;
        }

        /** 
         * Set the 'ArrivalDate' element value. Stop Arrival date. Example: 2017-01-14

        Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
         * 
         * @param arrivalDate
         */
        public void setArrivalDate(LocalDate arrivalDate) {
            this.arrivalDate = arrivalDate;
        }

        /** 
         * Get the 'ArrivalTime' element value. Arrival time. Example: 09:15

        Encoding Scheme: ISO 8601 Military/ 24 Hour Format (HH:MM)
         * 
         * @return value
         */
        public String getArrivalTime() {
            return arrivalTime;
        }

        /** 
         * Set the 'ArrivalTime' element value. Arrival time. Example: 09:15

        Encoding Scheme: ISO 8601 Military/ 24 Hour Format (HH:MM)
         * 
         * @param arrivalTime
         */
        public void setArrivalTime(String arrivalTime) {
            this.arrivalTime = arrivalTime;
        }

        /** 
         * Get the 'DepartureDate' element value. Scheduled Departure Date. Example: 2017-01-13

        Note: This is the date and time of departure in GMT from the unticketed point.
         * 
         * @return value
         */
        public LocalDate getDepartureDate() {
            return departureDate;
        }

        /** 
         * Set the 'DepartureDate' element value. Scheduled Departure Date. Example: 2017-01-13

        Note: This is the date and time of departure in GMT from the unticketed point.
         * 
         * @param departureDate
         */
        public void setDepartureDate(LocalDate departureDate) {
            this.departureDate = departureDate;
        }

        /** 
         * Get the 'DepartureTime' element value. Departure time. Example: 09:15

        Encoding Scheme: ISO 8601 Military/ 24 Hour Format (HH:MM)
         * 
         * @return value
         */
        public String getDepartureTime() {
            return departureTime;
        }

        /** 
         * Set the 'DepartureTime' element value. Departure time. Example: 09:15

        Encoding Scheme: ISO 8601 Military/ 24 Hour Format (HH:MM)
         * 
         * @param departureTime
         */
        public void setDepartureTime(String departureTime) {
            this.departureTime = departureTime;
        }

        /** 
         * Get the 'Equipment' element value.
         * 
         * @return value
         */
        public AircraftSummaryType getEquipment() {
            return equipment;
        }

        /** 
         * Set the 'Equipment' element value.
         * 
         * @param equipment
         */
        public void setEquipment(AircraftSummaryType equipment) {
            this.equipment = equipment;
        }

        /** 
         * Get the 'GroundTime' element value. Flight Stop Groundtime.
        Example: PT5M (45 minutes)
         * 
         * @return value
         */
        public String getGroundTime() {
            return groundTime;
        }

        /** 
         * Set the 'GroundTime' element value. Flight Stop Groundtime.
        Example: PT5M (45 minutes)
         * 
         * @param groundTime
         */
        public void setGroundTime(String groundTime) {
            this.groundTime = groundTime;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
}
