
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for SUPPLIER GROUP, Core Representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SupplierCoreRepType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ActorObjectType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="OtherIDs" minOccurs="0">
 *           &lt;!-- Reference to inner class OtherIDs -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SupplierCoreRepType extends ActorObjectType implements
    Serializable
{
    private OtherIDs otherIDs;

    /** 
     * Get the 'OtherIDs' element value.
     * 
     * @return value
     */
    public OtherIDs getOtherIDs() {
        return otherIDs;
    }

    /** 
     * Set the 'OtherIDs' element value.
     * 
     * @param otherIDs
     */
    public void setOtherIDs(OtherIDs otherIDs) {
        this.otherIDs = otherIDs;
    }
    /** 
     * Additional supplier identification such as federal tax IDs or registry entries.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherIDs" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="OtherID" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class OtherID -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OtherIDs implements Serializable
    {
        private List<OtherID> otherIDList = new ArrayList<OtherID>();

        /** 
         * Get the list of 'OtherID' element items.
         * 
         * @return list
         */
        public List<OtherID> getOtherIDList() {
            return otherIDList;
        }

        /** 
         * Set the list of 'OtherID' element items.
         * 
         * @param list
         */
        public void setOtherIDList(List<OtherID> list) {
            otherIDList = list;
        }
        /** 
         * Other ID Unique identifier. Examples: 13-015576, 50014517
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherID" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" use="optional" name="Description"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OtherID implements Serializable
        {
            private String string;
            private String description;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'Description' attribute value. Other identification description.  Examples: Federal Tax ID, TICO ID
             * 
             * @return value
             */
            public String getDescription() {
                return description;
            }

            /** 
             * Set the 'Description' attribute value. Other identification description.  Examples: Federal Tax ID, TICO ID
             * 
             * @param description
             */
            public void setDescription(String description) {
                this.description = description;
            }
        }
    }
}
