
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * A data type for Effective/ Expiration Time Period Representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TimePeriodRepType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Effective" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Expiration" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TimePeriodRepType implements Serializable
{
    private String effective;
    private String expiration;

    /** 
     * Get the 'Effective' element value. Effective (start) time.  Example: 09:00

    Encoding Scheme: ISO 8601 Military/ 24 Hour Format (HH:MM)
     * 
     * @return value
     */
    public String getEffective() {
        return effective;
    }

    /** 
     * Set the 'Effective' element value. Effective (start) time.  Example: 09:00

    Encoding Scheme: ISO 8601 Military/ 24 Hour Format (HH:MM)
     * 
     * @param effective
     */
    public void setEffective(String effective) {
        this.effective = effective;
    }

    /** 
     * Get the 'Expiration' element value. Expiration time.  Example: 18:00

    Encoding Scheme: ISO 8601 Military/ 24 Hour Format (HH:MM)
     * 
     * @return value
     */
    public String getExpiration() {
        return expiration;
    }

    /** 
     * Set the 'Expiration' element value. Expiration time.  Example: 18:00

    Encoding Scheme: ISO 8601 Military/ 24 Hour Format (HH:MM)
     * 
     * @param expiration
     */
    public void setExpiration(String expiration) {
        this.expiration = expiration;
    }
}
