
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * This node contains information about any voucher that might exist in the reservation
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://ndc.farelogix.com/aug" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Vouchers">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="CouponReference" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class CouponReference -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class Vouchers implements Serializable
{
    private List<CouponReference> couponReferenceList = new ArrayList<CouponReference>();

    /** 
     * Get the list of 'CouponReference' element items.
     * 
     * @return list
     */
    public List<CouponReference> getCouponReferenceList() {
        return couponReferenceList;
    }

    /** 
     * Set the list of 'CouponReference' element items.
     * 
     * @param list
     */
    public void setCouponReferenceList(List<CouponReference> list) {
        couponReferenceList = list;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://ndc.farelogix.com/aug" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CouponReference" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="VoucherImage">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element type="xs:string" name="PassengerReferences"/>
     *             &lt;xs:element type="xs:string" name="SegmentReferences"/>
     *             &lt;xs:element type="xs:string" name="VoucherNumber"/>
     *             &lt;xs:element name="Image">
     *               &lt;xs:complexType>
     *                 &lt;xs:simpleContent>
     *                   &lt;xs:extension base="xs:string">
     *                     &lt;xs:attribute type="xs:string" use="required" name="Encoding"/>
     *                     &lt;xs:attribute type="xs:string" use="optional" name="Symbology"/>
     *                     &lt;xs:attribute type="xs:string" use="required" name="Format"/>
     *                   &lt;/xs:extension>
     *                 &lt;/xs:simpleContent>
     *               &lt;/xs:complexType>
     *             &lt;/xs:element>
     *             &lt;xs:element name="WebLinks" minOccurs="0">
     *               &lt;!-- Reference to inner class WebLinks -->
     *             &lt;/xs:element>
     *           &lt;/xs:sequence>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="required" name="CouponNumber"/>
     *     &lt;xs:attribute type="xs:string" use="required" name="TicketDocNbr"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CouponReference implements Serializable
    {
        private String voucherImagePassengerReferences;
        private String voucherImageSegmentReferences;
        private String voucherImageVoucherNumber;
        private String voucherImageImageString;
        private String voucherImageImageEncoding;
        private String voucherImageImageSymbology;
        private String voucherImageImageFormat;
        private WebLinks webLinks;
        private String couponNumber;
        private String ticketDocNbr;

        /** 
         * Get the 'PassengerReferences' element value. 
                                      Association to multiple Passenger instance(s). Example: pax1 pax2
                                    
         * 
         * @return value
         */
        public String getVoucherImagePassengerReferences() {
            return voucherImagePassengerReferences;
        }

        /** 
         * Set the 'PassengerReferences' element value. 
                                      Association to multiple Passenger instance(s). Example: pax1 pax2
                                    
         * 
         * @param voucherImagePassengerReferences
         */
        public void setVoucherImagePassengerReferences(
                String voucherImagePassengerReferences) {
            this.voucherImagePassengerReferences = voucherImagePassengerReferences;
        }

        /** 
         * Get the 'SegmentReferences' element value.
         * 
         * @return value
         */
        public String getVoucherImageSegmentReferences() {
            return voucherImageSegmentReferences;
        }

        /** 
         * Set the 'SegmentReferences' element value.
         * 
         * @param voucherImageSegmentReferences
         */
        public void setVoucherImageSegmentReferences(
                String voucherImageSegmentReferences) {
            this.voucherImageSegmentReferences = voucherImageSegmentReferences;
        }

        /** 
         * Get the 'VoucherNumber' element value. Voucher Number for this voucher                       Example: 1
         * 
         * @return value
         */
        public String getVoucherImageVoucherNumber() {
            return voucherImageVoucherNumber;
        }

        /** 
         * Set the 'VoucherNumber' element value. Voucher Number for this voucher                       Example: 1
         * 
         * @param voucherImageVoucherNumber
         */
        public void setVoucherImageVoucherNumber(
                String voucherImageVoucherNumber) {
            this.voucherImageVoucherNumber = voucherImageVoucherNumber;
        }

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getVoucherImageImageString() {
            return voucherImageImageString;
        }

        /** 
         * Set the extension value.
         * 
         * @param voucherImageImageString
         */
        public void setVoucherImageImageString(String voucherImageImageString) {
            this.voucherImageImageString = voucherImageImageString;
        }

        /** 
         * Get the 'Encoding' attribute value. Encoding method used

        Example: base64
         * 
         * @return value
         */
        public String getVoucherImageImageEncoding() {
            return voucherImageImageEncoding;
        }

        /** 
         * Set the 'Encoding' attribute value. Encoding method used

        Example: base64
         * 
         * @param voucherImageImageEncoding
         */
        public void setVoucherImageImageEncoding(
                String voucherImageImageEncoding) {
            this.voucherImageImageEncoding = voucherImageImageEncoding;
        }

        /** 
         * Get the 'Symbology' attribute value. Symbology applied

        Example: PDF417
         * 
         * @return value
         */
        public String getVoucherImageImageSymbology() {
            return voucherImageImageSymbology;
        }

        /** 
         * Set the 'Symbology' attribute value. Symbology applied

        Example: PDF417
         * 
         * @param voucherImageImageSymbology
         */
        public void setVoucherImageImageSymbology(
                String voucherImageImageSymbology) {
            this.voucherImageImageSymbology = voucherImageImageSymbology;
        }

        /** 
         * Get the 'Format' attribute value. Image format used

        Example: jpeg
         * 
         * @return value
         */
        public String getVoucherImageImageFormat() {
            return voucherImageImageFormat;
        }

        /** 
         * Set the 'Format' attribute value. Image format used

        Example: jpeg
         * 
         * @param voucherImageImageFormat
         */
        public void setVoucherImageImageFormat(String voucherImageImageFormat) {
            this.voucherImageImageFormat = voucherImageImageFormat;
        }

        /** 
         * Get the 'WebLinks' element value.
         * 
         * @return value
         */
        public WebLinks getWebLinks() {
            return webLinks;
        }

        /** 
         * Set the 'WebLinks' element value.
         * 
         * @param webLinks
         */
        public void setWebLinks(WebLinks webLinks) {
            this.webLinks = webLinks;
        }

        /** 
         * Get the 'CouponNumber' attribute value. Coupon number that voucher is associated to.
         * 
         * @return value
         */
        public String getCouponNumber() {
            return couponNumber;
        }

        /** 
         * Set the 'CouponNumber' attribute value. Coupon number that voucher is associated to.
         * 
         * @param couponNumber
         */
        public void setCouponNumber(String couponNumber) {
            this.couponNumber = couponNumber;
        }

        /** 
         * Get the 'TicketDocNbr' attribute value. Coupon Document Number.

        Note: This is the document number comprised of the airline code, form code, and serial number.
         * 
         * @return value
         */
        public String getTicketDocNbr() {
            return ticketDocNbr;
        }

        /** 
         * Set the 'TicketDocNbr' attribute value. Coupon Document Number.

        Note: This is the document number comprised of the airline code, form code, and serial number.
         * 
         * @param ticketDocNbr
         */
        public void setTicketDocNbr(String ticketDocNbr) {
            this.ticketDocNbr = ticketDocNbr;
        }
        /** 
         * Links to associated promotional material
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://ndc.farelogix.com/aug" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="WebLinks" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="WebLink" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class WebLink -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class WebLinks implements Serializable
        {
            private List<WebLink> webLinkList = new ArrayList<WebLink>();

            /** 
             * Get the list of 'WebLink' element items.
             * 
             * @return list
             */
            public List<WebLink> getWebLinkList() {
                return webLinkList;
            }

            /** 
             * Set the list of 'WebLink' element items.
             * 
             * @param list
             */
            public void setWebLinkList(List<WebLink> list) {
                webLinkList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://ndc.farelogix.com/aug" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="WebLink" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute name="Type">
             *           &lt;xs:simpleType>
             *             &lt;!-- Reference to inner class Type -->
             *           &lt;/xs:simpleType>
             *         &lt;/xs:attribute>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class WebLink implements Serializable
            {
                private String string;
                private Type type;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'Type' attribute value. Indicates what the content of the web link is; these are possible values:
                “I”  Image
                “V” Video
                “C” HTML or other webpages                          "D" Deeplink URL           "R" RouteHappy content      "T" Template Location
                 * 
                 * @return value
                 */
                public Type getType() {
                    return type;
                }

                /** 
                 * Set the 'Type' attribute value. Indicates what the content of the web link is; these are possible values:
                “I”  Image
                “V” Video
                “C” HTML or other webpages                          "D" Deeplink URL           "R" RouteHappy content      "T" Template Location
                 * 
                 * @param type
                 */
                public void setType(Type type) {
                    this.type = type;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
                 *   &lt;xs:restriction base="xs:string">
                 *     &lt;xs:enumeration value="I"/>
                 *     &lt;xs:enumeration value="V"/>
                 *     &lt;xs:enumeration value="C"/>
                 *     &lt;xs:enumeration value="D"/>
                 *     &lt;xs:enumeration value="R"/>
                 *     &lt;xs:enumeration value="T"/>
                 *   &lt;/xs:restriction>
                 * &lt;/xs:simpleType>
                 * </pre>
                 */
                public static enum Type implements Serializable {
                    I, V, C, D, R, T
                }
            }
        }
    }
}
