/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flyArystan;

import com.gridnine.xtrip.common.gds.model.AncillaryFreeTextAvailability;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeValue;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanHelper;
import com.gridnine.xtrip.server.jaxws.JaxWsHelper;
import com.hititcs.crane.ws.ancillary.AirItineraryType;
import com.hititcs.crane.ws.ancillary.AirTravelerType;
import com.hititcs.crane.ws.ancillary.AirportType;
import com.hititcs.crane.ws.ancillary.AmountType;
import com.hititcs.crane.ws.ancillary.BookFlightSegmentType;
import com.hititcs.crane.ws.ancillary.BookOriginDestinationOptionType;
import com.hititcs.crane.ws.ancillary.BookOriginDestinationOptionsType;
import com.hititcs.crane.ws.ancillary.BookingClassType;
import com.hititcs.crane.ws.ancillary.CabinType;
import com.hititcs.crane.ws.ancillary.CompanyNameType;
import com.hititcs.crane.ws.ancillary.CouponInfoType;
import com.hititcs.crane.ws.ancillary.EquipmentType;
import com.hititcs.crane.ws.ancillary.FareInfoType;
import com.hititcs.crane.ws.ancillary.FlightSegmentType;
import com.hititcs.crane.ws.ancillary.PassengerTypeCodeType;
import com.hititcs.crane.ws.ancillary.PersonNameType;
import com.hititcs.crane.ws.ancillary.SsrFreeTextEnum;
import com.hititcs.crane.ws.ancillary.SsrType;
import com.hititcs.crane.ws.ancillary.TicketItemType;
import com.hititcs.crane.ws.ancillary.TicketType;
import com.hititcs.crane.ws.ancillary.UniqueIDType;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FlyArystanAncHelper {
    private static Map<PassengerTypeValue, PassengerTypeCodeType> passengerTypeMap = new HashMap<PassengerTypeValue, PassengerTypeCodeType>();
    private static Map<ClassOfService, CabinType> serviceClassCabinMap;
    private static Map<SsrFreeTextEnum, AncillaryFreeTextAvailability> freeTextAvailabilitiesMap;
    private static final String ANCILLARY_FEE_GDS_ID_SEP = "/";

    public static PassengerTypeCodeType convertPassengerTypeToGds(DictionaryReference<PassengerType> passengerTypeRef) {
        PassengerTypeValue ptv = DictHelper.getPassengerTypeValue(passengerTypeRef);
        return passengerTypeMap.get(ptv);
    }

    public static DictionaryReference<PassengerType> convertPassengerTypeFromGds(PassengerTypeCodeType code) {
        PassengerTypeValue ptv = (PassengerTypeValue)CollectionUtil.getKeyByValue(passengerTypeMap, (Object)code);
        return (DictionaryReference)Optional.ofNullable(ptv).map(DictHelper::getPredifinedValue).map(PassengerType::toReference).orElseThrow(() -> Xeption.forDeveloper((String)"can't convert reservation system passenger type {0}", (Object[])new Object[]{code}));
    }

    public static CabinType convertServiceClassToGdsCabin(ClassOfService serviceClass) {
        return serviceClassCabinMap.get(serviceClass);
    }

    public static AncillaryFreeTextAvailability convertFreeTextAvailabilityFromGds(SsrFreeTextEnum ssrFreeText) {
        return freeTextAvailabilitiesMap.get(ssrFreeText);
    }

    public static String buildAncillaryFeeGdsId(Integer segNumber, String ssrGroup, String ssrCode) {
        return Stream.of(String.valueOf(segNumber), ssrGroup, ssrCode).collect(Collectors.joining(ANCILLARY_FEE_GDS_ID_SEP));
    }

    public static Integer getAncillaryFeeSegNumber(String gdsId) {
        return Integer.valueOf(gdsId.split(ANCILLARY_FEE_GDS_ID_SEP)[0]);
    }

    public static String getAncillaryFeeSsrGroup(String gdsId) {
        String group = gdsId.split(ANCILLARY_FEE_GDS_ID_SEP)[1];
        String code = gdsId.split(ANCILLARY_FEE_GDS_ID_SEP)[2];
        return FlyArystanHelper.calcSsrGroup(group, code);
    }

    public static String getAncillaryFeeSsrCode(String gdsId) {
        return gdsId.split(ANCILLARY_FEE_GDS_ID_SEP)[2];
    }

    public static BigDecimal toBigDecimal(AmountType amount) {
        return Optional.ofNullable(amount).map(AmountType::getValue).map(BigDecimal::valueOf).orElse(null);
    }

    public static UniqueIDType buildBookingReferenceId(Reservation reservation) {
        UniqueIDType result = new UniqueIDType();
        result.setID(FlyArystanHelper.getID(reservation));
        FlyArystanHelper.getReferenceIDOptional(reservation).ifPresent(arg_0 -> ((UniqueIDType)result).setReferenceID(arg_0));
        return result;
    }

    public static String buildGdsId(TicketItemType ticketItem) {
        String trId = ticketItem.getAirTraveler().getTravelerReferenceID();
        if (ticketItem.getType() == TicketType.E_TICKET) {
            return FlyArystanHelper.buildTicketGdsId(trId);
        }
        SsrType ssr = ticketItem.getSpecialServiceRequest();
        String couponSegId = ((CouponInfoType)ticketItem.getCouponInfoList().get(0)).getCouponFlightSegment().getReferenceID();
        return FlyArystanHelper.buildMcoGdsId(ssr.getSpecialServiceReferenceId(), ssr.getGroupCode(), ssr.getCode(), couponSegId);
    }

    public static String getGdsSegmentId(BookFlightSegmentType bookFlightSegment) {
        return bookFlightSegment.getFlightSegment().getFlightSegmentID();
    }

    public static String getGdsSegmentId(CouponInfoType couponInfo) {
        return FlyArystanAncHelper.getGdsSegmentId(couponInfo.getCouponFlightSegment());
    }

    public static AirItineraryType buildAirItinerary(Product product) {
        AirItineraryType result = new AirItineraryType();
        BookOriginDestinationOptionsType bookOriginDestinationOptions = new BookOriginDestinationOptionsType();
        AirProductHelper.getSegments((Collection)product.getSegmentTariffs()).stream().map(seg -> FlyArystanAncHelper.buildBookOriginDestinationOption(seg)).forEach(bookOriginDestinationOptions.getBookOriginDestinationOptionList()::add);
        result.setBookOriginDestinationOptions(bookOriginDestinationOptions);
        return result;
    }

    private static BookOriginDestinationOptionType buildBookOriginDestinationOption(Segment seg) {
        BookOriginDestinationOptionType result = new BookOriginDestinationOptionType();
        result.getBookFlightSegmentList().add(FlyArystanAncHelper.buildBookFlightSegment(seg));
        return result;
    }

    private static BookFlightSegmentType buildBookFlightSegment(Segment seg) {
        BookFlightSegmentType result = new BookFlightSegmentType();
        result.setActionCode("HK");
        BookingClassType bookingClass = new BookingClassType();
        bookingClass.setCabin(FlyArystanAncHelper.convertServiceClassToGdsCabin(seg.getServiceClass()));
        bookingClass.setResBookDesigCode(seg.getClassOfSvcCode());
        result.setBookingClass(bookingClass);
        FareInfoType gdsFareInfo = new FareInfoType();
        gdsFareInfo.setCabinClassCode(FlyArystanHelper.convertServiceClassToGdsCode(seg.getServiceClass()));
        gdsFareInfo.setFareReferenceCode(seg.getFareBasis());
        gdsFareInfo.setFareReferenceID(FlyArystanHelper.getFareReferenceID(seg));
        gdsFareInfo.setResBookDesigCode(seg.getClassOfSvcCode());
        result.setFareInfo(gdsFareInfo);
        FlightSegmentType gdsSeg = new FlightSegmentType();
        gdsSeg.setFlightSegmentID(seg.getGdsId());
        gdsSeg.setAirline(FlyArystanAncHelper.buildGdsAiline((DictionaryReference<Airline>)seg.getAirline()));
        gdsSeg.setDepartureAirport(FlyArystanAncHelper.buildAirport((DictionaryReference<GeoLocation>)seg.getDepartureLocation()));
        gdsSeg.setArrivalAirport(FlyArystanAncHelper.buildAirport((DictionaryReference<GeoLocation>)seg.getArriveLocation()));
        gdsSeg.setDepartureDateTime(JaxWsHelper.toGregorianLocalDateTime((Date)seg.getStartDate()));
        gdsSeg.setArrivalDateTime(JaxWsHelper.toGregorianLocalDateTime((Date)seg.getEndDate()));
        gdsSeg.setFlightNumber(seg.getFlightNo());
        gdsSeg.setEquipment(FlyArystanAncHelper.buildEquipment((DictionaryReference<Aircraft>)seg.getBoard()));
        result.setFlightSegment(gdsSeg);
        return result;
    }

    public static CompanyNameType buildGdsAiline(DictionaryReference<Airline> airlineRef) {
        CompanyNameType result = new CompanyNameType();
        result.setCode(FlyArystanHelper.getNativeCode(airlineRef));
        return result;
    }

    private static AirportType buildAirport(DictionaryReference<GeoLocation> locationRef) {
        AirportType result = new AirportType();
        result.setLocationCode(FlyArystanHelper.getNativeCode(locationRef));
        return result;
    }

    private static EquipmentType buildEquipment(DictionaryReference<Aircraft> aircraftRef) {
        EquipmentType result = new EquipmentType();
        result.setAirEquipType(FlyArystanHelper.getNativeCode(aircraftRef));
        return result;
    }

    public static AirTravelerType buildGdsTraveller(Reservation reservation, Traveller traveller) {
        Passport passport = traveller.getPassport();
        Product travellerProduct = BookingHelper.findAirProductByTravellerUid((Reservation)reservation, (String)traveller.getUid());
        DictionaryReference passengerType = travellerProduct.getPassengerType();
        AirTravelerType airTraveller = new AirTravelerType();
        airTraveller.setTravelerReferenceID(travellerProduct.getTravellerGdsId());
        airTraveller.setPassengerTypeCode(FlyArystanAncHelper.convertPassengerTypeToGds((DictionaryReference<PassengerType>)passengerType));
        airTraveller.setPassportNumber(passport.getNumber());
        airTraveller.setPersonName(FlyArystanAncHelper.buildPersonName(passport));
        airTraveller.setBirthDate(JaxWsHelper.toGregorianLocalDate((Date)passport.getBirthday()));
        airTraveller.setGender(FlyArystanHelper.getGender((DictionaryReference<PassengerType>)passengerType, passport.getGender()));
        airTraveller.setRequestedSeatCount(1);
        return airTraveller;
    }

    private static PersonNameType buildPersonName(Passport passport) {
        PersonNameType pn = new PersonNameType();
        pn.setSurname(passport.getLastName());
        pn.setGivenName(passport.getFirstName());
        pn.setMiddleName(passport.getMiddleName());
        return pn;
    }

    public static Integer calcSegmentNumber(Product product, String segmentGdsId) {
        int nmb = 0;
        for (Segment segment : AirProductHelper.getSegments((Collection)product.getSegmentTariffs())) {
            if (segmentGdsId.equals(segment.getGdsId())) {
                return nmb;
            }
            ++nmb;
        }
        throw Xeption.forDeveloper((String)"can't find segment with gdsId = {0}", (Object[])new Object[]{segmentGdsId});
    }

    static {
        passengerTypeMap.put(PassengerTypeValue.ADULT, PassengerTypeCodeType.ADLT);
        passengerTypeMap.put(PassengerTypeValue.CHILD, PassengerTypeCodeType.CHLD);
        passengerTypeMap.put(PassengerTypeValue.INFANT, PassengerTypeCodeType.INFT);
        serviceClassCabinMap = new HashMap<ClassOfService, CabinType>();
        serviceClassCabinMap.put(ClassOfService.ECONOMY, CabinType.ECONOMY);
        serviceClassCabinMap.put(ClassOfService.BUSINESS, CabinType.BUSINESS);
        serviceClassCabinMap.put(ClassOfService.FIRST, CabinType.FIRST);
        freeTextAvailabilitiesMap = new HashMap<SsrFreeTextEnum, AncillaryFreeTextAvailability>();
        freeTextAvailabilitiesMap.put(SsrFreeTextEnum.NP, AncillaryFreeTextAvailability.NOT_ALLOWED);
        freeTextAvailabilitiesMap.put(SsrFreeTextEnum.OP, AncillaryFreeTextAvailability.OPTIONAL);
        freeTextAvailabilitiesMap.put(SsrFreeTextEnum.MN, AncillaryFreeTextAvailability.MANDATORY);
    }
}

