/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flyArystan;

import com.gridnine.xtrip.common.gds.flyArystan.dict.FarePackage;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.helper.GdsDictHelper;
import com.gridnine.xtrip.common.gds.model.AncillaryFee;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeDescription;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeType;
import com.gridnine.xtrip.common.gds.model.FareDetails;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.FarePricingParameters;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.FlightTax;
import com.gridnine.xtrip.common.gds.model.FlyArystanFarePricingData;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.midoffice.helper.CodeTranslator;
import com.gridnine.xtrip.common.midoffice.helper.ReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.LuggageInfo;
import com.gridnine.xtrip.common.model.booking.air.MCOReservationRequestStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.gds.ExtendedLuggageInfo;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.hititcs.crane.ws.main.AirFeeType;
import com.hititcs.crane.ws.main.AirReservationType;
import com.hititcs.crane.ws.main.AirTaxType;
import com.hititcs.crane.ws.main.AirTravelerType;
import com.hititcs.crane.ws.main.AmountType;
import com.hititcs.crane.ws.main.AvailFlightSegmentType;
import com.hititcs.crane.ws.main.AvailOriginDestinationOptionType;
import com.hititcs.crane.ws.main.AvailabilityFareComponentGroupType;
import com.hititcs.crane.ws.main.AvailabilityFareComponentType;
import com.hititcs.crane.ws.main.BaggageAllowanceTypeType;
import com.hititcs.crane.ws.main.BaseFareType;
import com.hititcs.crane.ws.main.BookFlightSegmentType;
import com.hititcs.crane.ws.main.BookingClassType;
import com.hititcs.crane.ws.main.BoundType;
import com.hititcs.crane.ws.main.CabinType;
import com.hititcs.crane.ws.main.CompanyNameType;
import com.hititcs.crane.ws.main.CouponInfoType;
import com.hititcs.crane.ws.main.DocCodesType;
import com.hititcs.crane.ws.main.FareBaggageAllowanceType;
import com.hititcs.crane.ws.main.FareInfoType;
import com.hititcs.crane.ws.main.FarePkgExplanation;
import com.hititcs.crane.ws.main.FarePkgInfoType;
import com.hititcs.crane.ws.main.FeesType;
import com.hititcs.crane.ws.main.FlightSegmentType;
import com.hititcs.crane.ws.main.PassengerFareInfoType;
import com.hititcs.crane.ws.main.PassengerTypeCodeType;
import com.hititcs.crane.ws.main.PassengerTypeType;
import com.hititcs.crane.ws.main.PricingInfoType;
import com.hititcs.crane.ws.main.SpecialServiceRequestType;
import com.hititcs.crane.ws.main.SsrType;
import com.hititcs.crane.ws.main.TaxesType;
import com.hititcs.crane.ws.main.TicketItemType;
import com.hititcs.crane.ws.main.TicketType;
import com.hititcs.crane.ws.main.UniqueIDType;
import com.hititcs.crane.ws.main.WeightType;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.datatype.XMLGregorianCalendar;

public class FlyArystanHelper {
    private static final String SEGMENT_DEPARTURE_DATE_TIME_WITH_TZ = "fly-arystan-segment_departure_date_time_with_tz";
    private static final String SEGMENT_ARRIVAL_DATE_TIME_WITH_TZ = "fly-arystan-segment_arrival_date_time_with_tz";
    private static final String FARE_INFO_REFERENCE_ID = "fly-arystan-fare_info_reference_id";
    public static final String CHECKED_BAG = "CHECKEDBAG";
    public static final String PAYMENT_CODE = "INV";
    public static final String HBAG = "HBAG";
    private static final CodeTranslator TRANSLATOR = new CodeTranslator(new String[]{CodeSystem.FLY_ARYSTAN.name(), CodeSystem.IATA.name()});
    private static final CodeTranslator FLY_ARYSTAN_TRANSLATOR = new CodeTranslator(new String[]{CodeSystem.FLY_ARYSTAN.name()});
    private static final Map<String, AncillaryFeeType> ancillaryFeesMap = new HashMap<String, AncillaryFeeType>();
    private static final Map<String, AncillaryFeeType> ancillaryFeeTypesMap;
    private static final Map<ClassOfService, String> serviceClassMap;
    private static final Map<ClassOfService, CabinType> serviceClassCabinMap;
    private static final Map<String, ClassOfService> serviceClassCodeMap;
    private static final List<PassportType> IDNO_DOC_TYPES;
    private static final String BRAND_ID_SEPARATOR = "|";
    private static final String GDS_ID_SEPARATOR = "/";

    public static <D extends BaseDictionary> String getNativeCode(DictionaryReference<D> dictRef) {
        return TRANSLATOR.getNativeCode(dictRef);
    }

    public static <D extends BaseDictionary> DictionaryReference<D> resolveNativeCode(Class<D> cls, String code) {
        return TRANSLATOR.resolveNativeCode(cls, code);
    }

    public static String convertServiceClassToGds(ClassOfService serviceClass) {
        return serviceClassMap.get(serviceClass);
    }

    public static CabinType convertServiceClassToGdsCabin(ClassOfService serviceClass) {
        return serviceClassCabinMap.get(serviceClass);
    }

    public static ClassOfService convertClassOfServiceFromGds(CabinType cabin) {
        return (ClassOfService)CollectionUtil.getKeyByValue(serviceClassCabinMap, (Object)cabin);
    }

    private static ClassOfService convertServiceClassFromGdsCode(String code) {
        return serviceClassCodeMap.get(code);
    }

    public static String convertServiceClassToGdsCode(ClassOfService serviceClass) {
        return (String)CollectionUtil.getKeyByValue(serviceClassCodeMap, (Object)serviceClass);
    }

    public static DocCodesType convertPassportTypeToGds(Passport passport) {
        PassportType passportType = passport.getType();
        if (passportType == PassportType.MILITARYID) {
            return DocCodesType.MILITARY_ID;
        }
        if (FlyArystanHelper.isIdNoDocument(passport)) {
            return DocCodesType.NATIONAL_ID;
        }
        return DocCodesType.PASSPORT;
    }

    public static boolean isIdNoDocument(Passport passport) {
        return "KZ".equals(passport.getCitizenship().getCode()) && IDNO_DOC_TYPES.contains(passport.getType());
    }

    public static com.hititcs.crane.ws.main.LocationType buildGdsLocation(DictionaryReference<GeoLocation> locationRef, boolean useCitySearch) {
        GeoLocation location;
        DictionaryReference ref = locationRef;
        if (useCitySearch && (location = (GeoLocation)DictionaryCache.get().resolveReference(locationRef)).getType() != LocationType.CITY) {
            ref = location.getParent();
        }
        com.hititcs.crane.ws.main.LocationType result = new com.hititcs.crane.ws.main.LocationType();
        result.setLocationCode(FlyArystanHelper.getNativeCode(ref));
        return result;
    }

    public static PassengerTypeCodeType convertPassengerTypeToGds(DictionaryReference<PassengerType> passengerTypeRef) {
        return PassengerTypeCodeType.valueOf((String)FLY_ARYSTAN_TRANSLATOR.getNativeCode(passengerTypeRef));
    }

    public static PassengerTypeType buildGdsPassengerType(DictionaryReference<PassengerType> passengerTypeRef) {
        PassengerTypeType result = new PassengerTypeType();
        result.setCode(FlyArystanHelper.convertPassengerTypeToGds(passengerTypeRef));
        return result;
    }

    public static DictionaryReference<PassengerType> convertPassengerTypeFromGds(PassengerTypeCodeType gdsPassengerType) {
        return FLY_ARYSTAN_TRANSLATOR.resolveNativeCode(PassengerType.class, gdsPassengerType.name());
    }

    private static DictionaryReference<PassengerType> convertPassengerTypeFromGds(PassengerTypeType gdsPassengerType) {
        return FlyArystanHelper.convertPassengerTypeFromGds(gdsPassengerType.getCode());
    }

    private static AncillaryFeeType getPkgAncillaryFeeType(FarePkgInfoType farePkgInfo, String fareGroupName) {
        FarePackage farePackage = FlyArystanHelper.findFarePackage(farePkgInfo, fareGroupName);
        return farePackage == null ? null : farePackage.getAncillaryFeeType();
    }

    private static String getPkgBrandName(FarePkgInfoType farePkgInfo, String fareGroupName) {
        FarePackage farePackage = FlyArystanHelper.findFarePackage(farePkgInfo, fareGroupName);
        return farePackage == null ? null : farePackage.getTitle();
    }

    public static FarePackage findFarePackage(FarePkgInfoType farePkgInfo, String fareGroupName) {
        Collection farePackages = DictionaryCache.get().getAll(FarePackage.class).values();
        return farePackages.stream().filter(fp -> MiscUtil.isBetween((Date)fp.getOpenDate(), (Date)fp.getCloseDate(), (Date)new Date())).filter(fp -> fp.getGroup() != null && fp.getGroup().name().equals(fareGroupName)).filter(fp -> fp.getFarePackageCodes().contains(farePkgInfo.getPkgCode())).findFirst().orElse(null);
    }

    public static MCOCategory getMcoCategory(TicketItemType ticketItem) {
        Optional<FarePkgInfoType> farePkgInfoOpt;
        String gdsTravellerId = ticketItem.getAirTraveler().getTravelerReferenceID();
        MCOCategory result = null;
        String pkgCode = null;
        FareInfoType gdsFareInfo = null;
        if (ticketItem.getCouponInfoList() != null && !ticketItem.getCouponInfoList().isEmpty() && ticketItem.getCouponInfoList().get(0) != null && ((CouponInfoType)ticketItem.getCouponInfoList().get(0)).getCouponFlightSegment() != null && (gdsFareInfo = ((CouponInfoType)ticketItem.getCouponInfoList().get(0)).getCouponFlightSegment().getFareInfo()).getFarePkgInfoList() != null && (farePkgInfoOpt = gdsFareInfo.getFarePkgInfoList().stream().filter(FarePkgInfoType::isSelected).findFirst()).isPresent()) {
            FarePkgInfoType farePkgInfo = farePkgInfoOpt.get();
            pkgCode = farePkgInfo.getPkgCode();
            String fareGroupName = gdsFareInfo.getFareGroupName();
            FarePackage farePackage = FlyArystanHelper.findFarePackage(farePkgInfo, fareGroupName);
            if (farePackage == null) {
                throw Xeption.forDeveloper((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e EMD. \u0412 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0434\u0435\u0439\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0442\u0430\u0440\u0438\u0444\u043d\u044b\u0439 \u043f\u0430\u043a\u0435\u0442 \u043f\u043e \u043a\u043e\u0434\u0443 {0} \u0438 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u0435 {1}", (Object[])new Object[]{pkgCode == null ? "?" : pkgCode, fareGroupName == null ? "?" : fareGroupName});
            }
            result = GdsDictHelper.convertToMcoCategory((AncillaryFeeType)farePackage.getAncillaryFeeType());
        }
        if (gdsFareInfo == null || gdsFareInfo.getFarePkgInfoList() == null || pkgCode == null) {
            SsrType ssr = ticketItem.getSpecialServiceRequest();
            MiscUtil.Pair<AncillaryFeeType, AncillaryFeeDescription> afPair = FlyArystanHelper.getAncillaryFeeTypeDescription(ssr.getGroupCode(), ssr.getCode());
            AncillaryFeeType afType = (AncillaryFeeType)afPair.getFirst();
            result = GdsDictHelper.convertToMcoCategory((AncillaryFeeType)afType);
        }
        if (result == null) {
            throw Xeption.forDeveloper((String)"unsupported PkgCode {0} for traveller {1}", (Object[])new Object[]{pkgCode, gdsTravellerId});
        }
        return result;
    }

    public static String getGender(DictionaryReference<PassengerType> passengerType, Gender gender) {
        if (DictHelper.isChildPassengerType(passengerType)) {
            return "C";
        }
        return gender == Gender.FEMALE ? "F" : "M";
    }

    public static MCOReservationRequestStatus getMcoReservationRequestStatus(String actionCode) {
        switch (actionCode) {
            case "HN": 
            case "NN": {
                return MCOReservationRequestStatus.PENDING;
            }
            case "HD": 
            case "HK": 
            case "KK": 
            case "KD": {
                return MCOReservationRequestStatus.CONFIRMED;
            }
            case "UN": 
            case "UC": 
            case "HX": 
            case "XX": 
            case "NO": {
                return MCOReservationRequestStatus.REJECTED;
            }
        }
        throw Xeption.forDeveloper((String)String.format("unknown actionCode %s", actionCode), (Object[])new Object[0]);
    }

    public static CompanyNameType buildGdsAirline(DictionaryReference<Airline> airlineRef) {
        CompanyNameType result = new CompanyNameType();
        result.setCode(FlyArystanHelper.getNativeCode(airlineRef));
        return result;
    }

    public static boolean isFlyArystanAirline(DictionaryReference<Airline> airlineRef) {
        String nativeCode = FlyArystanHelper.getNativeCode(airlineRef);
        return "KC".equals(nativeCode) || "FS".equals(nativeCode);
    }

    public static BigDecimal toBigDecimal(AmountType amount) {
        return Optional.ofNullable(amount).map(AmountType::getValue).map(BigDecimal::valueOf).orElse(null);
    }

    private static void setDepartureDateTz(FlightSegment seg, XMLGregorianCalendar value) {
        FlyArystanHelper.setDateTimeToCustomProperties(seg.getCustomProperties(), SEGMENT_DEPARTURE_DATE_TIME_WITH_TZ, value);
    }

    private static void setArrivalDateTz(FlightSegment seg, XMLGregorianCalendar value) {
        FlyArystanHelper.setDateTimeToCustomProperties(seg.getCustomProperties(), SEGMENT_ARRIVAL_DATE_TIME_WITH_TZ, value);
    }

    private static void setDateTimeToCustomProperties(Collection<NamedValue> customProperties, String name, XMLGregorianCalendar value) {
        if (value == null) {
            return;
        }
        NamedValueHelper.setValueForName((String)name, (String)value.toString(), customProperties);
    }

    private static void setFareReferenceID(FareInfo fi, String value) {
        NamedValueHelper.setValueForName((String)FARE_INFO_REFERENCE_ID, (String)value, (Collection)fi.getCustomProperties());
    }

    public static String getFareReferenceID(FareInfo fi) {
        return NamedValueHelper.getValueForName((String)FARE_INFO_REFERENCE_ID, (Collection)fi.getCustomProperties());
    }

    public static void setFareReferenceID(Segment seg, String value) {
        NamedValueHelper.setValueForName((String)FARE_INFO_REFERENCE_ID, (String)value, (Collection)seg.getCustomProperties());
    }

    public static String getFareReferenceID(Segment seg) {
        return NamedValueHelper.getValueForName((String)FARE_INFO_REFERENCE_ID, (Collection)seg.getCustomProperties());
    }

    public static List<AvailabilityFareComponentType> collectFareComponents(AvailOriginDestinationOptionType originDestination, String fareGroupName) {
        ArrayList<AvailabilityFareComponentType> result = new ArrayList<AvailabilityFareComponentType>();
        for (AvailabilityFareComponentGroupType fareComponentGroup : originDestination.getFareComponentGroupList()) {
            AvailabilityFareComponentType fareComponent = FlyArystanHelper.findFareComponent(fareComponentGroup, fareGroupName);
            if (fareComponent == null) {
                return null;
            }
            result.add(fareComponent);
        }
        return result;
    }

    private static AvailabilityFareComponentType findFareComponent(AvailabilityFareComponentGroupType fareComponentGroup, String fareGroupName) {
        if (CollectionUtil.isEmpty((Collection)fareComponentGroup.getFareComponentList())) {
            return null;
        }
        Set<String> availableBookingClasses = FlyArystanHelper.collectAvailableBookingClasses(fareComponentGroup);
        return fareComponentGroup.getFareComponentList().stream().filter(fc -> availableBookingClasses.containsAll(FlyArystanHelper.collectResBookDesigCodes(fc))).filter(fc -> TextUtil.isBlank((String)fareGroupName) || MiscUtil.equals((Object)fareGroupName, (Object)FlyArystanHelper.getFareGroupName(fc))).min(Comparator.comparing(FlyArystanHelper::getTotalPrice)).orElse(null);
    }

    private static Set<String> collectAvailableBookingClasses(AvailabilityFareComponentGroupType gr) {
        if (CollectionUtil.isEmpty((Collection)gr.getFareComponentList())) {
            return Collections.emptySet();
        }
        List<SeatPreferences> seats = FlyArystanHelper.buildSeats((AvailabilityFareComponentType)gr.getFareComponentList().get(0));
        int totalSeats = GDSHelper.getTotalSeats(seats);
        BoundType bound = (BoundType)gr.getBoundList().get(0);
        return bound.getAvailFlightSegmentList().stream().flatMap(afs -> afs.getBookingClassList().stream()).filter(bc -> "O".equals(bc.getResBookDesigStatusCode()) && bc.getResBookDesigQuantity() >= totalSeats).map(BookingClassType::getResBookDesigCode).collect(Collectors.toSet());
    }

    private static Collection<String> collectResBookDesigCodes(AvailabilityFareComponentType fc) {
        return fc.getPassengerFareInfoList().stream().flatMap(pfi -> pfi.getFareInfoList().stream()).map(FareInfoType::getResBookDesigCode).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static FlightSegmentTariff buildFlightSegmentTariff(AvailOriginDestinationOptionType originDestination) {
        FlightSegmentTariff fst = new FlightSegmentTariff();
        boolean isStarting = true;
        for (AvailabilityFareComponentGroupType fareComponentGroup : originDestination.getFareComponentGroupList()) {
            AvailFlightSegmentType gdsFlightSegment = (AvailFlightSegmentType)((BoundType)fareComponentGroup.getBoundList().get(0)).getAvailFlightSegmentList().get(0);
            fst.getSegments().add(FlyArystanHelper.buildSegment(gdsFlightSegment.getFlightSegment(), isStarting));
            isStarting = false;
        }
        return fst;
    }

    private static FlightSegment buildSegment(FlightSegmentType gdsSeg, boolean isStarting) {
        FlightSegment result = new FlightSegment();
        result.setGds(GdsName.FLY_ARYSTAN);
        result.setGdsId(gdsSeg.getFlightSegmentID());
        result.setAirline(FlyArystanHelper.resolveNativeCode(Airline.class, gdsSeg.getAirline().getCode()));
        result.setFlightNumber(gdsSeg.getFlightNumber());
        if (gdsSeg.getOperatingAirline() != null) {
            result.setOperatingAirline(FlyArystanHelper.resolveNativeCode(Airline.class, gdsSeg.getOperatingAirline().getCode()));
        } else {
            result.setOperatingAirline(result.getAirline());
        }
        result.setLocationBegin(FlyArystanHelper.resolveNativeCode(GeoLocation.class, gdsSeg.getDepartureAirport().getLocationCode()));
        result.setTerminalBegin(gdsSeg.getDepartureAirport().getTerminal());
        result.setLocationEnd(FlyArystanHelper.resolveNativeCode(GeoLocation.class, gdsSeg.getArrivalAirport().getLocationCode()));
        result.setTerminalEnd(gdsSeg.getArrivalAirport().getTerminal());
        result.setDateBegin(MiscUtil.toDateWithoutTimeZone((XMLGregorianCalendar)gdsSeg.getDepartureDateTime()));
        result.setDateEnd(MiscUtil.toDateWithoutTimeZone((XMLGregorianCalendar)gdsSeg.getArrivalDateTime()));
        FlyArystanHelper.setDepartureDateTz(result, gdsSeg.getDepartureDateTime());
        FlyArystanHelper.setArrivalDateTz(result, gdsSeg.getArrivalDateTime());
        result.setBoard(FlyArystanHelper.resolveNativeCode(Aircraft.class, gdsSeg.getEquipment().getAirEquipType()));
        if (gdsSeg.getJourneyDuration() != null) {
            result.setTravelDuration((int)Duration.parse(gdsSeg.getJourneyDuration()).toMinutes());
        } else {
            long minutes = Duration.ofMillis(gdsSeg.getArrivalDateTime().toGregorianCalendar().getTimeInMillis() - gdsSeg.getDepartureDateTime().toGregorianCalendar().getTimeInMillis()).toMinutes();
            result.setTravelDuration((int)minutes);
        }
        result.setStarting(isStarting);
        return result;
    }

    public static String getFareGroupName(AvailabilityFareComponentType fareComponentGroup) {
        return ((FareInfoType)((PassengerFareInfoType)fareComponentGroup.getPassengerFareInfoList().get(0)).getFareInfoList().get(0)).getFareGroupName();
    }

    private static Double getTotalPrice(AvailabilityFareComponentType fc) {
        return fc.getPricingOverview().getTotalAmount().getValue();
    }

    public static Flight buildFlight(List<AvailOriginDestinationOptionType> originDestinations, String fareGroupName, FarePackage farePackage) {
        Flight result = new Flight();
        result.setEticket(true);
        result.setLatinRegistration(true);
        AvailabilityFareComponentType firstFareComponent = null;
        for (AvailOriginDestinationOptionType originDestination : originDestinations) {
            List<AvailabilityFareComponentType> fareComponents = FlyArystanHelper.collectFareComponents(originDestination, fareGroupName);
            if (CollectionUtil.isEmpty(fareComponents)) {
                return null;
            }
            FlightSegmentTariff fst = FlyArystanHelper.buildFlightSegmentTariff(originDestination);
            result.getSegmentTariffs().add(fst);
            FlyArystanHelper.fillFareInfo(result, fst, fareComponents, farePackage);
            if (firstFareComponent != null) continue;
            firstFareComponent = fareComponents.get(0);
        }
        result.getSeats().addAll(FlyArystanHelper.buildSeats(Objects.requireNonNull(firstFareComponent)));
        result.setCarrier(((FlightSegment)((FlightSegmentTariff)result.getSegmentTariffs().get(0)).getSegments().get(0)).getAirline());
        return result;
    }

    private static void fillFareInfo(Flight flight, FlightSegmentTariff fst, List<AvailabilityFareComponentType> fareComponents, FarePackage farePackage) {
        List flightSegments = FlightHelper.getSegments((Flight)flight);
        for (AvailabilityFareComponentType fareComponent : fareComponents) {
            for (PassengerFareInfoType pfi : fareComponent.getPassengerFareInfoList()) {
                FlightTax tax;
                DictionaryReference<PassengerType> passengerType = FlyArystanHelper.convertPassengerTypeFromGds(pfi.getPassengerTypeQuantity().getPassengerType());
                if (pfi.getFareInfoList().isEmpty()) {
                    throw Xeption.forDeveloper((String)"empty fareInfoList for passengerType {0}", (Object[])new Object[]{passengerType.getCode()});
                }
                for (FareInfoType gdsFareInfo : pfi.getFareInfoList()) {
                    FlightSegment fs = (FlightSegment)fst.getSegments().get(gdsFareInfo.getFlightSegmentSequence() - 1);
                    int segIndex = flightSegments.indexOf(fs);
                    if (segIndex == -1) {
                        throw Xeption.forDeveloper((String)"invalid segment index", (Object[])new Object[0]);
                    }
                    fs.setServiceClass(FlyArystanHelper.convertServiceClassFromGdsCode(gdsFareInfo.getCabinClassCode()));
                    fs.setBookingClass(gdsFareInfo.getResBookDesigCode());
                    FareInfo fi = new FareInfo();
                    fi.setPassengerType(passengerType);
                    fi.setFareBasis(gdsFareInfo.getFareReferenceCode());
                    FlyArystanHelper.setFareReferenceID(fi, gdsFareInfo.getFareReferenceID());
                    FarePkgInfoType farePkgInfo = FlyArystanHelper.findFarePkgInfo(gdsFareInfo, farePackage);
                    String fareGroupName = gdsFareInfo.getFareGroupName();
                    if (farePkgInfo != null) {
                        String pkgBrandName = FlyArystanHelper.getPkgBrandName(farePkgInfo, fareGroupName);
                        fi.setFareDetails(FlyArystanHelper.buildFareDetails(fareGroupName, farePkgInfo, pkgBrandName));
                        fi.setRemarksSearchContext(pkgBrandName);
                        fi.setLuggageInfo(FlyArystanHelper.getPackageLuggageInfo(farePkgInfo));
                        fi.getFareDetails().setCabinLuggageInfo(FlyArystanHelper.getPackageCabinLuggageInfo(farePkgInfo));
                        AncillaryFee af = new AncillaryFee();
                        af.setPassengerType(passengerType);
                        af.setEquivalentAmount(FlyArystanHelper.toBigDecimal(farePkgInfo.getPrice()));
                        af.setType(FlyArystanHelper.getPkgAncillaryFeeType(farePkgInfo, fareGroupName));
                        af.getSegmentNumbers().add(segIndex);
                        af.setSelected(true);
                        flight.getAncillaryFees().add(af);
                    } else {
                        fi.setFareDetails(FlyArystanHelper.buildFareDetails(fareGroupName, fareGroupName));
                        fi.setLuggageInfo(FlyArystanHelper.buildLuggageInfo(gdsFareInfo.getFareBaggageAllowance()));
                        fi.setRemarksSearchContext(fareGroupName);
                    }
                    fs.getFareInfos().add(fi);
                }
                PricingInfoType pricingInfo = pfi.getPricingInfo();
                AmountType baseFareAmount = pricingInfo.getBaseFare().getAmount();
                String gdsCurrencyCode = baseFareAmount.getCurrency().getCode();
                flight.getFares().add(FlyArystanHelper.buildFlightFare(fst, passengerType, pricingInfo));
                if (TextUtil.isBlank((String)flight.getGdsCurrencyCode())) {
                    flight.setGdsCurrencyCode(gdsCurrencyCode);
                }
                if (pricingInfo.getTaxes() != null && pricingInfo.getTaxes().getTaxList() != null) {
                    for (AirTaxType gdsTax : pricingInfo.getTaxes().getTaxList()) {
                        tax = new FlightTax();
                        tax.setPassengerType(passengerType);
                        tax.setCode(gdsTax.getTaxCode());
                        tax.setEquivalentAmount(FlyArystanHelper.toBigDecimal(gdsTax.getTaxAmount()));
                        tax.setSegmentTariff(fst);
                        flight.getTaxes().add(tax);
                    }
                }
                if (pricingInfo.getFees() == null || !CollectionUtil.isNotEmpty((Collection)pricingInfo.getFees().getFeeList())) continue;
                for (AirFeeType gdsFee : pricingInfo.getFees().getFeeList()) {
                    tax = new FlightTax();
                    tax.setPassengerType(passengerType);
                    tax.setCode(gdsFee.getFeeCode());
                    tax.setEquivalentAmount(FlyArystanHelper.toBigDecimal(gdsFee.getFeeAmount()));
                    tax.setSegmentTariff(fst);
                    flight.getTaxes().add(tax);
                }
            }
        }
    }

    public static LuggageInfo getPackageLuggageInfo(FarePkgInfoType farePkgInfo) {
        String bag = FlyArystanHelper.extractPkgExplanation(farePkgInfo, CHECKED_BAG);
        if (TextUtil.nonBlank((String)bag)) {
            try {
                return AirProductHelper.buildLuggageInfo((Integer)Integer.valueOf(TextUtil.trim((String)bag)), (String)"KG");
            }
            catch (Exception ex) {
                IncidentsLog.reportException((String)"build luggage info failed", (Throwable)ex);
                return null;
            }
        }
        return AirProductHelper.buildNilLuggageInfo();
    }

    public static ExtendedLuggageInfo getPackageCabinLuggageInfo(FarePkgInfoType farePkgInfo) {
        String bag = FlyArystanHelper.extractPkgExplanation(farePkgInfo, HBAG);
        if (TextUtil.isBlank((String)bag)) {
            return null;
        }
        try {
            ExtendedLuggageInfo result = new ExtendedLuggageInfo();
            result.setWeight(Integer.valueOf(bag));
            result.setWeightUnit((DictionaryReference)DictHelper.getKgLuggageUnit().toReference());
            return result;
        }
        catch (Exception ex) {
            IncidentsLog.reportException((String)"build cabin luggage failed", (Throwable)ex);
            return null;
        }
    }

    private static String extractPkgExplanation(FarePkgInfoType farePkgInfo, String prefix) {
        if (farePkgInfo == null || farePkgInfo.getPkgExplanationType() == null) {
            return null;
        }
        List pkgExplanations = farePkgInfo.getPkgExplanationType().getPkgExplanationList();
        if (CollectionUtil.isEmpty((Collection)pkgExplanations)) {
            return null;
        }
        return pkgExplanations.stream().map(FarePkgExplanation::getPkgExplanation).filter(Objects::nonNull).filter(text -> text.startsWith(prefix)).map(text -> text.substring(prefix.length())).findFirst().orElse(null);
    }

    private static FlightFare buildFlightFare(FlightSegmentTariff fst, DictionaryReference<PassengerType> passengerType, PricingInfoType pricingInfo) {
        BigDecimal amountValue = FlyArystanHelper.calcGdsFareAmount(pricingInfo);
        FlightFare fare = new FlightFare();
        fare.setPassengerType(passengerType);
        fare.setEquivalentAmount(amountValue);
        fare.setBaseAmount(MoneyHelper.moneyOrNull((BigDecimal)amountValue, (String)pricingInfo.getBaseFare().getAmount().getCurrency().getCode()));
        fare.setSegmentTariff(fst);
        return fare;
    }

    public static FareDetails buildFareDetails(String fareGroupName, String brandName) {
        return FlyArystanHelper.buildFareDetails(fareGroupName, brandName, null, null, null);
    }

    public static FareDetails buildFareDetails(String fareGroupName, FarePkgInfoType farePkgInfo, String brandName) {
        return FlyArystanHelper.buildFareDetails(fareGroupName, brandName, farePkgInfo.getPkgCode(), farePkgInfo.getBundleId(), farePkgInfo.getBundleFareId());
    }

    public static FareDetails buildFareDetails(String fareGroupName, com.hititcs.crane.ws.reissue.FarePkgInfoType farePkgInfo, String brandName) {
        return FlyArystanHelper.buildFareDetails(fareGroupName, brandName, farePkgInfo.getPkgCode(), farePkgInfo.getBundleId(), farePkgInfo.getBundleFareId());
    }

    private static FareDetails buildFareDetails(String fareGroupName, String brandName, String pkgCode, Long bundleId, Long bundleFareId) {
        FareDetails fareDetails = new FareDetails();
        fareDetails.setPricingParameters(new FarePricingParameters());
        fareDetails.getPricingParameters().setBrandId(FlyArystanHelper.buildBrandId(fareGroupName, pkgCode));
        L10nStringHelper.setValue((L10nString)fareDetails.getBrandName(), (String)brandName, (Locale)Locale.ROOT);
        if (TextUtil.nonBlank((String)pkgCode)) {
            FlyArystanFarePricingData flyArystanData = new FlyArystanFarePricingData();
            flyArystanData.setBundleId(bundleId);
            flyArystanData.setBundleFareId(bundleFareId);
            fareDetails.getPricingParameters().setFlyArystanData(flyArystanData);
        }
        return fareDetails;
    }

    private static String buildBrandId(String fareGroupName, String pkgCode) {
        return String.join((CharSequence)BRAND_ID_SEPARATOR, fareGroupName, MiscUtil.guarded((String)pkgCode));
    }

    public static String getFareGroupName(String brandId) {
        if (TextUtil.isBlank((String)brandId)) {
            return null;
        }
        return brandId.split(Pattern.quote(BRAND_ID_SEPARATOR))[0];
    }

    public static String getPkgCode(String brandId) {
        if (TextUtil.isBlank((String)brandId)) {
            return null;
        }
        String[] parts = brandId.split(Pattern.quote(BRAND_ID_SEPARATOR));
        if (parts.length < 2) {
            return null;
        }
        return parts[1];
    }

    public static FarePkgInfoType findFarePkgInfo(FareInfoType gdsFareInfo, FarePackage farePackage) {
        if (farePackage == null || CollectionUtil.isEmpty((Collection)gdsFareInfo.getFarePkgInfoList())) {
            return null;
        }
        String fareGroupName = gdsFareInfo.getFareGroupName();
        return gdsFareInfo.getFarePkgInfoList().stream().filter(pi -> MiscUtil.equals((Object)farePackage, (Object)FlyArystanHelper.findFarePackage(pi, fareGroupName))).findFirst().orElse(null);
    }

    private static List<SeatPreferences> buildSeats(AvailabilityFareComponentType fareComponent) {
        ArrayList<SeatPreferences> result = new ArrayList<SeatPreferences>();
        for (PassengerFareInfoType pfi : fareComponent.getPassengerFareInfoList()) {
            DictionaryReference<PassengerType> passengerType = FlyArystanHelper.convertPassengerTypeFromGds(pfi.getPassengerTypeQuantity().getPassengerType());
            SeatPreferences seat = new SeatPreferences();
            seat.setPassengerType(passengerType);
            seat.setCount(pfi.getPassengerTypeQuantity().getQuantity());
            result.add(seat);
        }
        return result;
    }

    public static UniqueIDType buildBookingReferenceId(Reservation reservation) {
        UniqueIDType result = new UniqueIDType();
        result.setID(FlyArystanHelper.getID(reservation));
        FlyArystanHelper.getReferenceIDOptional(reservation).ifPresent(arg_0 -> ((UniqueIDType)result).setReferenceID(arg_0));
        return result;
    }

    public static String buildGdsId(TicketItemType ticketItem, AirReservationType airReservation) {
        String trId = ticketItem.getAirTraveler().getTravelerReferenceID();
        if (ticketItem.getType() == TicketType.E_TICKET) {
            return FlyArystanHelper.buildTicketGdsId(trId);
        }
        SsrType ssr = ticketItem.getSpecialServiceRequest();
        String couponSegId = ((CouponInfoType)ticketItem.getCouponInfoList().get(0)).getCouponFlightSegment().getReferenceID();
        return FlyArystanHelper.buildMcoGdsId(ssr.getSpecialServiceReferenceId(), ssr.getGroupCode(), ssr.getCode(), couponSegId);
    }

    public static String buildTicketGdsId(String travelerReferenceID) {
        return travelerReferenceID;
    }

    public static String buildMcoGdsId(String ssrId, String ssrGroup, String ssrCode, String couponSegId) {
        return String.join((CharSequence)GDS_ID_SEPARATOR, ssrId, ssrGroup, ssrCode, couponSegId);
    }

    public static String getMcoSsrId(String gdsId) {
        return gdsId.split(GDS_ID_SEPARATOR)[0];
    }

    public static String getMcoOriginSsrGroup(String gdsId) {
        return gdsId.split(GDS_ID_SEPARATOR)[1];
    }

    public static String getMcoSsrCode(String gdsId) {
        return gdsId.split(GDS_ID_SEPARATOR)[2];
    }

    public static String getMcoSsrGroup(String gdsId) {
        String group = gdsId.split(GDS_ID_SEPARATOR)[1];
        String code = gdsId.split(GDS_ID_SEPARATOR)[2];
        return FlyArystanHelper.calcSsrGroup(group, code);
    }

    static String calcSsrGroup(String ssrGroup, String ssrCode) {
        if ("SEAT".equals(ssrCode)) {
            return "SEAT";
        }
        if ("XBAG".equals(ssrCode)) {
            return "BAGGAGE";
        }
        if ("CATERING".equals(ssrGroup)) {
            return "CATERING";
        }
        return "OTHER";
    }

    private static int getTravellerSequence(AirReservationType airReservation, String trId) {
        int result = 1;
        for (AirTravelerType airTraveler : airReservation.getAirTravelerList()) {
            if (MiscUtil.equals((Object)airTraveler.getTravelerReferenceID(), (Object)trId)) {
                return result;
            }
            ++result;
        }
        throw Xeption.forDeveloper((String)"can't find traveller with travelerReferenceID {0}", (Object[])new Object[]{trId});
    }

    private static boolean isSameSsr(SpecialServiceRequestType ssrItem, SsrType ssr) {
        return MiscUtil.equals((Object)ssrItem.getSSR().getCode(), (Object)ssr.getCode()) && MiscUtil.equals((Object)ssrItem.getSSR().getGroupCode(), (Object)ssr.getGroupCode());
    }

    public static void updateProduct(Product product, TicketItemType ticketItem) {
        product.setFareCalculationData(ticketItem.getFareConstruction());
        product.getFares().clear();
        product.getTaxes().clear();
        product.getFares().add(FlyArystanHelper.createProductFare(ticketItem.getPricingInfo()));
        product.getTaxes().addAll(FlyArystanHelper.buildTaxes(ticketItem.getPricingInfo()));
        for (Segment seg : AirProductHelper.getSegments((Collection)product.getSegmentTariffs())) {
            CouponInfoType couponInfo = ticketItem.getCouponInfoList().stream().filter(ci -> seg.getGdsId().equals(FlyArystanHelper.getGdsSegmentId(ci))).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find segment for ref={0}", (Object[])new Object[]{seg.getGdsId()}));
            FareInfoType fareInfo = couponInfo.getCouponFlightSegment().getFareInfo();
            seg.setFareBasis(fareInfo.getFareReferenceCode());
            FlyArystanHelper.setFareReferenceID(seg, fareInfo.getFareReferenceID());
            FarePkgInfoType farePkg = fareInfo.getFarePkgInfoList() == null ? null : (FarePkgInfoType)fareInfo.getFarePkgInfoList().stream().filter(FarePkgInfoType::isSelected).findFirst().orElse(null);
            String fareGroupName = fareInfo.getFareGroupName();
            if (farePkg != null) {
                String pkgBrandName = FlyArystanHelper.getPkgBrandName(farePkg, fareGroupName);
                seg.setRemarksSearchContext(pkgBrandName);
                seg.setFareDetails(FlyArystanHelper.buildFareDetails(fareGroupName, farePkg, pkgBrandName));
            } else {
                seg.setFareDetails(FlyArystanHelper.buildFareDetails(fareGroupName, fareGroupName));
                seg.setRemarksSearchContext(fareGroupName);
            }
            if (ticketItem.getType() == TicketType.MCO) {
                seg.setLuggageInfo(FlyArystanHelper.getPackageLuggageInfo(farePkg));
                seg.getFareDetails().setCabinLuggageInfo(FlyArystanHelper.getPackageCabinLuggageInfo(farePkg));
                continue;
            }
            seg.setLuggageInfo(FlyArystanHelper.buildLuggageInfo(fareInfo.getFareBaggageAllowance()));
        }
    }

    public static String getGdsSegmentId(CouponInfoType couponInfo) {
        return FlyArystanHelper.getGdsSegmentId(couponInfo.getCouponFlightSegment());
    }

    public static String getGdsSegmentId(BookFlightSegmentType bookFlightSegment) {
        return bookFlightSegment.getFlightSegment().getFlightSegmentID();
    }

    private static ProductFare createProductFare(PricingInfoType pricingInfo) {
        ProductFare fare = new ProductFare();
        BigDecimal gdsAmount = FlyArystanHelper.calcGdsFareAmount(pricingInfo);
        fare.setEquivalentFare(gdsAmount);
        fare.setBaseFare(MoneyHelper.buildMoney((BigDecimal)fare.getEquivalentFare(), (String)pricingInfo.getEquivBaseFare().getCurrency().getCode()));
        return fare;
    }

    public static BigDecimal calcGdsFareAmount(PricingInfoType pricingInfo) {
        AmountType baseFare = (AmountType)MiscUtil.guarded((Object)pricingInfo.getEquivBaseFare(), () -> ((BaseFareType)pricingInfo.getBaseFare()).getAmount());
        BigDecimal gdsAmount = FlyArystanHelper.toBigDecimal(baseFare);
        if (pricingInfo.getSurcharges() != null) {
            gdsAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{gdsAmount, FlyArystanHelper.toBigDecimal(pricingInfo.getSurcharges().getTotalAmount())});
        }
        return gdsAmount;
    }

    public static List<Tax> buildTaxes(PricingInfoType pricingInfo) {
        FeesType fees;
        ArrayList<Tax> result = new ArrayList<Tax>();
        TaxesType taxes = pricingInfo.getTaxes();
        if (taxes != null && CollectionUtil.isNotEmpty((Collection)taxes.getTaxList())) {
            for (AirTaxType gdsTax : taxes.getTaxList()) {
                Tax tax = new Tax();
                tax.setCode(gdsTax.getTaxCode());
                tax.setEquivalentAmount(FlyArystanHelper.toBigDecimal(gdsTax.getTaxAmount()));
                tax.setAmount(MoneyHelper.buildMoney((BigDecimal)tax.getEquivalentAmount(), (String)gdsTax.getTaxAmount().getCurrency().getCode()));
                result.add(tax);
            }
        }
        if ((fees = pricingInfo.getFees()) != null && CollectionUtil.isNotEmpty((Collection)fees.getFeeList())) {
            for (AirFeeType gdsFee : fees.getFeeList()) {
                Tax tax = new Tax();
                tax.setCode(gdsFee.getFeeCode());
                tax.setEquivalentAmount(FlyArystanHelper.toBigDecimal(gdsFee.getFeeAmount()));
                tax.setAmount(MoneyHelper.buildMoney((BigDecimal)tax.getEquivalentAmount(), (String)gdsFee.getFeeAmount().getCurrency().getCode()));
                result.add(tax);
            }
        }
        return result;
    }

    public static LuggageInfo buildLuggageInfo(FareBaggageAllowanceType fareBaggageAllowance) {
        if (fareBaggageAllowance != null) {
            WeightType maxAllowedWeight;
            if (fareBaggageAllowance.getAllowanceType() == BaggageAllowanceTypeType.WEIGHT && Objects.nonNull(maxAllowedWeight = fareBaggageAllowance.getMaxAllowedWeight())) {
                return AirProductHelper.buildLuggageInfo((Integer)maxAllowedWeight.getWeight(), (String)maxAllowedWeight.getUnitOfMeasureCode());
            }
            if (fareBaggageAllowance.getAllowanceType() == BaggageAllowanceTypeType.PIECE) {
                return AirProductHelper.buildLuggageInfo((Integer)fareBaggageAllowance.getMaxAllowedPieces(), (String)"PC");
            }
        }
        return AirProductHelper.buildNilLuggageInfo();
    }

    public static void setCarrier(Product product) {
        product.setCarrier(((Segment)((SegmentTariff)product.getSegmentTariffs().get(0)).getSegments().get(0)).getAirline());
        if (product.getCarrier() != null) {
            product.setCarrierNumber(((Airline)DictionaryCache.get().resolveReference(product.getCarrier())).getAirlineNumber());
        }
    }

    public static MiscUtil.Pair<AncillaryFeeType, AncillaryFeeDescription> getAncillaryFeeTypeDescription(String ssrGroupCode, String ssrCode) {
        AncillaryFeeType ancillaryFeeType = FlyArystanHelper.convertAncillaryFeeTypeFromGds(ssrGroupCode, ssrCode);
        AncillaryFeeDescription ancillaryFeeDescription = GdsDictHelper.findAncillaryFeeDescriptionByServiceCode((AncillaryFeeType)ancillaryFeeType, (String)ssrCode, (GdsName)GdsName.FLY_ARYSTAN);
        if (ancillaryFeeType == null && ancillaryFeeDescription != null) {
            ancillaryFeeType = ancillaryFeeDescription.getType();
        }
        return MiscUtil.Pair.of((Object)ancillaryFeeType, (Object)ancillaryFeeDescription);
    }

    private static AncillaryFeeType convertAncillaryFeeTypeFromGds(String gdsGroup, String gdsCode) {
        AncillaryFeeType result = ancillaryFeesMap.get(gdsCode);
        if (result == null) {
            result = ancillaryFeeTypesMap.get(gdsGroup);
        }
        return result;
    }

    public static void updateTicketNumber(Product prod, String gdsTicketNumber) {
        if (TextUtil.isBlank((String)gdsTicketNumber)) {
            return;
        }
        prod.setCarrierNumber(gdsTicketNumber.substring(0, 3));
        prod.setSystemNumber(FlyArystanHelper.getSystemNumber(gdsTicketNumber));
    }

    public static String getSystemNumber(String gdsTicketNumber) {
        if (TextUtil.isBlank((String)gdsTicketNumber)) {
            return null;
        }
        return gdsTicketNumber.substring(3, 13);
    }

    public static Collection<String> collectFareGroupNames(List<AvailOriginDestinationOptionType> originDestinations) {
        return originDestinations.stream().flatMap(od -> od.getFareComponentGroupList().stream()).flatMap(gr -> gr.getFareComponentList().stream()).map(FlyArystanHelper::getFareGroupName).collect(Collectors.toSet());
    }

    public static List<FarePackage> collectFarePackages(List<AvailOriginDestinationOptionType> originDestinations, String fareGroupName) {
        ArrayList<FarePackage> result = new ArrayList<FarePackage>();
        List fareComponents = originDestinations.stream().flatMap(od -> od.getFareComponentGroupList().stream()).flatMap(fg -> fg.getFareComponentList().stream()).filter(fc -> MiscUtil.equals((Object)fareGroupName, (Object)FlyArystanHelper.getFareGroupName(fc))).collect(Collectors.toList());
        for (AvailabilityFareComponentType fareComponent : fareComponents) {
            for (PassengerFareInfoType passengerFareInfo : fareComponent.getPassengerFareInfoList()) {
                for (FareInfoType fareInfoType : passengerFareInfo.getFareInfoList()) {
                    if (CollectionUtil.isEmpty((Collection)fareInfoType.getFarePkgInfoList())) {
                        return Collections.emptyList();
                    }
                    List farePackages = fareInfoType.getFarePkgInfoList().stream().map(pkg -> FlyArystanHelper.findFarePackage(pkg, fareGroupName)).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    if (result.isEmpty()) {
                        result.addAll(farePackages);
                        continue;
                    }
                    result.retainAll(farePackages);
                    if (!result.isEmpty()) continue;
                    return Collections.emptyList();
                }
            }
        }
        return result;
    }

    public static String getID(Reservation reservation) {
        return ReservationGdsNameInfoHelper.getOnlineRecordLocator((Reservation)reservation, (RecordLocatorType)RecordLocatorType.FLY_ARYSTAN_ID);
    }

    public static Optional<String> getReferenceIDOptional(Reservation reservation) {
        return ReservationGdsNameInfoHelper.getOnlineRecordLocatorOptional((Reservation)reservation, (RecordLocatorType)RecordLocatorType.FLY_ARYSTAN_REFERENCE_ID);
    }

    static {
        ancillaryFeesMap.put("UMNR", AncillaryFeeType.UNACCOMPANIED_PASSENGERS);
        ancillaryFeesMap.put("PETC", AncillaryFeeType.PETS);
        ancillaryFeesMap.put("AVIH", AncillaryFeeType.PETS);
        ancillaryFeesMap.put("SVC", AncillaryFeeType.SMS_NOTIFICATIONS);
        ancillaryFeeTypesMap = new HashMap<String, AncillaryFeeType>();
        ancillaryFeeTypesMap.put("BAG", AncillaryFeeType.BAGGAGE);
        ancillaryFeeTypesMap.put("OBAG", AncillaryFeeType.BAGGAGE);
        ancillaryFeeTypesMap.put("SPEQ", AncillaryFeeType.BAGGAGE);
        ancillaryFeeTypesMap.put("SEAT", AncillaryFeeType.PREFERRED_SEATING);
        ancillaryFeeTypesMap.put("CATERING", AncillaryFeeType.MEALS);
        serviceClassMap = new HashMap<ClassOfService, String>();
        serviceClassMap.put(ClassOfService.ECONOMY, "ECONOMY");
        serviceClassMap.put(ClassOfService.BUSINESS, "BUSINESS");
        serviceClassMap.put(ClassOfService.FIRST, "FIRST");
        serviceClassCabinMap = new HashMap<ClassOfService, CabinType>();
        serviceClassCabinMap.put(ClassOfService.ECONOMY, CabinType.ECONOMY);
        serviceClassCabinMap.put(ClassOfService.BUSINESS, CabinType.BUSINESS);
        serviceClassCabinMap.put(ClassOfService.FIRST, CabinType.FIRST);
        serviceClassCodeMap = new HashMap<String, ClassOfService>();
        serviceClassCodeMap.put("Y", ClassOfService.ECONOMY);
        serviceClassCodeMap.put("C", ClassOfService.BUSINESS);
        serviceClassCodeMap.put("W", ClassOfService.PREMIUM);
        serviceClassCodeMap.put("F", ClassOfService.FIRST);
        IDNO_DOC_TYPES = Arrays.asList(PassportType.INTERNAL, PassportType.PASSPORT, PassportType.IDENTITYCARD, PassportType.RESIDENCEPERMIT);
    }
}

