/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flyArystan;

import com.gridnine.xtrip.common.gds.flyArystan.dict.FarePackage;
import com.gridnine.xtrip.common.gds.model.FareDetails;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.FarePricingParameters;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlyArystanFarePricingData;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.midoffice.helper.CodeTranslator;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.LuggageInfo;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.gds.ExtendedLuggageInfo;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanHelper;
import com.gridnine.xtrip.server.jaxws.JaxWsHelper;
import com.hititcs.crane.ws.reissue.AirFeeType;
import com.hititcs.crane.ws.reissue.AirTaxType;
import com.hititcs.crane.ws.reissue.AirportType;
import com.hititcs.crane.ws.reissue.AmountType;
import com.hititcs.crane.ws.reissue.BaggageAllowanceTypeType;
import com.hititcs.crane.ws.reissue.BaseFareType;
import com.hititcs.crane.ws.reissue.BookFlightSegmentType;
import com.hititcs.crane.ws.reissue.BookingClassType;
import com.hititcs.crane.ws.reissue.BookingReferenceIDType;
import com.hititcs.crane.ws.reissue.CabinType;
import com.hititcs.crane.ws.reissue.CompanyNameType;
import com.hititcs.crane.ws.reissue.CouponInfoType;
import com.hititcs.crane.ws.reissue.EquipmentType;
import com.hititcs.crane.ws.reissue.FareBaggageAllowanceType;
import com.hititcs.crane.ws.reissue.FareInfoType;
import com.hititcs.crane.ws.reissue.FarePkgExplanation;
import com.hititcs.crane.ws.reissue.FarePkgInfoType;
import com.hititcs.crane.ws.reissue.FeesType;
import com.hititcs.crane.ws.reissue.FlightSegmentType;
import com.hititcs.crane.ws.reissue.PassengerTypeCodeType;
import com.hititcs.crane.ws.reissue.PricingInfoType;
import com.hititcs.crane.ws.reissue.SsrType;
import com.hititcs.crane.ws.reissue.TaxesType;
import com.hititcs.crane.ws.reissue.TicketItemType;
import com.hititcs.crane.ws.reissue.TicketType;
import com.hititcs.crane.ws.reissue.UniqueIDType;
import com.hititcs.crane.ws.reissue.WeightType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class FlyArystanReissueHelper {
    static final Map<ClassOfService, CabinType> serviceClassCabinMap = new HashMap<ClassOfService, CabinType>();
    private static final CodeTranslator FLY_ARYSTAN_TRANSLATOR = new CodeTranslator(new String[]{CodeSystem.FLY_ARYSTAN.name()});

    public FlyArystanReissueHelper() {
        serviceClassCabinMap.put(ClassOfService.ECONOMY, CabinType.ECONOMY);
        serviceClassCabinMap.put(ClassOfService.BUSINESS, CabinType.BUSINESS);
        serviceClassCabinMap.put(ClassOfService.FIRST, CabinType.FIRST);
    }

    public static UniqueIDType buildBookingReferenceId(Reservation reservation) {
        BookingReferenceIDType result = new BookingReferenceIDType();
        result.setID(FlyArystanHelper.getID(reservation));
        FlyArystanHelper.getReferenceIDOptional(reservation).ifPresent(arg_0 -> ((UniqueIDType)result).setReferenceID(arg_0));
        return result;
    }

    private static AirportType buildAirport(DictionaryReference<GeoLocation> locationRef) {
        AirportType result = new AirportType();
        result.setLocationCode(FlyArystanHelper.getNativeCode(locationRef));
        return result;
    }

    private static EquipmentType buildEquipment(DictionaryReference<Aircraft> aircraftRef) {
        EquipmentType result = new EquipmentType();
        result.setAirEquipType(FlyArystanHelper.getNativeCode(aircraftRef));
        return result;
    }

    private static CompanyNameType buildGdsAirline(DictionaryReference<Airline> airlineRef) {
        CompanyNameType result = new CompanyNameType();
        result.setCode(FlyArystanHelper.getNativeCode(airlineRef));
        return result;
    }

    private static CabinType convertServiceClassToGdsCabin(ClassOfService serviceClass) {
        return serviceClassCabinMap.get(serviceClass);
    }

    public static BookFlightSegmentType buildBookFlightOldSegment(Segment segment, int segInd) {
        BookFlightSegmentType result = new BookFlightSegmentType();
        result.setActionCode("NN");
        BookingClassType bookingClass = new BookingClassType();
        bookingClass.setCabin(FlyArystanReissueHelper.convertServiceClassToGdsCabin(segment.getServiceClass()));
        bookingClass.setResBookDesigCode(segment.getClassOfSvcCode());
        result.setBookingClass(bookingClass);
        FareInfoType gdsFareInfo = new FareInfoType();
        gdsFareInfo.setCabinClassCode(FlyArystanHelper.convertServiceClassToGdsCode(segment.getServiceClass()));
        gdsFareInfo.setFareReferenceCode(segment.getFareBasis());
        gdsFareInfo.setFareReferenceID(FlyArystanHelper.getFareReferenceID(segment));
        gdsFareInfo.setFlightSegmentSequence(segInd + 1);
        gdsFareInfo.setResBookDesigCode(segment.getClassOfSvcCode());
        FareDetails fareDetails = segment.getFareDetails();
        if (fareDetails != null && fareDetails.getPricingParameters() != null) {
            FarePricingParameters pricingParameters = fareDetails.getPricingParameters();
            String brandId = pricingParameters.getBrandId();
            String fareGroupName = FlyArystanHelper.getFareGroupName(brandId);
            String pkgCode = FlyArystanHelper.getPkgCode(brandId);
            gdsFareInfo.setFareGroupName(fareGroupName);
            if (TextUtil.nonBlank((String)pkgCode)) {
                FarePkgInfoType pkgInfo = new FarePkgInfoType();
                pkgInfo.setPkgCode(pkgCode);
                FlyArystanFarePricingData flyArystanData = pricingParameters.getFlyArystanData();
                if (flyArystanData != null) {
                    if (flyArystanData.getBundleId() != null) {
                        pkgInfo.setBundleId(flyArystanData.getBundleId().longValue());
                    }
                    if (flyArystanData.getBundleFareId() != null) {
                        pkgInfo.setBundleFareId(flyArystanData.getBundleFareId().longValue());
                    }
                }
                pkgInfo.setSelected(true);
                gdsFareInfo.getFarePkgInfoList().add(pkgInfo);
            }
        }
        result.setFareInfo(gdsFareInfo);
        FlightSegmentType gdsSeg = new FlightSegmentType();
        gdsSeg.setFlightSegmentID(segment.getGdsId());
        gdsSeg.setAirline(FlyArystanReissueHelper.buildGdsAirline((DictionaryReference<Airline>)segment.getAirline()));
        gdsSeg.setDepartureAirport(FlyArystanReissueHelper.buildAirport((DictionaryReference<GeoLocation>)segment.getDepartureLocation()));
        gdsSeg.setArrivalAirport(FlyArystanReissueHelper.buildAirport((DictionaryReference<GeoLocation>)segment.getArriveLocation()));
        gdsSeg.setDepartureDateTime(JaxWsHelper.toGregorianLocalDateTime((Date)segment.getStartDate()));
        gdsSeg.setArrivalDateTime(JaxWsHelper.toGregorianLocalDateTime((Date)segment.getEndDate()));
        gdsSeg.setFlightNumber(segment.getFlightNo());
        gdsSeg.setEquipment(FlyArystanReissueHelper.buildEquipment((DictionaryReference<Aircraft>)segment.getBoard()));
        result.setFlightSegment(gdsSeg);
        return result;
    }

    public static BookFlightSegmentType buildBookFlightNewSegment(FlightSegment seg, int segInd) {
        FareInfo adultFareInfo = seg.getFareInfos().stream().filter(fi -> DictHelper.isAdultPassengerType((DictionaryReference)fi.getPassengerType())).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find adult fareInfo for segment {0}", (Object[])new Object[]{seg.getGdsId()}));
        BookFlightSegmentType result = new BookFlightSegmentType();
        BookingClassType bookingClass = new BookingClassType();
        bookingClass.setCabin(FlyArystanReissueHelper.convertServiceClassToGdsCabin(seg.getServiceClass()));
        bookingClass.setResBookDesigCode(seg.getBookingClass());
        result.setBookingClass(bookingClass);
        FareInfoType gdsFareInfo = new FareInfoType();
        gdsFareInfo.setCabinClassCode(FlyArystanHelper.convertServiceClassToGdsCode(seg.getServiceClass()));
        gdsFareInfo.setFareReferenceCode(adultFareInfo.getFareBasis());
        gdsFareInfo.setFareReferenceID(FlyArystanHelper.getFareReferenceID(adultFareInfo));
        gdsFareInfo.setFlightSegmentSequence(segInd + 1);
        gdsFareInfo.setResBookDesigCode(seg.getBookingClass());
        FareDetails fareDetails = adultFareInfo.getFareDetails();
        if (fareDetails != null && fareDetails.getPricingParameters() != null) {
            FarePricingParameters pricingParameters = fareDetails.getPricingParameters();
            String brandId = pricingParameters.getBrandId();
            String fareGroupName = FlyArystanHelper.getFareGroupName(brandId);
            String pkgCode = FlyArystanHelper.getPkgCode(brandId);
            gdsFareInfo.setFareGroupName(fareGroupName);
            if (TextUtil.nonBlank((String)pkgCode)) {
                FarePkgInfoType pkgInfo = new FarePkgInfoType();
                pkgInfo.setPkgCode(pkgCode);
                FlyArystanFarePricingData flyArystanData = pricingParameters.getFlyArystanData();
                if (flyArystanData != null) {
                    if (flyArystanData.getBundleId() != null) {
                        pkgInfo.setBundleId(flyArystanData.getBundleId().longValue());
                    }
                    if (flyArystanData.getBundleFareId() != null) {
                        pkgInfo.setBundleFareId(flyArystanData.getBundleFareId().longValue());
                    }
                }
                pkgInfo.setSelected(true);
                gdsFareInfo.getFarePkgInfoList().add(pkgInfo);
            }
        }
        result.setFareInfo(gdsFareInfo);
        FlightSegmentType gdsSeg = new FlightSegmentType();
        gdsSeg.setFlightSegmentID(seg.getGdsId());
        gdsSeg.setAirline(FlyArystanReissueHelper.buildGdsAirline((DictionaryReference<Airline>)seg.getAirline()));
        gdsSeg.setDepartureAirport(FlyArystanReissueHelper.buildAirport((DictionaryReference<GeoLocation>)seg.getLocationBegin()));
        gdsSeg.setArrivalAirport(FlyArystanReissueHelper.buildAirport((DictionaryReference<GeoLocation>)seg.getLocationEnd()));
        gdsSeg.setDepartureDateTime(JaxWsHelper.toGregorianLocalDateTime((Date)seg.getDateBegin()));
        gdsSeg.setArrivalDateTime(JaxWsHelper.toGregorianLocalDateTime((Date)seg.getDateEnd()));
        gdsSeg.setFlightNumber(seg.getFlightNumber());
        gdsSeg.setEquipment(FlyArystanReissueHelper.buildEquipment((DictionaryReference<Aircraft>)seg.getBoard()));
        result.setFlightSegment(gdsSeg);
        return result;
    }

    public static String buildGdsId(TicketItemType ticketItem) {
        String trId = ticketItem.getAirTraveler().getTravelerReferenceID();
        if (ticketItem.getType() == TicketType.E_TICKET) {
            return FlyArystanHelper.buildTicketGdsId(trId);
        }
        SsrType ssr = ticketItem.getSpecialServiceRequest();
        String couponSegId = ((CouponInfoType)ticketItem.getCouponInfoList().get(0)).getCouponFlightSegment().getReferenceID();
        return FlyArystanHelper.buildMcoGdsId(ssr.getSpecialServiceReferenceId(), ssr.getGroupCode(), ssr.getCode(), couponSegId);
    }

    public static String getGdsSegmentId(CouponInfoType couponInfo) {
        return FlyArystanReissueHelper.getGdsSegmentId(couponInfo.getCouponFlightSegment());
    }

    public static String getGdsSegmentId(BookFlightSegmentType bookFlightSegment) {
        return bookFlightSegment.getFlightSegment().getFlightSegmentID();
    }

    public static DictionaryReference<PassengerType> convertPassengerTypeFromGds(PassengerTypeCodeType gdsPassengerType) {
        return FLY_ARYSTAN_TRANSLATOR.resolveNativeCode(PassengerType.class, gdsPassengerType.name());
    }

    public static void updateProduct(Product product, TicketItemType ticketItem) {
        product.setFareCalculationData(ticketItem.getFareConstruction());
        product.getFares().clear();
        product.getTaxes().clear();
        product.getFares().add(FlyArystanReissueHelper.createProductFare(ticketItem.getPricingInfo()));
        product.getTaxes().addAll(FlyArystanReissueHelper.buildTaxes(ticketItem.getPricingInfo()));
        for (Segment seg : AirProductHelper.getSegments((Collection)product.getSegmentTariffs())) {
            CouponInfoType couponInfo = ticketItem.getCouponInfoList().stream().filter(ci -> seg.getGdsId().equals(FlyArystanReissueHelper.getGdsSegmentId(ci))).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find segment for ref={0}", (Object[])new Object[]{seg.getGdsId()}));
            FareInfoType fareInfo = couponInfo.getCouponFlightSegment().getFareInfo();
            seg.setFareBasis(fareInfo.getFareReferenceCode());
            FlyArystanHelper.setFareReferenceID(seg, fareInfo.getFareReferenceID());
            FarePkgInfoType farePkg = fareInfo.getFarePkgInfoList() == null ? null : (FarePkgInfoType)fareInfo.getFarePkgInfoList().stream().filter(FarePkgInfoType::isSelected).findFirst().orElse(null);
            String fareGroupName = fareInfo.getFareGroupName();
            if (farePkg != null) {
                String pkgBrandName = FlyArystanReissueHelper.getPkgBrandName(farePkg, fareGroupName);
                seg.setRemarksSearchContext(pkgBrandName);
                seg.setFareDetails(FlyArystanHelper.buildFareDetails(fareGroupName, farePkg, pkgBrandName));
            } else {
                seg.setFareDetails(FlyArystanHelper.buildFareDetails(fareGroupName, fareGroupName));
                seg.setRemarksSearchContext(fareGroupName);
            }
            if (ticketItem.getType() == TicketType.MCO) {
                seg.setLuggageInfo(FlyArystanReissueHelper.getPackageLuggageInfo(farePkg));
                seg.getFareDetails().setCabinLuggageInfo(FlyArystanReissueHelper.getPackageCabinLuggageInfo(farePkg));
                continue;
            }
            seg.setLuggageInfo(FlyArystanReissueHelper.buildLuggageInfo(fareInfo.getFareBaggageAllowance()));
        }
    }

    private static ProductFare createProductFare(PricingInfoType pricingInfo) {
        ProductFare fare = new ProductFare();
        BigDecimal gdsAmount = FlyArystanReissueHelper.calcGdsFareAmount(pricingInfo);
        fare.setEquivalentFare(gdsAmount);
        fare.setBaseFare(MoneyHelper.buildMoney((BigDecimal)fare.getEquivalentFare(), (String)pricingInfo.getEquivBaseFare().getCurrency().getCode()));
        return fare;
    }

    public static BigDecimal calcGdsFareAmount(PricingInfoType pricingInfo) {
        AmountType baseFare = (AmountType)MiscUtil.guarded((Object)pricingInfo.getEquivBaseFare(), () -> ((BaseFareType)pricingInfo.getBaseFare()).getAmount());
        BigDecimal gdsAmount = FlyArystanReissueHelper.toBigDecimal(baseFare);
        if (pricingInfo.getSurcharges() != null) {
            gdsAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{gdsAmount, FlyArystanReissueHelper.toBigDecimal(pricingInfo.getSurcharges().getTotalAmount())});
        }
        return gdsAmount;
    }

    public static BigDecimal toBigDecimal(AmountType amount) {
        return Optional.ofNullable(amount).map(AmountType::getValue).map(BigDecimal::valueOf).orElse(null);
    }

    public static List<Tax> buildTaxes(PricingInfoType pricingInfo) {
        FeesType fees;
        ArrayList<Tax> result = new ArrayList<Tax>();
        TaxesType taxes = pricingInfo.getTaxes();
        if (taxes != null && CollectionUtil.isNotEmpty((Collection)taxes.getTaxList())) {
            for (AirTaxType gdsTax : taxes.getTaxList()) {
                Tax tax = new Tax();
                tax.setCode(gdsTax.getTaxCode());
                tax.setEquivalentAmount(FlyArystanReissueHelper.toBigDecimal(gdsTax.getTaxAmount()));
                tax.setAmount(MoneyHelper.buildMoney((BigDecimal)tax.getEquivalentAmount(), (String)gdsTax.getTaxAmount().getCurrency().getCode()));
                result.add(tax);
            }
        }
        if ((fees = pricingInfo.getFees()) != null && CollectionUtil.isNotEmpty((Collection)fees.getFeeList())) {
            for (AirFeeType gdsFee : fees.getFeeList()) {
                Tax tax = new Tax();
                tax.setCode(gdsFee.getFeeCode());
                tax.setEquivalentAmount(FlyArystanReissueHelper.toBigDecimal(gdsFee.getFeeAmount()));
                tax.setAmount(MoneyHelper.buildMoney((BigDecimal)tax.getEquivalentAmount(), (String)gdsFee.getFeeAmount().getCurrency().getCode()));
                result.add(tax);
            }
        }
        return result;
    }

    private static String getPkgBrandName(FarePkgInfoType farePkgInfo, String fareGroupName) {
        FarePackage farePackage = FlyArystanReissueHelper.findFarePackage(farePkgInfo, fareGroupName);
        return farePackage == null ? null : farePackage.getTitle();
    }

    public static FarePackage findFarePackage(FarePkgInfoType farePkgInfo, String fareGroupName) {
        Collection farePackages = DictionaryCache.get().getAll(FarePackage.class).values();
        return farePackages.stream().filter(fp -> MiscUtil.isBetween((Date)fp.getOpenDate(), (Date)fp.getCloseDate(), (Date)new Date())).filter(fp -> fp.getGroup() != null && fp.getGroup().name().equals(fareGroupName)).filter(fp -> fp.getFarePackageCodes().contains(farePkgInfo.getPkgCode())).findFirst().orElse(null);
    }

    private static LuggageInfo getPackageLuggageInfo(FarePkgInfoType farePkgInfo) {
        String bag = FlyArystanReissueHelper.extractPkgExplanation(farePkgInfo, "CHECKEDBAG");
        if (TextUtil.isBlank((String)bag)) {
            return null;
        }
        try {
            return AirProductHelper.buildLuggageInfo((Integer)Integer.valueOf(bag), (String)"KG");
        }
        catch (Exception ex) {
            IncidentsLog.reportException((String)"build luggage info failed", (Throwable)ex);
            return null;
        }
    }

    private static String extractPkgExplanation(FarePkgInfoType farePkgInfo, String prefix) {
        if (farePkgInfo == null || farePkgInfo.getPkgExplanationType() == null) {
            return null;
        }
        List pkgExplanations = farePkgInfo.getPkgExplanationType().getPkgExplanationList();
        if (CollectionUtil.isEmpty((Collection)pkgExplanations)) {
            return null;
        }
        return pkgExplanations.stream().map(FarePkgExplanation::getPkgExplanation).filter(Objects::nonNull).filter(text -> text.startsWith(prefix)).map(text -> text.substring(prefix.length())).findFirst().orElse(null);
    }

    private static ExtendedLuggageInfo getPackageCabinLuggageInfo(FarePkgInfoType farePkgInfo) {
        String bag = FlyArystanReissueHelper.extractPkgExplanation(farePkgInfo, "HBAG");
        if (TextUtil.isBlank((String)bag)) {
            return null;
        }
        try {
            ExtendedLuggageInfo result = new ExtendedLuggageInfo();
            result.setWeight(Integer.valueOf(bag));
            result.setWeightUnit((DictionaryReference)DictHelper.getKgLuggageUnit().toReference());
            return result;
        }
        catch (Exception ex) {
            IncidentsLog.reportException((String)"build cabin luggage failed", (Throwable)ex);
            return null;
        }
    }

    public static LuggageInfo buildLuggageInfo(FareBaggageAllowanceType fareBaggageAllowance) {
        WeightType maxAllowedWeight;
        if (fareBaggageAllowance == null) {
            return null;
        }
        if (fareBaggageAllowance.getAllowanceType() == BaggageAllowanceTypeType.WEIGHT && Objects.nonNull(maxAllowedWeight = fareBaggageAllowance.getMaxAllowedWeight())) {
            return AirProductHelper.buildLuggageInfo((Integer)maxAllowedWeight.getWeight(), (String)maxAllowedWeight.getUnitOfMeasureCode());
        }
        if (fareBaggageAllowance.getAllowanceType() == BaggageAllowanceTypeType.PIECE) {
            return AirProductHelper.buildLuggageInfo((Integer)fareBaggageAllowance.getMaxAllowedPieces(), (String)"PC");
        }
        return null;
    }
}

