/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flyArystan;

import com.gridnine.xtrip.common.gds.flyArystan.dict.FareGroup;
import com.gridnine.xtrip.common.gds.flyArystan.dict.FarePackage;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeDescription;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeDescriptionItem;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeType;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeValue;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.gds.test.GDSTestBase;
import com.gridnine.xtrip.server.model.test.XModelAssert;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import org.junit.Assert;

public class FlyArystanTestBase
extends GDSTestBase {
    public <T> T readResponseFromFile(Class<T> responseClass, String fileName) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((String)responseClass.getPackage().getName());
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        InputStreamReader rdr = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(fileName));
        return (T)((JAXBElement)unmarshaller.unmarshal((Reader)rdr)).getValue();
    }

    protected void writeResult(List<? extends XSerializable> objects, String fileName) throws Exception {
        String path = ((Object)((Object)this)).getClass().getResource("").getPath().replace("/classes/", "/source-test/");
        path = URLDecoder.decode(path, "utf-8");
        File file = new File(path + fileName);
        try (FileOutputStream fos = new FileOutputStream(file);){
            XUtil.serialize(objects, (OutputStream)fos);
        }
    }

    protected void writeResult(XSerializable object, String fileName) throws Exception {
        String path = ((Object)((Object)this)).getClass().getResource("").getPath().replace("/classes/", "/source-test/");
        path = URLDecoder.decode(path, "utf-8");
        File file = new File(path + fileName);
        try (FileOutputStream fos = new FileOutputStream(file);){
            XUtil.serialize((XSerializable)object, (OutputStream)fos);
        }
    }

    protected void initDicts() {
        Arrays.asList("KC").forEach(code -> {
            Airline dict = new Airline();
            dict.setCode(code);
            DictionaryCache.get().put((BaseDictionary)dict);
        });
        Arrays.asList("ALA", "NQZ", "PLX", "CIT").forEach(code -> {
            GeoLocation city = new GeoLocation();
            city.setCode("city ".concat((String)code));
            city.getCodeVariants().put(CodeSystem.IATA.name(), code);
            city.setType(LocationType.CITY);
            DictionaryCache.get().put((BaseDictionary)city);
            GeoLocation airport = new GeoLocation();
            airport.setCode(code);
            airport.getCodeVariants().put(CodeSystem.IATA.name(), code);
            airport.setType(LocationType.AIRPORT);
            airport.setParent((DictionaryReference)city.toReference());
            DictionaryCache.get().put((BaseDictionary)airport);
        });
        this.saveFarePackage("PROMO LIGHT", FareGroup.PROMO, AncillaryFeeType.STANDARD_PLUS, "PLS", "PLM", "PLL");
        this.saveFarePackage("PROMO COMFORT", FareGroup.PROMO, AncillaryFeeType.COMFORT, "PCS", "PCM", "PCL");
        this.saveFarePackage("PROMO COMFORT PLUS", FareGroup.PROMO, AncillaryFeeType.COMFORT_PLUS, "PCPS", "PCPM", "PCPL");
        this.saveFarePackage("REGULAR LIGHT", FareGroup.REGULAR, AncillaryFeeType.STANDARD_PLUS, "RLS", "RLM", "RLL", "PLS", "PLM", "PLL");
        this.saveFarePackage("REGULAR COMFORT", FareGroup.REGULAR, AncillaryFeeType.COMFORT, "RLS", "RCM", "RCL", "PLS", "PCM", "PCL");
        this.saveFarePackage("REGULAR COMFORT PLUS", FareGroup.REGULAR, AncillaryFeeType.COMFORT_PLUS, "RCPS", "RCPM", "RCPL");
        AncillaryFeeType ancillaryType = AncillaryFeeType.BAGGAGE;
        Arrays.asList("WEAP", "CBAG").forEach(code -> {
            AncillaryFeeDescription dict = new AncillaryFeeDescription();
            dict.setCode(code);
            dict.setType(ancillaryType);
            AncillaryFeeDescriptionItem afd = new AncillaryFeeDescriptionItem();
            afd.setGds(GdsName.FLY_ARYSTAN);
            afd.setServiceCode(code);
            dict.getDescriptionItems().add(afd);
            DictionaryCache.get().put((BaseDictionary)dict);
        });
        ancillaryType = AncillaryFeeType.PETS;
        Arrays.asList("PETC", "AVIH").forEach(code -> {
            AncillaryFeeDescription dict = new AncillaryFeeDescription();
            dict.setCode(code);
            AncillaryFeeDescriptionItem afd = new AncillaryFeeDescriptionItem();
            afd.setGds(GdsName.FLY_ARYSTAN);
            afd.setServiceCode(code);
            dict.getDescriptionItems().add(afd);
            dict.setType(ancillaryType);
            DictionaryCache.get().put((BaseDictionary)dict);
        });
        PassengerType adt = (PassengerType)DictionaryCache.get().findByCode(PassengerType.class, PassengerTypeValue.ADULT.name());
        adt.getCodeVariants().put(CodeSystem.FLY_ARYSTAN.name(), "ADLT");
        DictionaryCache.get().put((BaseDictionary)adt);
        PassengerType child = (PassengerType)DictionaryCache.get().findByCode(PassengerType.class, PassengerTypeValue.CHILD.name());
        child.getCodeVariants().put(CodeSystem.FLY_ARYSTAN.name(), "CHLD");
        DictionaryCache.get().put((BaseDictionary)child);
        PassengerType inf = (PassengerType)DictionaryCache.get().findByCode(PassengerType.class, PassengerTypeValue.INFANT.name());
        inf.getCodeVariants().put(CodeSystem.FLY_ARYSTAN.name(), "INFT");
        inf.setWithoutSeat(true);
        DictionaryCache.get().put((BaseDictionary)inf);
    }

    private void saveFarePackage(String s, FareGroup promo, AncillaryFeeType standardPlus, String ... codes) {
        FarePackage dict = new FarePackage();
        dict.setCode(s);
        dict.setTitle(s);
        dict.setGroup(promo);
        dict.setAncillaryFeeType(standardPlus);
        dict.getFarePackageCodes().addAll(Arrays.asList(codes));
        DictionaryCache.get().put((BaseDictionary)dict);
    }

    protected void assertFlights(List<Flight> expectedList, List<Flight> actualList) {
        Assert.assertEquals((long)expectedList.size(), (long)actualList.size());
        for (int i = 0; i < actualList.size(); ++i) {
            Flight expected = expectedList.get(i);
            Flight actual = actualList.get(i);
            Assert.assertNotNull((String)String.format("FLIGHTS[%d].initDate", i), (Object)actual.getInitDate());
            expected.setInitDate(actual.getInitDate());
            XModelAssert.assertEntityEquals((String)String.format("flight[%d]", i), (BaseEntity)expected, (BaseEntity)actual);
        }
    }

    protected void assertReservation(Reservation expected, Reservation actual) {
        this.clearFields(expected);
        this.clearFields(actual);
        XModelAssert.assertEntityEquals((BaseEntity)expected, (BaseEntity)actual);
    }

    private void clearFields(Reservation res) {
        res.setRefreshFromGdsDate(null);
        res.setResDate(null);
        res.setPricingDate(null);
        res.getProducts().stream().map(Product.class::cast).forEach(prod -> prod.setIssueDate(null));
    }

    protected <T extends BaseEntity> void assertList(List<T> expectedList, List<T> actualList, Consumer<T> doBeforeAssert) {
        Assert.assertEquals((long)expectedList.size(), (long)actualList.size());
        for (int i = 0; i < actualList.size(); ++i) {
            BaseEntity expected = (BaseEntity)expectedList.get(i);
            BaseEntity actual = (BaseEntity)actualList.get(i);
            if (doBeforeAssert != null) {
                doBeforeAssert.accept(expected);
                doBeforeAssert.accept(actual);
            }
            XModelAssert.assertEntityEquals((String)String.format("item[%d]", i), (BaseEntity)expected, (BaseEntity)actual);
        }
    }
}

