/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flyArystan;

import com.gridnine.xtrip.common.gds.exceptions.SeatsNotConfirmedException;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.hititcs.crane.ws.main.CraneFault;
import java.util.HashMap;
import java.util.Map;
import org.jibx.ws.soap.SoapFaultException;

public class FlyArystanWsFaultExceptionAdvice
extends BaseAdvice {
    private static final Map<Pair<String>, Xeption> USER_XEPTIONS = new HashMap<Pair<String>, Xeption>();

    public boolean handleException(Throwable e, MessageContext ctx) throws Exception {
        if (e instanceof SoapFaultException) {
            this.checkErrors((SoapFaultException)e);
        }
        return false;
    }

    private void checkErrors(SoapFaultException sfe) {
        CraneFault cf = this.findCraneFault(sfe);
        Xeption userXeption = this.findUserXeption(cf);
        if (userXeption != null) {
            throw userXeption;
        }
        throw Xeption.forDeveloper((String)sfe.getMessage(), (Object[])new Object[0]);
    }

    private CraneFault findCraneFault(SoapFaultException sfe) {
        if (sfe.getFault() == null) {
            return null;
        }
        for (Object detail : sfe.getFault().getDetails()) {
            if (!(detail instanceof CraneFault)) continue;
            return (CraneFault)detail;
        }
        return null;
    }

    private Xeption findUserXeption(CraneFault cf) {
        if (cf == null) {
            return null;
        }
        for (Map.Entry<Pair<String>, Xeption> entry : USER_XEPTIONS.entrySet()) {
            String code = (String)entry.getKey().getFirst();
            String arg = (String)entry.getKey().getLast();
            if (!code.equals(cf.getCode()) || cf.getArgs() == null || !cf.getArgs().contains(arg)) continue;
            return entry.getValue();
        }
        return null;
    }

    static {
        USER_XEPTIONS.put((Pair<String>)new Pair((Object)"SEGMENT_HANDLE_ERROR", (Object)"SEATS_ARE_NOT_ALLOCATED"), (Xeption)new SeatsNotConfirmedException());
        USER_XEPTIONS.put((Pair<String>)new Pair((Object)"CHECK_FLIGHT_FOR_SSR_LIMIT", (Object)"INFT"), Xeption.forEndUser((String)"INFT_LIMIT_REACHED", (Object[])new Object[0]));
    }
}

