/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flyArystan;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.MaskSensitiveTraceDataHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.gds.flyArystan.FlyArystanGdsAccount;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanWsRequestParams;
import com.gridnine.xtrip.server.gds.flyArystan.IBusGdsFlyArystanContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.jaxws.IBusWsContextKeys;
import com.gridnine.xtrip.server.jaxws.WsRequest;
import com.hititcs.crane.ws.ancillary.ClientInformationType;
import com.hititcs.crane.ws.main.BasicRequestType;

public class FlyArystanWsRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        FlyArystanWsRequestParams reqParams = (FlyArystanWsRequestParams)ctx.getMandatoryObject((Enum)IBusGdsFlyArystanContextKeys.FLY_ARYSTAN_REQUEST_PARAMS);
        FlyArystanGdsAccount gdsAccount = (FlyArystanGdsAccount)accountCtr.getEntity();
        this.setClientInfotmation(reqParams.getRequest(), gdsAccount);
        this.setClientInfotmation(reqParams.getAncillaryRequest(), gdsAccount);
        this.setClientInfotmation(reqParams.getReissueRequest(), gdsAccount);
        MaskSensitiveTraceDataHelper.addMaskedValue((MessageContext)ctx, (String)gdsAccount.getPassword());
        String address = gdsAccount.getAddress() + reqParams.getUrlSuffix();
        if (TextUtil.isBlank((String)address)) {
            throw Xeption.forAdmin((String)"FlyArystan reservation system account {0} hasn't {1} connection address", (Object[])new Object[]{gdsAccount.getName(), "main"});
        }
        WsRequest request = new WsRequest();
        request.setEndpointAddress(address);
        request.setMethodName(reqParams.getMethodName());
        request.setPayload(reqParams.getPayload());
        request.setUseTrustyHostnameVerifier(true);
        request.setServiceClass(reqParams.getServiceClass());
        ctx.putObject((Enum)IBusWsContextKeys.WS_REQUEST, (Object)request);
    }

    private void setClientInfotmation(BasicRequestType req, FlyArystanGdsAccount gdsAccount) {
        if (req == null) {
            return;
        }
        com.hititcs.crane.ws.main.ClientInformationType ci = new com.hititcs.crane.ws.main.ClientInformationType();
        ci.setUserName(gdsAccount.getAccount());
        ci.setPassword(gdsAccount.getPassword());
        ci.setPreferredCurrency(DictHelper.getCode((DictionaryReference)gdsAccount.getCurrency()));
        req.setClientInformation(ci);
    }

    private void setClientInfotmation(com.hititcs.crane.ws.ancillary.BasicRequestType req, FlyArystanGdsAccount gdsAccount) {
        if (req == null) {
            return;
        }
        ClientInformationType ci = new ClientInformationType();
        ci.setUserName(gdsAccount.getAccount());
        ci.setPassword(gdsAccount.getPassword());
        ci.setPreferredCurrency(DictHelper.getCode((DictionaryReference)gdsAccount.getCurrency()));
        req.setClientInformation(ci);
    }

    private void setClientInfotmation(com.hititcs.crane.ws.reissue.BasicRequestType req, FlyArystanGdsAccount gdsAccount) {
        if (req == null) {
            return;
        }
        com.hititcs.crane.ws.reissue.ClientInformationType ci = new com.hititcs.crane.ws.reissue.ClientInformationType();
        ci.setUserName(gdsAccount.getAccount());
        ci.setPassword(gdsAccount.getPassword());
        ci.setPreferredCurrency(DictHelper.getCode((DictionaryReference)gdsAccount.getCurrency()));
        req.setClientInformation(ci);
    }
}

