/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flyArystan.cancelAncillaryFees;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanAncHelper;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanHelper;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanWsRequestParams;
import com.gridnine.xtrip.server.gds.flyArystan.IBusGdsFlyArystanContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.hititcs.crane.ws.ancillary.AncillaryOtaModifyRequestType;
import com.hititcs.crane.ws.ancillary.AncillaryRequestType;
import com.hititcs.crane.ws.ancillary.BasicRequestType;
import java.util.ArrayList;
import java.util.Collection;

public class FlyArystanDeleteSsrRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Collection products = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS);
        ctx.putObject((Enum)IBusGdsFlyArystanContextKeys.FLY_ARYSTAN_REQUEST_PARAMS, (Object)new FlyArystanWsRequestParams("deleteSsr", (BasicRequestType)this.buildRequest(reservation, products)));
    }

    private AncillaryOtaModifyRequestType buildRequest(Reservation reservation, Collection<Product> products) {
        AncillaryOtaModifyRequestType result = new AncillaryOtaModifyRequestType();
        result.setBookingReferenceID(FlyArystanAncHelper.buildBookingReferenceId(reservation));
        Product firstProduct = (Product)AirProductHelper.getAirProductsList((Reservation)reservation).get(0);
        result.setAirItinerary(FlyArystanAncHelper.buildAirItinerary(firstProduct));
        ArrayList<Traveller> travellers = new ArrayList<Traveller>();
        for (Product mco : products) {
            Traveller traveller = mco.getTraveller();
            int travellerInd = travellers.indexOf(traveller);
            if (travellerInd == -1) {
                result.getAirTravelerList().add(FlyArystanAncHelper.buildGdsTraveller(reservation, traveller));
                travellers.add(traveller);
                travellerInd = travellers.indexOf(traveller);
            }
            Segment segment = (Segment)AirProductHelper.getSegments((Collection)mco.getSegmentTariffs()).get(0);
            Integer segNumber = FlyArystanAncHelper.calcSegmentNumber(firstProduct, segment.getGdsId());
            result.getAncillaryRequestList().add(this.buildAncillaryRequest(mco, travellerInd + 1, segNumber));
        }
        return result;
    }

    private AncillaryRequestType buildAncillaryRequest(Product product, int travellerInd, int segNumber) {
        String gdsId = product.getGdsId();
        AncillaryRequestType result = new AncillaryRequestType();
        result.setSpecialServiceReferenceId(FlyArystanHelper.getMcoSsrId(gdsId));
        result.setAirTravelerSequence(travellerInd);
        result.setFlightSegmentSequence(segNumber + 1);
        result.setSsrCode(FlyArystanHelper.getMcoSsrCode(gdsId));
        result.setSsrGroup(FlyArystanHelper.getMcoSsrGroup(gdsId));
        return result;
    }
}

