/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flyArystan.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.FareDetails;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.FarePricingParameters;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlyArystanFarePricingData;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.AirlineBonusCard;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanHelper;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanWsRequestParams;
import com.gridnine.xtrip.server.gds.flyArystan.IBusGdsFlyArystanContextKeys;
import com.gridnine.xtrip.server.gds.flyArystan.createReservation.SpecialServiceRequestBuilder;
import com.gridnine.xtrip.server.gds.flyArystan.createReservation.SsrHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.jaxws.JaxWsHelper;
import com.hititcs.crane.ws.main.AirBookingRequestType;
import com.hititcs.crane.ws.main.AirItineraryType;
import com.hititcs.crane.ws.main.AirTravelerType;
import com.hititcs.crane.ws.main.AirportType;
import com.hititcs.crane.ws.main.BasicRequestType;
import com.hititcs.crane.ws.main.BookFlightSegmentType;
import com.hititcs.crane.ws.main.BookOriginDestinationOptionType;
import com.hititcs.crane.ws.main.BookOriginDestinationOptionsType;
import com.hititcs.crane.ws.main.BookingClassType;
import com.hititcs.crane.ws.main.ContactPersonType;
import com.hititcs.crane.ws.main.CountryType;
import com.hititcs.crane.ws.main.DocCodesType;
import com.hititcs.crane.ws.main.DocumentType;
import com.hititcs.crane.ws.main.EmailType;
import com.hititcs.crane.ws.main.EquipmentType;
import com.hititcs.crane.ws.main.FareInfoType;
import com.hititcs.crane.ws.main.FarePkgInfoType;
import com.hititcs.crane.ws.main.FlightSegmentType;
import com.hititcs.crane.ws.main.PassengerTypeCodeType;
import com.hititcs.crane.ws.main.PersonNameType;
import com.hititcs.crane.ws.main.PhoneNumberType;
import com.hititcs.crane.ws.main.SpecialRequestDetailsType;
import com.hititcs.crane.ws.main.SpecialServiceRequestType;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.xml.datatype.XMLGregorianCalendar;

public class FlyArystanCreateBookingRequestBuilder
extends BaseProcessor {
    private static final List<DocCodesType> SOCIAL_SECURITY_DOCUMENTS = Arrays.asList(DocCodesType.PASSPORT, DocCodesType.NATIONAL_ID);

    public void process(MessageContext ctx) {
        GdsReservationCreationParameters parameters = (GdsReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        Flight flight = parameters.getFlight();
        Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        Customer customer = (Customer)ctx.getObject((Enum)IBusMidofficeContextKeys.CUSTOMER);
        ctx.putObject((Enum)IBusGdsFlyArystanContextKeys.FLY_ARYSTAN_REQUEST_PARAMS, (Object)new FlyArystanWsRequestParams("createBooking", (BasicRequestType)this.buildRequest(flight, parameters.getGdsTravellers(), travellers, customer)));
    }

    private AirBookingRequestType buildRequest(Flight flight, List<GdsTraveller> gdsTravellers, Collection<Traveller> travellers, Customer customer) {
        AirBookingRequestType result = new AirBookingRequestType();
        result.setAirItinerary(this.buildAirItinerary(flight));
        this.fillTravellers(result, gdsTravellers, travellers, FlightHelper.getFlightSegmentsList((Flight)flight).size());
        this.fillContactData(result, customer);
        result.setRequestPurpose("MODIFY_PERMANENTLY_AND_CALC");
        return result;
    }

    private AirItineraryType buildAirItinerary(Flight flight) {
        AirItineraryType result = new AirItineraryType();
        BookOriginDestinationOptionsType bookOriginDestinationOptions = new BookOriginDestinationOptionsType();
        FlightHelper.getFlightLegs((Flight)flight).stream().map(this::buildBookOriginDestinationOption).forEach(bookOriginDestinationOptions.getBookOriginDestinationOptionList()::add);
        result.setBookOriginDestinationOptions(bookOriginDestinationOptions);
        return result;
    }

    private BookOriginDestinationOptionType buildBookOriginDestinationOption(List<FlightSegment> leg) {
        BookOriginDestinationOptionType result = new BookOriginDestinationOptionType();
        leg.stream().map(seg -> {
            try {
                return this.buildBookFlightSegment((FlightSegment)seg, leg.indexOf(seg));
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }).forEach(result.getBookFlightSegmentList()::add);
        return result;
    }

    private BookFlightSegmentType buildBookFlightSegment(FlightSegment seg, int segInd) throws ParseException {
        FareInfo adultFareInfo = seg.getFareInfos().stream().filter(fi -> DictHelper.isAdultPassengerType((DictionaryReference)fi.getPassengerType())).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find adult fareInfo for segment {0}", (Object[])new Object[]{seg.getGdsId()}));
        BookFlightSegmentType result = new BookFlightSegmentType();
        result.setActionCode("NN");
        BookingClassType bookingClass = new BookingClassType();
        bookingClass.setCabin(FlyArystanHelper.convertServiceClassToGdsCabin(seg.getServiceClass()));
        bookingClass.setResBookDesigCode(seg.getBookingClass());
        result.setBookingClass(bookingClass);
        FareInfoType gdsFareInfo = new FareInfoType();
        gdsFareInfo.setCabinClassCode(FlyArystanHelper.convertServiceClassToGdsCode(seg.getServiceClass()));
        gdsFareInfo.setFareReferenceCode(adultFareInfo.getFareBasis());
        gdsFareInfo.setFareReferenceID(FlyArystanHelper.getFareReferenceID(adultFareInfo));
        gdsFareInfo.setFlightSegmentSequence(segInd + 1);
        gdsFareInfo.setResBookDesigCode(seg.getBookingClass());
        FareDetails fareDetails = adultFareInfo.getFareDetails();
        if (fareDetails != null && fareDetails.getPricingParameters() != null) {
            FarePricingParameters pricingParameters = fareDetails.getPricingParameters();
            String brandId = pricingParameters.getBrandId();
            String fareGroupName = FlyArystanHelper.getFareGroupName(brandId);
            String pkgCode = FlyArystanHelper.getPkgCode(brandId);
            gdsFareInfo.setFareGroupName(fareGroupName);
            if (TextUtil.nonBlank((String)pkgCode)) {
                FarePkgInfoType pkgInfo = new FarePkgInfoType();
                pkgInfo.setPkgCode(pkgCode);
                FlyArystanFarePricingData flyArystanData = pricingParameters.getFlyArystanData();
                if (flyArystanData != null) {
                    if (flyArystanData.getBundleId() != null) {
                        pkgInfo.setBundleId(flyArystanData.getBundleId().longValue());
                    }
                    if (flyArystanData.getBundleFareId() != null) {
                        pkgInfo.setBundleFareId(flyArystanData.getBundleFareId().longValue());
                    }
                }
                pkgInfo.setSelected(true);
                gdsFareInfo.getFarePkgInfoList().add(pkgInfo);
            }
        }
        result.setFareInfo(gdsFareInfo);
        FlightSegmentType gdsSeg = new FlightSegmentType();
        gdsSeg.setFlightSegmentID(seg.getGdsId());
        gdsSeg.setAirline(FlyArystanHelper.buildGdsAirline((DictionaryReference<Airline>)seg.getAirline()));
        gdsSeg.setDepartureAirport(this.buildAirport((DictionaryReference<GeoLocation>)seg.getLocationBegin()));
        gdsSeg.setArrivalAirport(this.buildAirport((DictionaryReference<GeoLocation>)seg.getLocationEnd()));
        gdsSeg.setDepartureDateTime(JaxWsHelper.toGregorianLocalDateTime((Date)seg.getDateBegin()));
        gdsSeg.setArrivalDateTime(JaxWsHelper.toGregorianLocalDateTime((Date)seg.getDateEnd()));
        gdsSeg.setFlightNumber(seg.getFlightNumber());
        gdsSeg.setEquipment(this.buildEquipment((DictionaryReference<Aircraft>)seg.getBoard()));
        result.setFlightSegment(gdsSeg);
        return result;
    }

    private AirportType buildAirport(DictionaryReference<GeoLocation> locationRef) {
        AirportType result = new AirportType();
        result.setLocationCode(FlyArystanHelper.getNativeCode(locationRef));
        return result;
    }

    private EquipmentType buildEquipment(DictionaryReference<Aircraft> aircraftRef) {
        EquipmentType result = new EquipmentType();
        result.setAirEquipType(FlyArystanHelper.getNativeCode(aircraftRef));
        return result;
    }

    private void fillTravellers(AirBookingRequestType result, List<GdsTraveller> gdsTravellers, Collection<Traveller> travellers, int segmentsCount) {
        ArrayList<Traveller> infants = new ArrayList<Traveller>();
        for (GdsTraveller gdsTraveller : gdsTravellers) {
            Traveller traveller = (Traveller)Objects.requireNonNull(CollectionUtil.find(travellers, (String)gdsTraveller.getTravellerUid()));
            DictionaryReference passengerType = gdsTraveller.getPassengerType();
            if (DictHelper.isInfantPassengerType((DictionaryReference)passengerType)) {
                infants.add(traveller);
                continue;
            }
            int gdsTravellerSeq = gdsTravellers.indexOf(gdsTraveller) + 1;
            if (DictHelper.isChildPassengerTypeCategory((DictionaryReference)passengerType)) {
                this.addSsr(result, SpecialServiceRequestBuilder.newBuilder().ssrCode(PassengerTypeCodeType.CHLD.name()).explanation(SsrHelper.buildTravellerText(traveller, false)).travellerSeq(gdsTravellerSeq).build());
            }
            Passport passport = traveller.getPassport();
            XMLGregorianCalendar birthDate = JaxWsHelper.toGregorianLocalDateTime((Date)passport.getBirthday());
            String gender = FlyArystanHelper.getGender((DictionaryReference<PassengerType>)passengerType, passport.getGender());
            AirTravelerType airTraveller = new AirTravelerType();
            airTraveller.setPassengerTypeCode(FlyArystanHelper.convertPassengerTypeToGds((DictionaryReference<PassengerType>)passengerType));
            airTraveller.setPassportNumber(passport.getNumber());
            airTraveller.setPersonName(this.buildPersonName(passport));
            airTraveller.setBirthDate(birthDate);
            airTraveller.setGender(gender);
            airTraveller.setNationality(this.buildCountry((DictionaryReference<Country>)passport.getCitizenship()));
            DocCodesType docType = FlyArystanHelper.convertPassportTypeToGds(passport);
            DocumentType gdsDocument = new DocumentType();
            gdsDocument.setDocID(passport.getNumber());
            gdsDocument.setDocType(docType);
            gdsDocument.setDocHolderFormattedName(this.buildDocHolderFormattedName(passport));
            gdsDocument.setBirthDate(birthDate);
            gdsDocument.setGender(gender);
            String nationality = FlyArystanHelper.getNativeCode(passport.getCitizenship());
            gdsDocument.setDocHolderNationality(nationality);
            gdsDocument.setDocIssueCountry(nationality);
            gdsDocument.setDocExpireDate(JaxWsHelper.toGregorianLocalDate((Date)passport.getExpired()));
            airTraveller.getDocumentInfoList().add(gdsDocument);
            if (SOCIAL_SECURITY_DOCUMENTS.contains(docType)) {
                airTraveller.setSocialSecurityNumber(passport.getNumber());
            }
            ContactPersonType gdsContacts = new ContactPersonType();
            gdsContacts.setPersonName(this.buildDocHolderFormattedName(passport));
            String email = ProfileHelper.getCommunicationEmail((List)traveller.getCommunications());
            gdsContacts.setEmail(new EmailType());
            gdsContacts.getEmail().setEmail(email);
            PhoneNumberType phoneNumber = this.buildPhoneNumber(traveller.getCommunications());
            gdsContacts.setPhoneNumber(phoneNumber);
            airTraveller.setContactPerson(gdsContacts);
            airTraveller.setRequestedSeatCount(1);
            result.getAirTravelerList().add(airTraveller);
            this.addSsrs(result, traveller, gdsTravellerSeq, false);
        }
        int adultSeq = 1;
        for (Traveller infant : infants) {
            for (int segInd = 1; segInd <= segmentsCount; ++segInd) {
                this.addSsr(result, SpecialServiceRequestBuilder.newBuilder().ssrCode(PassengerTypeCodeType.INFT.name()).explanation(SsrHelper.buildTravellerText(infant, true)).travellerSeq(adultSeq).flightSegSeq(segInd).build());
            }
            this.addSsrs(result, infant, adultSeq, true);
            ++adultSeq;
        }
    }

    private void addSsr(AirBookingRequestType request, SpecialServiceRequestType ssReq) {
        if (request.getSpecialRequestDetails() == null) {
            request.setSpecialRequestDetails(new SpecialRequestDetailsType());
        }
        request.getSpecialRequestDetails().getSpecialServiceRequestList().add(ssReq);
    }

    private PersonNameType buildPersonName(Passport passport) {
        PersonNameType pn = new PersonNameType();
        if (passport != null) {
            pn.setSurname(passport.getLastName());
            pn.setGivenName(passport.getFirstName());
            pn.setMiddleName(passport.getMiddleName());
        }
        return pn;
    }

    private PersonNameType buildDocHolderFormattedName(Passport passport) {
        PersonNameType result = new PersonNameType();
        result.setSurname(passport.getLastName());
        result.setGivenName(passport.getFirstName());
        result.setMiddleName(passport.getMiddleName());
        return result;
    }

    private CountryType buildCountry(DictionaryReference<Country> countryRef) {
        CountryType result = new CountryType();
        result.setLocationCode(FlyArystanHelper.getNativeCode(countryRef));
        return result;
    }

    private PhoneNumberType buildPhoneNumber(List<Communication> communications) {
        Communication phone = ProfileHelper.getPhoneCommunication(communications);
        if (phone == null) {
            return null;
        }
        PhoneNumberType result = new PhoneNumberType();
        result.setCountryCode(ProfileHelper.normalizeCommunicationPart((String)phone.getCountryCode()));
        result.setAreaCode(ProfileHelper.normalizeCommunicationPart((String)phone.getCityCode()));
        result.setSubscriberNumber(ProfileHelper.normalizeCommunicationPart((String)phone.getSense()));
        return result;
    }

    private void addSsrs(AirBookingRequestType result, Traveller traveller, int gdsTravellerSeq, boolean isInfant) {
        Passport passport = traveller.getPassport();
        if (isInfant) {
            this.addSsr(result, SpecialServiceRequestBuilder.newBuilder().ssrCode("DOCS").explanation(SsrHelper.buildDocsText(passport, true)).travellerSeq(gdsTravellerSeq).build());
            if (FlyArystanHelper.isIdNoDocument(passport)) {
                this.addSsr(result, SpecialServiceRequestBuilder.newBuilder().ssrCode("IDNO").explanation(passport.getNumber()).travellerSeq(gdsTravellerSeq).build());
            }
        }
        for (AirlineBonusCard card : traveller.getAirlineBonusCards()) {
            if (!FlyArystanHelper.isFlyArystanAirline((DictionaryReference<Airline>)card.getAirline())) {
                throw Xeption.forAdmin((String)"\u0414\u043b\u044f \u0432\u044b\u0431\u043e\u0440\u0430 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430 \u0442\u043e\u043b\u044c\u043a\u043e \u0430/\u043a Fly Arystan", (Object[])new Object[0]);
            }
            this.addSsr(result, SpecialServiceRequestBuilder.newBuilder().ssrCode("FQTV").explanation(card.getNumber()).travellerSeq(gdsTravellerSeq).build());
        }
        traveller.getDocoInformations().forEach(doco -> this.addSsr(result, SpecialServiceRequestBuilder.newBuilder().ssrCode("DOCO").explanation(SsrHelper.buildDocoText(doco, isInfant)).travellerSeq(gdsTravellerSeq).build()));
        traveller.getDocaInformations().forEach(doca -> this.addSsr(result, SpecialServiceRequestBuilder.newBuilder().ssrCode("DOCA").explanation(SsrHelper.buildDocaText(doca, isInfant)).travellerSeq(gdsTravellerSeq).build()));
    }

    private void fillContactData(AirBookingRequestType result, Customer customer) {
        String email;
        ContactPersonType cp = new ContactPersonType();
        cp.setPersonName(this.buildPersonName(customer.getPassport()));
        PhoneNumberType phoneNumber = this.buildPhoneNumber(customer.getCommunications());
        if (phoneNumber != null) {
            cp.setPhoneNumber(phoneNumber);
        }
        if (TextUtil.nonBlank((String)(email = ProfileHelper.getCommunicationEmail((List)customer.getCommunications())))) {
            EmailType em = new EmailType();
            em.setEmail(email);
            cp.setEmail(em);
        }
        result.getContactInfoList().add(cp);
    }
}

