/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flyArystan.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SalesOriginContent;
import com.gridnine.xtrip.common.model.booking.SalesOriginProvider;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanHelper;
import com.gridnine.xtrip.server.gds.flyArystan.IBusGdsFlyArystanContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.hititcs.crane.ws.main.AirBookingResponseType;
import com.hititcs.crane.ws.main.AirBookingType;
import com.hititcs.crane.ws.main.AirReservationType;
import com.hititcs.crane.ws.main.AirTravelerType;
import com.hititcs.crane.ws.main.BookFlightSegmentType;
import com.hititcs.crane.ws.main.BookOriginDestinationOptionType;
import com.hititcs.crane.ws.main.BookingReferenceIDType;
import com.hititcs.crane.ws.main.FlightSegmentType;
import com.hititcs.crane.ws.main.TicketItemType;
import com.hititcs.crane.ws.main.TicketType;
import java.time.Duration;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.StringUtils;

public class FlyArystanCreateBookingResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GdsReservationCreationParameters parameters = (GdsReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        AirBookingResponseType response = (AirBookingResponseType)ctx.getMandatoryObject((Enum)IBusGdsFlyArystanContextKeys.FLY_ARYSTAN_RESPONSE);
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, (Object)this.buildReservation(response, parameters, travellers));
    }

    private Reservation buildReservation(AirBookingResponseType response, GdsReservationCreationParameters parameters, Collection<Traveller> travellers) throws Exception {
        List airBookings = response.getAirBookingList();
        if (airBookings.size() != 1) {
            throw Xeption.forDeveloper((String)"unsupported AirBookingList size: {0}", (Object[])new Object[]{airBookings.size()});
        }
        AirBookingType airBooking = (AirBookingType)airBookings.get(0);
        AirReservationType airReservation = airBooking.getAirReservation();
        List bookingReferenceIDs = airReservation.getBookingReferenceIDList();
        if (bookingReferenceIDs.size() != 1) {
            throw Xeption.forDeveloper((String)"unsupported BookingReferenceIDList size: {0}", (Object[])new Object[]{bookingReferenceIDs.size()});
        }
        Reservation res = new Reservation();
        Date now = new Date();
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)res, (GdsName)GdsName.FLY_ARYSTAN, (RecordLocatorType)RecordLocatorType.FLY_ARYSTAN_ID, (String)((BookingReferenceIDType)bookingReferenceIDs.get(0)).getID());
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)res, (GdsName)GdsName.FLY_ARYSTAN, (RecordLocatorType)RecordLocatorType.FLY_ARYSTAN_REFERENCE_ID, (String)((BookingReferenceIDType)bookingReferenceIDs.get(0)).getReferenceID());
        res.setPricingDate(now);
        res.setRefreshFromGdsDate(now);
        res.setResDate(now);
        res.setPqTimeLimit(MiscUtil.toDateSafe((XMLGregorianCalendar)airReservation.getTicketTimeLimit()));
        Product productTemplate = this.buildTemplateProduct(airReservation, now);
        String currency = airReservation.getArrangerInfo().getCurrency();
        for (GdsTraveller gdsTraveller : parameters.getGdsTravellers()) {
            Traveller traveller = (Traveller)CollectionUtil.find(travellers, (String)gdsTraveller.getTravellerUid());
            List<TicketItemType> ticketItems = this.findTicketItems(airBooking, traveller);
            TicketItemType mainTicketItem = ticketItems.stream().filter(ti -> ti.getType() == TicketType.E_TICKET).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find reservation system ticketItem for traveller {0}", (Object[])new Object[]{traveller.getName()}));
            Product mainProduct = this.buildProduct(productTemplate, traveller, currency, mainTicketItem, airReservation);
            mainProduct.setProductCategory(ProductCategory.AIR);
            BookingHelper.addProduct((Reservation)res, (BaseProduct)mainProduct);
            block4: for (TicketItemType ticketItem : ticketItems) {
                if (ticketItem.getType() == TicketType.E_TICKET) continue;
                switch (ticketItem.getType()) {
                    case MCO: {
                        Product product = this.buildProduct(productTemplate, traveller, currency, ticketItem, airReservation);
                        product.setProductCategory(ProductCategory.MCO);
                        product.setMcoCategory(FlyArystanHelper.getMcoCategory(ticketItem));
                        product.setMcoCancellationAllowed(false);
                        product.getRelatedProducts().add(mainProduct);
                        BookingHelper.addProduct((Reservation)res, (BaseProduct)product);
                        continue block4;
                    }
                }
                throw Xeption.forDeveloper((String)"unsupported ticketItem type {0}", (Object[])new Object[]{ticketItem.getType()});
            }
        }
        return res;
    }

    private Product buildProduct(Product productTemplate, Traveller traveller, String currency, TicketItemType ticketItem, AirReservationType airReservation) throws Exception {
        AirTravelerType airTraveler = ticketItem.getAirTraveler();
        Product product = (Product)XCloneHelper.clone((XCloneable)productTemplate, (boolean)true);
        product.setSalesOriginProvider(SalesOriginProvider.FLY_ARYSTAN);
        product.setSalesOriginContent(SalesOriginContent.FLY_ARYSTAN);
        product.setGdsId(FlyArystanHelper.buildGdsId(ticketItem, airReservation));
        product.setTravellerGdsId(airTraveler.getTravelerReferenceID());
        product.setGdsCurrency(currency);
        ProductHandler.of((BaseProduct)product).setOrReplaceTraveller((BaseProduct)product, traveller);
        ((SegmentTariff)product.getSegmentTariffs().get(0)).getSegments().removeIf(seg -> ticketItem.getCouponInfoList().stream().noneMatch(ci -> MiscUtil.equals((Object)seg.getGdsId(), (Object)FlyArystanHelper.getGdsSegmentId(ci))));
        product.setPassengerType(FlyArystanHelper.convertPassengerTypeFromGds(airTraveler.getPassengerTypeCode()));
        FlyArystanHelper.updateProduct(product, ticketItem);
        return product;
    }

    private Product buildTemplateProduct(AirReservationType airReservation, Date now) {
        Product productTemplate = new Product();
        productTemplate.setTicketType(com.gridnine.xtrip.common.model.booking.TicketType.OWN);
        productTemplate.setStatus(ProductStatus.BOOKING);
        productTemplate.setTariffType(TariffType.REGULAR);
        productTemplate.setEticket(true);
        productTemplate.setIssueDate(now);
        SegmentTariff segmentTariff = new SegmentTariff();
        for (BookOriginDestinationOptionType bookOriginDestination : airReservation.getAirItinerary().getBookOriginDestinationOptions().getBookOriginDestinationOptionList()) {
            boolean isStarting = true;
            for (BookFlightSegmentType bookFlightSegment : bookOriginDestination.getBookFlightSegmentList()) {
                segmentTariff.getSegments().add(this.buildSegment(bookFlightSegment, isStarting));
                isStarting = false;
            }
        }
        productTemplate.getSegmentTariffs().add(segmentTariff);
        FlyArystanHelper.setCarrier(productTemplate);
        return productTemplate;
    }

    private Segment buildSegment(BookFlightSegmentType bookingSeg, boolean isStarting) {
        FlightSegmentType gdsSeg = bookingSeg.getFlightSegment();
        Segment result = new Segment();
        result.setGdsId(FlyArystanHelper.getGdsSegmentId(bookingSeg));
        result.setStarting(isStarting);
        result.setAirline(FlyArystanHelper.resolveNativeCode(Airline.class, gdsSeg.getAirline().getCode()));
        result.setFlightNo(gdsSeg.getFlightNumber());
        if (gdsSeg.getOperatingAirline() != null) {
            result.setCodeShareCarrier(FlyArystanHelper.resolveNativeCode(Airline.class, gdsSeg.getOperatingAirline().getCode()));
            if (result.getAirline() != null) {
                result.setCodeShare(!result.getAirline().equals((Object)result.getCodeShareCarrier()));
            }
        } else {
            result.setCodeShareCarrier(result.getAirline());
        }
        result.setDepartureLocation(FlyArystanHelper.resolveNativeCode(GeoLocation.class, gdsSeg.getDepartureAirport().getLocationCode()));
        result.setDepartTerminal(gdsSeg.getDepartureAirport().getTerminal());
        result.setArriveLocation(FlyArystanHelper.resolveNativeCode(GeoLocation.class, gdsSeg.getArrivalAirport().getLocationCode()));
        result.setArriveTerminal(gdsSeg.getArrivalAirport().getTerminal());
        result.setStartDate(MiscUtil.toDateWithoutTimeZone((XMLGregorianCalendar)gdsSeg.getDepartureDateTime()));
        result.setEndDate(MiscUtil.toDateWithoutTimeZone((XMLGregorianCalendar)gdsSeg.getArrivalDateTime()));
        result.setBoard(FlyArystanHelper.resolveNativeCode(Aircraft.class, gdsSeg.getEquipment().getAirEquipType()));
        result.setFlightDuration(Integer.valueOf((int)Duration.parse(gdsSeg.getJourneyDuration()).toMinutes()));
        result.setClassOfSvcCode(bookingSeg.getFareInfo().getResBookDesigCode());
        result.setNotValidBefore(result.getStartDate());
        result.setNotValidAfter(result.getEndDate());
        return result;
    }

    private List<TicketItemType> findTicketItems(AirBookingType airBooking, Traveller traveller) {
        return airBooking.getTicketInfo().getTicketItemList().stream().filter(ti -> this.isSameTraveller(traveller, ti.getAirTraveler())).collect(Collectors.toList());
    }

    private boolean isSameTraveller(Traveller traveller, AirTravelerType gdsTraveler) {
        if (gdsTraveler == null) {
            return false;
        }
        Passport passport = traveller.getPassport();
        if (!MiscUtil.equals((Object)passport.getBirthday(), (Object)MiscUtil.clearTime((Date)MiscUtil.toDateWithoutTimeZone((XMLGregorianCalendar)gdsTraveler.getBirthDate())))) {
            return false;
        }
        if (!MiscUtil.equals((Object)passport.getLastName().toUpperCase(), (Object)gdsTraveler.getPersonName().getSurname())) {
            return false;
        }
        String givenName = (StringUtils.isBlank((String)passport.getMiddleName()) ? passport.getFirstName() : String.join((CharSequence)" ", passport.getFirstName(), passport.getMiddleName())).toUpperCase();
        return MiscUtil.equals((Object)givenName, (Object)gdsTraveler.getPersonName().getGivenName());
    }
}

