/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flyArystan.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanTestBase;
import com.gridnine.xtrip.server.gds.flyArystan.IBusGdsFlyArystanContextKeys;
import com.gridnine.xtrip.server.gds.flyArystan.createReservation.FlyArystanCreateBookingResponseParser;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.hititcs.crane.ws.main.CreateBookingResponse;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.junit.Test;

public class FlyArystanCreateBookingResponseParserTest
extends FlyArystanTestBase {
    private final FlyArystanCreateBookingResponseParser processor = new FlyArystanCreateBookingResponseParser();

    public void setUp() throws Exception {
        super.setUp();
        this.initDicts();
    }

    @Test
    public void testResponseParser() throws Throwable {
        this.testScenario("RESPONSE");
    }

    @Test
    public void testPkg() throws Throwable {
        this.testScenario("RESPONSE_WITH_PKG");
    }

    @Test
    public void testJibx1Unmarshalling() throws Throwable {
        CreateBookingResponse response = this.readResponseFromFile(CreateBookingResponse.class, "resp1.xml");
        System.out.println(response.getAirBookingResponse().getAirBookingList().size());
    }

    private void testScenario(String scenario) throws Exception {
        String responseFile = scenario + ".xml";
        String resultFile = scenario + "_result.xml";
        CreateBookingResponse response = this.readResponseFromFile(CreateBookingResponse.class, responseFile);
        MessageContext ctx = new MessageContext();
        ctx.putObject((Enum)IBusGdsFlyArystanContextKeys.FLY_ARYSTAN_RESPONSE, (Object)response.getAirBookingResponse());
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS, (Object)this.buildCreationParameters());
        ctx.putObject((Enum)IBusMidofficeContextKeys.TRAVELLERS, this.buildTravellers());
        this.processor.process(ctx);
        Reservation actReservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Reservation expReservation = (Reservation)this.loadXSerializable(resultFile, Reservation.class);
        this.assertReservation(expReservation, actReservation);
    }

    private GdsReservationCreationParameters buildCreationParameters() {
        GdsReservationCreationParameters result = new GdsReservationCreationParameters();
        GdsTraveller gdsTr = new GdsTraveller();
        gdsTr.setPassengerType(DictHelper.getAdultPassengerType());
        gdsTr.setTravellerUid("travellerAdult1");
        result.getGdsTravellers().add(gdsTr);
        gdsTr = new GdsTraveller();
        gdsTr.setPassengerType(DictHelper.getAdultPassengerType());
        gdsTr.setTravellerUid("travellerAdult2");
        result.getGdsTravellers().add(gdsTr);
        gdsTr = new GdsTraveller();
        gdsTr.setPassengerType(DictHelper.getChildPassengerType());
        gdsTr.setTravellerUid("travellerChild");
        result.getGdsTravellers().add(gdsTr);
        gdsTr = new GdsTraveller();
        gdsTr.setPassengerType(DictHelper.getInfantPassengerType());
        gdsTr.setTravellerUid("travellerInfant");
        result.getGdsTravellers().add(gdsTr);
        return result;
    }

    private List<Traveller> buildTravellers() throws Exception {
        ArrayList<Traveller> result = new ArrayList<Traveller>();
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
        Traveller tr = new Traveller();
        tr.setUid("travellerAdult1");
        tr.setName("Traveller adult 1");
        Passport psp = new Passport();
        psp.setLastName("PETROV");
        psp.setFirstName("PETR");
        psp.setBirthday(sdf.parse("11.11.1982"));
        tr.setPassport(psp);
        result.add(tr);
        tr = new Traveller();
        tr.setUid("travellerAdult2");
        tr.setName("Traveller adult 2");
        psp = new Passport();
        psp.setLastName("IVANOVA");
        psp.setFirstName("MARIA");
        psp.setBirthday(sdf.parse("11.11.1984"));
        tr.setPassport(psp);
        result.add(tr);
        tr = new Traveller();
        tr.setUid("travellerChild");
        tr.setName("Traveller child");
        psp = new Passport();
        psp.setLastName("PETROV");
        psp.setFirstName("CHILD");
        psp.setBirthday(sdf.parse("11.11.2012"));
        tr.setPassport(psp);
        result.add(tr);
        tr = new Traveller();
        tr.setUid("travellerInfant");
        tr.setName("Traveller infant");
        psp = new Passport();
        psp.setLastName("PETROV");
        psp.setFirstName("INFANT");
        psp.setBirthday(sdf.parse("11.11.2019"));
        tr.setPassport(psp);
        result.add(tr);
        return result;
    }
}

