/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flyArystan.createReservation;

import com.gridnine.xtrip.common.gds.model.DocaInformation;
import com.gridnine.xtrip.common.gds.model.DocoInformation;
import com.gridnine.xtrip.common.midoffice.helper.CodeTranslator;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;

public class SsrHelper {
    private static final CodeTranslator TRANSLATOR = new CodeTranslator(new String[]{CodeSystem.IATA.name()});
    private static final FastDateFormat SSR_TRAVELLER_DF = FastDateFormat.getInstance((String)"ddMMMyy", (Locale)Locale.ENGLISH);
    private static final FastDateFormat SSR_IATA_DF = FastDateFormat.getInstance((String)"ddMMMyyyy", (Locale)Locale.ENGLISH);
    private static final Map<Gender, String> DOCS_GENDERS = new HashMap<Gender, String>();
    private static final Map<PassportType, String> PASSPORT_TYPES;

    private static <D extends BaseDictionary> String getNativeCode(DictionaryReference<D> dictRef) {
        return TRANSLATOR.getNativeCode(dictRef);
    }

    public static String buildTravellerText(Traveller traveller, boolean isInfant) {
        Passport passport = traveller.getPassport();
        StringBuilder sb = new StringBuilder();
        if (isInfant) {
            sb.append(passport.getLastName()).append("/").append(passport.getFirstName()).append(" ");
        }
        sb.append(SSR_TRAVELLER_DF.format(passport.getBirthday()).toUpperCase());
        return sb.toString();
    }

    public static String buildDocoText(DocoInformation docoInfo, boolean isInfant) {
        StringBuilder sb = new StringBuilder();
        if (isInfant) {
            sb.insert(0, 'I');
        }
        if (sb.length() > 0) {
            sb.insert(0, '/');
        }
        if (docoInfo.getVisaApplicableCountry() != null) {
            sb.insert(0, SsrHelper.getNativeCode(docoInfo.getVisaApplicableCountry()));
        }
        if (sb.length() > 0) {
            sb.insert(0, '/');
        }
        if (docoInfo.getVisaIssueDate() != null) {
            sb.insert(0, SSR_IATA_DF.format(docoInfo.getVisaIssueDate()).toUpperCase());
        }
        if (sb.length() > 0) {
            sb.insert(0, '/');
        }
        if (docoInfo.getVisaIssuePlace() != null) {
            sb.insert(0, docoInfo.getVisaIssuePlace());
        }
        if (sb.length() > 0) {
            sb.insert(0, '/');
        }
        if (!TextUtil.isBlank((String)docoInfo.getVisaNumber())) {
            sb.insert(0, docoInfo.getVisaNumber());
        }
        if (sb.length() > 0) {
            sb.insert(0, '/');
        }
        if (docoInfo.isVisa()) {
            sb.insert(0, 'V');
        }
        if (sb.length() > 0) {
            sb.insert(0, '/');
        }
        StringBuilder sbPlaceOfBirth = new StringBuilder();
        if (!TextUtil.isBlank((String)docoInfo.getPlaceOfBirthCity())) {
            sbPlaceOfBirth.append(docoInfo.getPlaceOfBirthCity());
            if (!TextUtil.isBlank((String)docoInfo.getPlaceOfBirthState())) {
                sbPlaceOfBirth.append(' ');
                sbPlaceOfBirth.append(docoInfo.getPlaceOfBirthState());
            }
        }
        if (docoInfo.getPlaceOfBirthCountry() != null) {
            if (sbPlaceOfBirth.length() > 0) {
                sbPlaceOfBirth.append(' ');
            }
            sbPlaceOfBirth.append(SsrHelper.getNativeCode(docoInfo.getPlaceOfBirthCountry()));
        }
        if (sbPlaceOfBirth.length() > 0) {
            sb.insert(0, TextUtil.first((String)sbPlaceOfBirth.toString(), (int)32));
        }
        return sb.toString();
    }

    public static String buildDocaText(DocaInformation docaInfo, boolean isInfant) {
        StringBuilder sb = new StringBuilder();
        if (isInfant) {
            sb.insert(0, 'I');
        }
        if (sb.length() > 0) {
            sb.insert(0, '/');
        }
        if (!TextUtil.isBlank((String)docaInfo.getZipPostalCode())) {
            sb.insert(0, docaInfo.getZipPostalCode());
        }
        if (sb.length() > 0) {
            sb.insert(0, '/');
        }
        if (!TextUtil.isBlank((String)docaInfo.getStateProvince())) {
            sb.insert(0, docaInfo.getStateProvince());
        }
        if (sb.length() > 0) {
            sb.insert(0, '/');
        }
        if (!TextUtil.isBlank((String)docaInfo.getCity())) {
            sb.insert(0, docaInfo.getCity());
        }
        if (sb.length() > 0) {
            sb.insert(0, '/');
        }
        if (!TextUtil.isBlank((String)docaInfo.getStreet())) {
            sb.insert(0, docaInfo.getStreet());
        }
        if (sb.length() > 0) {
            sb.insert(0, '/');
        }
        sb.insert(0, SsrHelper.getNativeCode(docaInfo.getCountry()));
        sb.insert(0, '/');
        switch (docaInfo.getType()) {
            case DESTINATION: {
                sb.insert(0, 'D');
                break;
            }
            case RESIDENCE: {
                sb.insert(0, 'R');
                break;
            }
            default: {
                throw Xeption.forDeveloper((String)"unexpected doca address type", (Object[])new Object[]{docaInfo.getType()});
            }
        }
        return sb.toString();
    }

    public static String buildDocsText(Passport passport, boolean isInfant) {
        StringBuilder sb = new StringBuilder(128);
        sb.append((String)MiscUtil.guarded((Object)PASSPORT_TYPES.get(passport.getType()), (Object)"P"));
        sb.append('/');
        sb.append(SsrHelper.getNativeCode(passport.getCitizenship()));
        sb.append('/');
        sb.append(passport.getNumber());
        sb.append('/');
        sb.append(SsrHelper.getNativeCode(passport.getCitizenship()));
        sb.append('/');
        sb.append(SSR_TRAVELLER_DF.format(passport.getBirthday()).toUpperCase());
        sb.append('/');
        sb.append(DOCS_GENDERS.get(passport.getGender()));
        if (isInfant) {
            sb.append('I');
        }
        sb.append('/');
        sb.append(SSR_TRAVELLER_DF.format(passport.getExpired()).toUpperCase());
        sb.append('/');
        sb.append(SsrHelper.buildName(passport));
        return sb.toString();
    }

    private static String buildName(Passport passport) {
        StringBuilder sb = new StringBuilder();
        String surname = passport.getLastName();
        if (surname.length() <= 30) {
            sb.append(surname);
        } else {
            sb.append(surname.substring(0, 30));
        }
        sb.append('/');
        if (passport.getFirstName().length() <= 30) {
            sb.append(passport.getFirstName());
        } else {
            sb.append(passport.getFirstName().substring(0, 30));
        }
        if (!StringUtils.isBlank((String)passport.getMiddleName())) {
            sb.append('/');
            if (passport.getMiddleName().length() <= 30) {
                sb.append(passport.getMiddleName());
            } else {
                sb.append(passport.getMiddleName().substring(0, 30));
            }
        }
        if (sb.length() <= 71) {
            return sb.toString();
        }
        return sb.substring(0, 71);
    }

    static {
        DOCS_GENDERS.put(Gender.MALE, "M");
        DOCS_GENDERS.put(Gender.FEMALE, "F");
        PASSPORT_TYPES = new HashMap<PassportType, String>();
        PASSPORT_TYPES.put(PassportType.MILITARYID, "M");
        PASSPORT_TYPES.put(PassportType.ALIENRESIDENTCARD, "A");
        PASSPORT_TYPES.put(PassportType.PERMANENTRESIDENTCARD, "C");
        PASSPORT_TYPES.put(PassportType.TRAVELDOCUMENT, "T");
        PASSPORT_TYPES.put(PassportType.SERVICE_PASSPORT, "F");
        PASSPORT_TYPES.put(PassportType.FACILITATIONDOCUMENT, "F");
        PASSPORT_TYPES.put(PassportType.NATURALIZATIONCERTIFICATE, "N");
        PASSPORT_TYPES.put(PassportType.BORDERCROSSINGCARD, "V");
        PASSPORT_TYPES.put(PassportType.BIRTHDAY_NOTIFICATION, "I");
        PASSPORT_TYPES.put(PassportType.IDENTITYCARD, "I");
    }
}

