/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flyArystan.db;

import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.Set;
import org.w3c.dom.Element;

public class FlyArystanAddIataCodeToAirlineUpdateHandler
implements SetupUpdateHandler {
    public void execute(Element command) throws Exception {
        Date closeDate = Date.from(LocalDate.of(2024, 7, 1).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        Set oldAirlines = DictionaryCache.get().lookup(Airline.class, "FS", new String[]{CodeSystem.IATA.name()});
        for (Airline airline : oldAirlines) {
            airline.setCloseDate(closeDate);
            airline.setDataSource(FlyArystanAddIataCodeToAirlineUpdateHandler.class.getSimpleName());
            DictionaryStorage.get().save((BaseDictionary)airline);
        }
        Set airlines = DictionaryCache.get().lookup(Airline.class, "KC", new String[]{CodeSystem.FLY_ARYSTAN.name()});
        for (Airline airline : airlines) {
            if (airline.getCodeVariants().containsKey(CodeSystem.IATA.name())) continue;
            airline.getCodeVariants().put(CodeSystem.IATA.name(), "FS");
            airline.setDataSource(FlyArystanAddIataCodeToAirlineUpdateHandler.class.getSimpleName());
            DictionaryStorage.get().save((BaseDictionary)airline);
        }
    }
}

